/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.client.resource.v1_0;

import com.liferay.headless.delivery.client.dto.v1_0.KnowledgeBaseFolder;
import com.liferay.headless.delivery.client.http.HttpInvoker;
import com.liferay.headless.delivery.client.pagination.Page;
import com.liferay.headless.delivery.client.pagination.Pagination;
import com.liferay.headless.delivery.client.permission.Permission;
import com.liferay.headless.delivery.client.problem.Problem;
import com.liferay.headless.delivery.client.serdes.v1_0.KnowledgeBaseFolderSerDes;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface KnowledgeBaseFolderResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deleteKnowledgeBaseFolder(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteKnowledgeBaseFolderHttpResponse(Long var1) throws Exception;

    public void deleteKnowledgeBaseFolderBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse deleteKnowledgeBaseFolderBatchHttpResponse(String var1, Object var2) throws Exception;

    public void deleteSiteKnowledgeBaseFolderByExternalReferenceCode(Long var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse deleteSiteKnowledgeBaseFolderByExternalReferenceCodeHttpResponse(Long var1, String var2) throws Exception;

    public KnowledgeBaseFolder getKnowledgeBaseFolder(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getKnowledgeBaseFolderHttpResponse(Long var1) throws Exception;

    public Page<KnowledgeBaseFolder> getKnowledgeBaseFolderKnowledgeBaseFoldersPage(Long var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getKnowledgeBaseFolderKnowledgeBaseFoldersPageHttpResponse(Long var1, Pagination var2) throws Exception;

    public Page<Permission> getKnowledgeBaseFolderPermissionsPage(Long var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse getKnowledgeBaseFolderPermissionsPageHttpResponse(Long var1, String var2) throws Exception;

    public KnowledgeBaseFolder getSiteKnowledgeBaseFolderByExternalReferenceCode(Long var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse getSiteKnowledgeBaseFolderByExternalReferenceCodeHttpResponse(Long var1, String var2) throws Exception;

    public Page<Permission> getSiteKnowledgeBaseFolderPermissionsPage(Long var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse getSiteKnowledgeBaseFolderPermissionsPageHttpResponse(Long var1, String var2) throws Exception;

    public Page<KnowledgeBaseFolder> getSiteKnowledgeBaseFoldersPage(Long var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getSiteKnowledgeBaseFoldersPageHttpResponse(Long var1, Pagination var2) throws Exception;

    public KnowledgeBaseFolder patchKnowledgeBaseFolder(Long var1, KnowledgeBaseFolder var2) throws Exception;

    public HttpInvoker.HttpResponse patchKnowledgeBaseFolderHttpResponse(Long var1, KnowledgeBaseFolder var2) throws Exception;

    public KnowledgeBaseFolder postKnowledgeBaseFolderKnowledgeBaseFolder(Long var1, KnowledgeBaseFolder var2) throws Exception;

    public HttpInvoker.HttpResponse postKnowledgeBaseFolderKnowledgeBaseFolderHttpResponse(Long var1, KnowledgeBaseFolder var2) throws Exception;

    public KnowledgeBaseFolder postSiteKnowledgeBaseFolder(Long var1, KnowledgeBaseFolder var2) throws Exception;

    public HttpInvoker.HttpResponse postSiteKnowledgeBaseFolderHttpResponse(Long var1, KnowledgeBaseFolder var2) throws Exception;

    public void postSiteKnowledgeBaseFolderBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse postSiteKnowledgeBaseFolderBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public void postSiteKnowledgeBaseFoldersPageExportBatch(Long var1, String var2, String var3, String var4) throws Exception;

    public HttpInvoker.HttpResponse postSiteKnowledgeBaseFoldersPageExportBatchHttpResponse(Long var1, String var2, String var3, String var4) throws Exception;

    public KnowledgeBaseFolder putKnowledgeBaseFolder(Long var1, KnowledgeBaseFolder var2) throws Exception;

    public HttpInvoker.HttpResponse putKnowledgeBaseFolderHttpResponse(Long var1, KnowledgeBaseFolder var2) throws Exception;

    public void putKnowledgeBaseFolderBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse putKnowledgeBaseFolderBatchHttpResponse(String var1, Object var2) throws Exception;

    public Page<Permission> putKnowledgeBaseFolderPermissionsPage(Long var1, Permission[] var2) throws Exception;

    public HttpInvoker.HttpResponse putKnowledgeBaseFolderPermissionsPageHttpResponse(Long var1, Permission[] var2) throws Exception;

    public KnowledgeBaseFolder putSiteKnowledgeBaseFolderByExternalReferenceCode(Long var1, String var2, KnowledgeBaseFolder var3) throws Exception;

    public HttpInvoker.HttpResponse putSiteKnowledgeBaseFolderByExternalReferenceCodeHttpResponse(Long var1, String var2, KnowledgeBaseFolder var3) throws Exception;

    public Page<Permission> putSiteKnowledgeBaseFolderPermissionsPage(Long var1, Permission[] var2) throws Exception;

    public HttpInvoker.HttpResponse putSiteKnowledgeBaseFolderPermissionsPageHttpResponse(Long var1, Permission[] var2) throws Exception;

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login;
        private String _password;
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public KnowledgeBaseFolderResource build() {
            return new KnowledgeBaseFolderResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder endpoint(URL url) {
            return this.endpoint(url.getHost(), url.getPort(), url.getProtocol());
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }

    public static class KnowledgeBaseFolderResourceImpl
    implements KnowledgeBaseFolderResource {
        private static final Logger _logger = Logger.getLogger(KnowledgeBaseFolderResource.class.getName());
        private Builder _builder;

        @Override
        public void deleteKnowledgeBaseFolder(Long knowledgeBaseFolderId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteKnowledgeBaseFolderHttpResponse(knowledgeBaseFolderId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteKnowledgeBaseFolderHttpResponse(Long knowledgeBaseFolderId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/{knowledgeBaseFolderId}");
            httpInvoker.path("knowledgeBaseFolderId", knowledgeBaseFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void deleteKnowledgeBaseFolderBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteKnowledgeBaseFolderBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteKnowledgeBaseFolderBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/batch");
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void deleteSiteKnowledgeBaseFolderByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteSiteKnowledgeBaseFolderByExternalReferenceCodeHttpResponse(siteId, externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteSiteKnowledgeBaseFolderByExternalReferenceCodeHttpResponse(Long siteId, String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/knowledge-base-folders/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("siteId", siteId);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public KnowledgeBaseFolder getKnowledgeBaseFolder(Long knowledgeBaseFolderId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getKnowledgeBaseFolderHttpResponse(knowledgeBaseFolderId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return KnowledgeBaseFolderSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getKnowledgeBaseFolderHttpResponse(Long knowledgeBaseFolderId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/{knowledgeBaseFolderId}");
            httpInvoker.path("knowledgeBaseFolderId", knowledgeBaseFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<KnowledgeBaseFolder> getKnowledgeBaseFolderKnowledgeBaseFoldersPage(Long parentKnowledgeBaseFolderId, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getKnowledgeBaseFolderKnowledgeBaseFoldersPageHttpResponse(parentKnowledgeBaseFolderId, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, KnowledgeBaseFolderSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getKnowledgeBaseFolderKnowledgeBaseFoldersPageHttpResponse(Long parentKnowledgeBaseFolderId, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/{parentKnowledgeBaseFolderId}/knowledge-base-folders");
            httpInvoker.path("parentKnowledgeBaseFolderId", parentKnowledgeBaseFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<Permission> getKnowledgeBaseFolderPermissionsPage(Long knowledgeBaseFolderId, String roleNames) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getKnowledgeBaseFolderPermissionsPageHttpResponse(knowledgeBaseFolderId, roleNames);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, Permission::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getKnowledgeBaseFolderPermissionsPageHttpResponse(Long knowledgeBaseFolderId, String roleNames) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (roleNames != null) {
                httpInvoker.parameter("roleNames", String.valueOf(roleNames));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/{knowledgeBaseFolderId}/permissions");
            httpInvoker.path("knowledgeBaseFolderId", knowledgeBaseFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public KnowledgeBaseFolder getSiteKnowledgeBaseFolderByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSiteKnowledgeBaseFolderByExternalReferenceCodeHttpResponse(siteId, externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return KnowledgeBaseFolderSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSiteKnowledgeBaseFolderByExternalReferenceCodeHttpResponse(Long siteId, String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/knowledge-base-folders/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("siteId", siteId);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<Permission> getSiteKnowledgeBaseFolderPermissionsPage(Long siteId, String roleNames) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSiteKnowledgeBaseFolderPermissionsPageHttpResponse(siteId, roleNames);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, Permission::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSiteKnowledgeBaseFolderPermissionsPageHttpResponse(Long siteId, String roleNames) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (roleNames != null) {
                httpInvoker.parameter("roleNames", String.valueOf(roleNames));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/knowledge-base-folders/permissions");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<KnowledgeBaseFolder> getSiteKnowledgeBaseFoldersPage(Long siteId, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSiteKnowledgeBaseFoldersPageHttpResponse(siteId, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, KnowledgeBaseFolderSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSiteKnowledgeBaseFoldersPageHttpResponse(Long siteId, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/knowledge-base-folders");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public KnowledgeBaseFolder patchKnowledgeBaseFolder(Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchKnowledgeBaseFolderHttpResponse(knowledgeBaseFolderId, knowledgeBaseFolder);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return KnowledgeBaseFolderSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse patchKnowledgeBaseFolderHttpResponse(Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(knowledgeBaseFolder.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/{knowledgeBaseFolderId}");
            httpInvoker.path("knowledgeBaseFolderId", knowledgeBaseFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public KnowledgeBaseFolder postKnowledgeBaseFolderKnowledgeBaseFolder(Long parentKnowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postKnowledgeBaseFolderKnowledgeBaseFolderHttpResponse(parentKnowledgeBaseFolderId, knowledgeBaseFolder);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return KnowledgeBaseFolderSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postKnowledgeBaseFolderKnowledgeBaseFolderHttpResponse(Long parentKnowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(knowledgeBaseFolder.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/{parentKnowledgeBaseFolderId}/knowledge-base-folders");
            httpInvoker.path("parentKnowledgeBaseFolderId", parentKnowledgeBaseFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public KnowledgeBaseFolder postSiteKnowledgeBaseFolder(Long siteId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSiteKnowledgeBaseFolderHttpResponse(siteId, knowledgeBaseFolder);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return KnowledgeBaseFolderSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postSiteKnowledgeBaseFolderHttpResponse(Long siteId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(knowledgeBaseFolder.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/knowledge-base-folders");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void postSiteKnowledgeBaseFolderBatch(Long siteId, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSiteKnowledgeBaseFolderBatchHttpResponse(siteId, callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postSiteKnowledgeBaseFolderBatchHttpResponse(Long siteId, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/knowledge-base-folders/batch");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void postSiteKnowledgeBaseFoldersPageExportBatch(Long siteId, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSiteKnowledgeBaseFoldersPageExportBatchHttpResponse(siteId, callbackURL, contentType, fieldNames);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postSiteKnowledgeBaseFoldersPageExportBatchHttpResponse(Long siteId, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body("[]", "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (contentType != null) {
                httpInvoker.parameter("contentType", String.valueOf(contentType));
            }
            if (fieldNames != null) {
                httpInvoker.parameter("fieldNames", String.valueOf(fieldNames));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/knowledge-base-folders/export-batch");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public KnowledgeBaseFolder putKnowledgeBaseFolder(Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putKnowledgeBaseFolderHttpResponse(knowledgeBaseFolderId, knowledgeBaseFolder);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return KnowledgeBaseFolderSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putKnowledgeBaseFolderHttpResponse(Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(knowledgeBaseFolder.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/{knowledgeBaseFolderId}");
            httpInvoker.path("knowledgeBaseFolderId", knowledgeBaseFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void putKnowledgeBaseFolderBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putKnowledgeBaseFolderBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse putKnowledgeBaseFolderBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/batch");
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<Permission> putKnowledgeBaseFolderPermissionsPage(Long knowledgeBaseFolderId, Permission[] permissions) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putKnowledgeBaseFolderPermissionsPageHttpResponse(knowledgeBaseFolderId, permissions);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, Permission::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putKnowledgeBaseFolderPermissionsPageHttpResponse(Long knowledgeBaseFolderId, Permission[] permissions) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            ArrayList<String> values = new ArrayList<String>();
            for (Permission permissionValue : permissions) {
                values.add(String.valueOf(permissionValue));
            }
            httpInvoker.body(((Object)values).toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/knowledge-base-folders/{knowledgeBaseFolderId}/permissions");
            httpInvoker.path("knowledgeBaseFolderId", knowledgeBaseFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public KnowledgeBaseFolder putSiteKnowledgeBaseFolderByExternalReferenceCode(Long siteId, String externalReferenceCode, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putSiteKnowledgeBaseFolderByExternalReferenceCodeHttpResponse(siteId, externalReferenceCode, knowledgeBaseFolder);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return KnowledgeBaseFolderSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putSiteKnowledgeBaseFolderByExternalReferenceCodeHttpResponse(Long siteId, String externalReferenceCode, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(knowledgeBaseFolder.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/knowledge-base-folders/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("siteId", siteId);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<Permission> putSiteKnowledgeBaseFolderPermissionsPage(Long siteId, Permission[] permissions) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putSiteKnowledgeBaseFolderPermissionsPageHttpResponse(siteId, permissions);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, Permission::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putSiteKnowledgeBaseFolderPermissionsPageHttpResponse(Long siteId, Permission[] permissions) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            ArrayList<String> values = new ArrayList<String>();
            for (Permission permissionValue : permissions) {
                values.add(String.valueOf(permissionValue));
            }
            httpInvoker.body(((Object)values).toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/knowledge-base-folders/permissions");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        private KnowledgeBaseFolderResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }
}

