/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.client.serdes.v1_0;

import com.liferay.headless.delivery.client.dto.v1_0.DataLayout;
import com.liferay.headless.delivery.client.dto.v1_0.DataLayoutPage;
import com.liferay.headless.delivery.client.dto.v1_0.DataRule;
import com.liferay.headless.delivery.client.json.BaseJSONParser;
import com.liferay.headless.delivery.client.serdes.v1_0.DataLayoutPageSerDes;
import com.liferay.headless.delivery.client.serdes.v1_0.DataRuleSerDes;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class DataLayoutSerDes {
    public static DataLayout toDTO(String json) {
        DataLayoutJSONParser dataLayoutJSONParser = new DataLayoutJSONParser();
        return (DataLayout)dataLayoutJSONParser.parseToDTO(json);
    }

    public static DataLayout[] toDTOs(String json) {
        DataLayoutJSONParser dataLayoutJSONParser = new DataLayoutJSONParser();
        return (DataLayout[])dataLayoutJSONParser.parseToDTOs(json);
    }

    public static String toJSON(DataLayout dataLayout) {
        int i;
        if (dataLayout == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (dataLayout.getContentType() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentType\": ");
            sb.append("\"");
            sb.append(DataLayoutSerDes._escape(dataLayout.getContentType()));
            sb.append("\"");
        }
        if (dataLayout.getDataDefinitionId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dataDefinitionId\": ");
            sb.append(dataLayout.getDataDefinitionId());
        }
        if (dataLayout.getDataLayoutFields() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dataLayoutFields\": ");
            sb.append(DataLayoutSerDes._toJSON(dataLayout.getDataLayoutFields()));
        }
        if (dataLayout.getDataLayoutKey() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dataLayoutKey\": ");
            sb.append("\"");
            sb.append(DataLayoutSerDes._escape(dataLayout.getDataLayoutKey()));
            sb.append("\"");
        }
        if (dataLayout.getDataLayoutPages() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dataLayoutPages\": ");
            sb.append("[");
            for (i = 0; i < dataLayout.getDataLayoutPages().length; ++i) {
                sb.append(dataLayout.getDataLayoutPages()[i]);
                if (i + 1 >= dataLayout.getDataLayoutPages().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (dataLayout.getDataRules() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dataRules\": ");
            sb.append("[");
            for (i = 0; i < dataLayout.getDataRules().length; ++i) {
                sb.append(dataLayout.getDataRules()[i]);
                if (i + 1 >= dataLayout.getDataRules().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (dataLayout.getDateCreated() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dataLayout.getDateCreated()));
            sb.append("\"");
        }
        if (dataLayout.getDateModified() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dataLayout.getDateModified()));
            sb.append("\"");
        }
        if (dataLayout.getDescription() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append(DataLayoutSerDes._toJSON(dataLayout.getDescription()));
        }
        if (dataLayout.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(dataLayout.getId());
        }
        if (dataLayout.getName() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append(DataLayoutSerDes._toJSON(dataLayout.getName()));
        }
        if (dataLayout.getPaginationMode() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"paginationMode\": ");
            sb.append("\"");
            sb.append(DataLayoutSerDes._escape(dataLayout.getPaginationMode()));
            sb.append("\"");
        }
        if (dataLayout.getSiteId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append(dataLayout.getSiteId());
        }
        if (dataLayout.getUserId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userId\": ");
            sb.append(dataLayout.getUserId());
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        DataLayoutJSONParser dataLayoutJSONParser = new DataLayoutJSONParser();
        return dataLayoutJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(DataLayout dataLayout) {
        if (dataLayout == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (dataLayout.getContentType() == null) {
            map.put("contentType", null);
        } else {
            map.put("contentType", String.valueOf(dataLayout.getContentType()));
        }
        if (dataLayout.getDataDefinitionId() == null) {
            map.put("dataDefinitionId", null);
        } else {
            map.put("dataDefinitionId", String.valueOf(dataLayout.getDataDefinitionId()));
        }
        if (dataLayout.getDataLayoutFields() == null) {
            map.put("dataLayoutFields", null);
        } else {
            map.put("dataLayoutFields", String.valueOf(dataLayout.getDataLayoutFields()));
        }
        if (dataLayout.getDataLayoutKey() == null) {
            map.put("dataLayoutKey", null);
        } else {
            map.put("dataLayoutKey", String.valueOf(dataLayout.getDataLayoutKey()));
        }
        if (dataLayout.getDataLayoutPages() == null) {
            map.put("dataLayoutPages", null);
        } else {
            map.put("dataLayoutPages", String.valueOf(dataLayout.getDataLayoutPages()));
        }
        if (dataLayout.getDataRules() == null) {
            map.put("dataRules", null);
        } else {
            map.put("dataRules", String.valueOf(dataLayout.getDataRules()));
        }
        if (dataLayout.getDateCreated() == null) {
            map.put("dateCreated", null);
        } else {
            map.put("dateCreated", liferayToJSONDateFormat.format(dataLayout.getDateCreated()));
        }
        if (dataLayout.getDateModified() == null) {
            map.put("dateModified", null);
        } else {
            map.put("dateModified", liferayToJSONDateFormat.format(dataLayout.getDateModified()));
        }
        if (dataLayout.getDescription() == null) {
            map.put("description", null);
        } else {
            map.put("description", String.valueOf(dataLayout.getDescription()));
        }
        if (dataLayout.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(dataLayout.getId()));
        }
        if (dataLayout.getName() == null) {
            map.put("name", null);
        } else {
            map.put("name", String.valueOf(dataLayout.getName()));
        }
        if (dataLayout.getPaginationMode() == null) {
            map.put("paginationMode", null);
        } else {
            map.put("paginationMode", String.valueOf(dataLayout.getPaginationMode()));
        }
        if (dataLayout.getSiteId() == null) {
            map.put("siteId", null);
        } else {
            map.put("siteId", String.valueOf(dataLayout.getSiteId()));
        }
        if (dataLayout.getUserId() == null) {
            map.put("userId", null);
        } else {
            map.put("userId", String.valueOf(dataLayout.getUserId()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            sb.append(DataLayoutSerDes._toJSON(value));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _toJSON(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Map) {
            return DataLayoutSerDes._toJSON((Map)value);
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            StringBuilder sb = new StringBuilder("[");
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(DataLayoutSerDes._toJSON(values[i]));
                if (i + 1 >= values.length) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        if (value instanceof String) {
            return "\"" + DataLayoutSerDes._escape(value) + "\"";
        }
        return String.valueOf(value);
    }

    public static class DataLayoutJSONParser
    extends BaseJSONParser<DataLayout> {
        @Override
        protected DataLayout createDTO() {
            return new DataLayout();
        }

        protected DataLayout[] createDTOArray(int size) {
            return new DataLayout[size];
        }

        @Override
        protected boolean parseMaps(String jsonParserFieldName) {
            if (Objects.equals(jsonParserFieldName, "contentType")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "dataDefinitionId")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "dataLayoutFields")) {
                return true;
            }
            if (Objects.equals(jsonParserFieldName, "dataLayoutKey")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "dataLayoutPages")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "dataRules")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "dateCreated")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "dateModified")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "description")) {
                return true;
            }
            if (Objects.equals(jsonParserFieldName, "id")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "name")) {
                return true;
            }
            if (Objects.equals(jsonParserFieldName, "paginationMode")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "siteId")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "userId")) {
                return false;
            }
            return false;
        }

        @Override
        protected void setField(DataLayout dataLayout, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "contentType")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setContentType((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "dataDefinitionId")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setDataDefinitionId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dataLayoutFields")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setDataLayoutFields((Map)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "dataLayoutKey")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setDataLayoutKey((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "dataLayoutPages")) {
                if (jsonParserFieldValue != null) {
                    Object[] jsonParserFieldValues = (Object[])jsonParserFieldValue;
                    DataLayoutPage[] dataLayoutPagesArray = new DataLayoutPage[jsonParserFieldValues.length];
                    for (int i = 0; i < dataLayoutPagesArray.length; ++i) {
                        dataLayoutPagesArray[i] = DataLayoutPageSerDes.toDTO((String)jsonParserFieldValues[i]);
                    }
                    dataLayout.setDataLayoutPages(dataLayoutPagesArray);
                }
            } else if (Objects.equals(jsonParserFieldName, "dataRules")) {
                if (jsonParserFieldValue != null) {
                    Object[] jsonParserFieldValues = (Object[])jsonParserFieldValue;
                    DataRule[] dataRulesArray = new DataRule[jsonParserFieldValues.length];
                    for (int i = 0; i < dataRulesArray.length; ++i) {
                        dataRulesArray[i] = DataRuleSerDes.toDTO((String)jsonParserFieldValues[i]);
                    }
                    dataLayout.setDataRules(dataRulesArray);
                }
            } else if (Objects.equals(jsonParserFieldName, "dateCreated")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setDateCreated(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateModified")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setDateModified(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "description")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setDescription((Map)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "name")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setName((Map)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "paginationMode")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setPaginationMode((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "siteId")) {
                if (jsonParserFieldValue != null) {
                    dataLayout.setSiteId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "userId") && jsonParserFieldValue != null) {
                dataLayout.setUserId(Long.valueOf((String)jsonParserFieldValue));
            }
        }
    }
}

