/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.internal.dto.v1_0.util.DDMValueUtil;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;

public class DDMFormValuesUtil {
    public static DDMFormValues toDDMFormValues(ContentField[] contentFields, final DDMForm ddmForm, final DLAppService dlAppService, final long groupId, final JournalArticleService journalArticleService, final LayoutLocalService layoutLocalService, final Locale locale, final List<DDMFormField> rootDDMFormFields) {
        final Map contentFieldMap = Optional.ofNullable(contentFields).map(fields -> DDMFormValuesUtil._toContentFieldsMap(Stream.of(fields))).orElse(new HashMap());
        return new DDMFormValues(ddmForm){
            {
                super(x0);
                this.setAvailableLocales(ddmForm.getAvailableLocales());
                this.setDDMFormFieldValues(DDMFormValuesUtil._flattenDDMFormFieldValues(rootDDMFormFields, (UnsafeFunction<DDMFormField, List<DDMFormFieldValue>, Exception>)ddmFormField -> DDMFormValuesUtil._toDDMFormFieldValues((List)contentFieldMap.get(ddmFormField.getName()), ddmFormField, dlAppService, groupId, journalArticleService, layoutLocalService, locale)));
                this.setDefaultLocale(ddmForm.getDefaultLocale());
            }
        };
    }

    private static List<DDMFormFieldValue> _flattenDDMFormFieldValues(List<DDMFormField> ddmFormFields, UnsafeFunction<DDMFormField, List<DDMFormFieldValue>, Exception> unsafeFunction) {
        if (ListUtil.isEmpty(ddmFormFields)) {
            return Collections.emptyList();
        }
        Stream stream = ddmFormFields.stream();
        return stream.map(ddmFormField -> {
            try {
                return (List)unsafeFunction.apply(ddmFormField);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Map<String, List<ContentField>> _toContentFieldsMap(Stream<ContentField> stream) {
        return stream.collect(Collectors.groupingBy(ContentField::getName));
    }

    private static DDMFormFieldValue _toDDMFormFieldValue(List<ContentField> contentFields, final DDMFormField ddmFormField, final DLAppService dlAppService, final long groupId, final JournalArticleService journalArticleService, final LayoutLocalService layoutLocalService, final Locale locale, final Value value) {
        final Map<String, List<ContentField>> contentFieldMap = DDMFormValuesUtil._toContentFieldsMap(contentFields.stream());
        return new DDMFormFieldValue(){
            {
                this.setName(ddmFormField.getName());
                this.setNestedDDMFormFields(DDMFormValuesUtil._flattenDDMFormFieldValues(ddmFormField.getNestedDDMFormFields(), (UnsafeFunction<DDMFormField, List<DDMFormFieldValue>, Exception>)field -> DDMFormValuesUtil._toDDMFormFieldValues((List)contentFieldMap.get(field.getName()), field, dlAppService, groupId, journalArticleService, layoutLocalService, locale)));
                this.setValue(value);
            }
        };
    }

    private static List<DDMFormFieldValue> _toDDMFormFieldValues(List<ContentField> contentFields, DDMFormField ddmFormField, DLAppService dlAppService, long groupId, JournalArticleService journalArticleService, LayoutLocalService layoutLocalService, Locale locale) {
        if (ListUtil.isEmpty(contentFields)) {
            if (ddmFormField.isRequired()) {
                throw new BadRequestException("No value is specified for field " + ddmFormField.getName());
            }
            return Collections.singletonList(DDMFormValuesUtil._toDDMFormFieldValue(Collections.emptyList(), ddmFormField, dlAppService, groupId, journalArticleService, layoutLocalService, locale, DDMFormValuesUtil._toValue(ddmFormField, locale)));
        }
        return TransformUtil.transform(contentFields, contentField -> DDMFormValuesUtil._toDDMFormFieldValue(ListUtil.fromArray((Object[])contentField.getNestedContentFields()), ddmFormField, dlAppService, groupId, journalArticleService, layoutLocalService, locale, DDMValueUtil.toDDMValue(contentField, ddmFormField, dlAppService, groupId, journalArticleService, layoutLocalService, locale)));
    }

    private static Value _toValue(DDMFormField ddmFormField, final Locale locale) {
        if (Objects.equals("ddm-separator", ddmFormField.getType())) {
            return null;
        }
        LocalizedValue localizedValue = ddmFormField.getPredefinedValue();
        final String valueString = localizedValue.getString(localizedValue.getDefaultLocale());
        if (ddmFormField.isLocalizable()) {
            return new LocalizedValue(locale){
                {
                    super(x0);
                    this.addString(locale, valueString);
                }
            };
        }
        return new UnlocalizedValue(valueString);
    }
}

