/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseStructuredContentResourceImpl
implements EntityModelResource,
StructuredContentResource,
VulcanBatchEngineTaskItemDelegate<StructuredContent> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseStructuredContentResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    public Page<StructuredContent> getAssetLibraryStructuredContentsPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-contents")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public StructuredContent postAssetLibraryStructuredContent(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json"})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-contents/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAssetLibraryStructuredContentBatch(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(StructuredContent.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Retrieves a list of the content structure's structured content. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="contentStructureId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/content-structures/{contentStructureId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    public Page<StructuredContent> getContentStructureStructuredContentsPage(@Parameter(hidden=true) @NotNull @PathParam(value="contentStructureId") Long contentStructureId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the site's structured content. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/sites/{siteId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    public Page<StructuredContent> getSiteStructuredContentsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new structured content.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/structured-contents")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public StructuredContent postSiteStructuredContent(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteId}/structured-contents/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteStructuredContentBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(StructuredContent.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Retrieves a structured content by its key (`articleKey`).")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="key")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/sites/{siteId}/structured-contents/by-key/{key}")
    @Produces(value={"application/json", "application/xml"})
    public StructuredContent getSiteStructuredContentByKey(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="key") String key) throws Exception {
        return new StructuredContent();
    }

    @Operation(description="Retrieves a structured content by its UUID.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="uuid")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/sites/{siteId}/structured-contents/by-uuid/{uuid}")
    @Produces(value={"application/json", "application/xml"})
    public StructuredContent getSiteStructuredContentByUuid(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="uuid") String uuid) throws Exception {
        return new StructuredContent();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/sites/{siteId}/structured-contents/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteStructuredContentPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteStructuredContentPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteStructuredContentPermissionsPage", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Path(value="/sites/{siteId}/structured-contents/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteStructuredContentPermission(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the folder's structured content. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/structured-content-folders/{structuredContentFolderId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    public Page<StructuredContent> getStructuredContentFolderStructuredContentsPage(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new structured content in the folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/structured-content-folders/{structuredContentFolderId}/structured-contents")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public StructuredContent postStructuredContentFolderStructuredContent(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json"})
    @Path(value="/structured-content-folders/{structuredContentFolderId}/structured-contents/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postStructuredContentFolderStructuredContentBatch(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(StructuredContent.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes the structured content and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @DELETE
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteStructuredContent(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/structured-contents/batch")
    @Produces(value={"application/json"})
    public Response deleteStructuredContentBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(StructuredContent.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the structured content via its ID.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    public StructuredContent getStructuredContent(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
        return new StructuredContent();
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    public StructuredContent patchStructuredContent(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId, StructuredContent structuredContent) throws Exception {
        StructuredContent existingStructuredContent = this.getStructuredContent(structuredContentId);
        if (structuredContent.getActions() != null) {
            existingStructuredContent.setActions(structuredContent.getActions());
        }
        if (structuredContent.getAssetLibraryKey() != null) {
            existingStructuredContent.setAssetLibraryKey(structuredContent.getAssetLibraryKey());
        }
        if (structuredContent.getAvailableLanguages() != null) {
            existingStructuredContent.setAvailableLanguages(structuredContent.getAvailableLanguages());
        }
        if (structuredContent.getContentStructureId() != null) {
            existingStructuredContent.setContentStructureId(structuredContent.getContentStructureId());
        }
        if (structuredContent.getDateCreated() != null) {
            existingStructuredContent.setDateCreated(structuredContent.getDateCreated());
        }
        if (structuredContent.getDateModified() != null) {
            existingStructuredContent.setDateModified(structuredContent.getDateModified());
        }
        if (structuredContent.getDatePublished() != null) {
            existingStructuredContent.setDatePublished(structuredContent.getDatePublished());
        }
        if (structuredContent.getDescription() != null) {
            existingStructuredContent.setDescription(structuredContent.getDescription());
        }
        if (structuredContent.getDescription_i18n() != null) {
            existingStructuredContent.setDescription_i18n(structuredContent.getDescription_i18n());
        }
        if (structuredContent.getFriendlyUrlPath() != null) {
            existingStructuredContent.setFriendlyUrlPath(structuredContent.getFriendlyUrlPath());
        }
        if (structuredContent.getFriendlyUrlPath_i18n() != null) {
            existingStructuredContent.setFriendlyUrlPath_i18n(structuredContent.getFriendlyUrlPath_i18n());
        }
        if (structuredContent.getKey() != null) {
            existingStructuredContent.setKey(structuredContent.getKey());
        }
        if (structuredContent.getKeywords() != null) {
            existingStructuredContent.setKeywords(structuredContent.getKeywords());
        }
        if (structuredContent.getNumberOfComments() != null) {
            existingStructuredContent.setNumberOfComments(structuredContent.getNumberOfComments());
        }
        if (structuredContent.getSiteId() != null) {
            existingStructuredContent.setSiteId(structuredContent.getSiteId());
        }
        if (structuredContent.getSubscribed() != null) {
            existingStructuredContent.setSubscribed(structuredContent.getSubscribed());
        }
        if (structuredContent.getTaxonomyCategoryIds() != null) {
            existingStructuredContent.setTaxonomyCategoryIds(structuredContent.getTaxonomyCategoryIds());
        }
        if (structuredContent.getTitle() != null) {
            existingStructuredContent.setTitle(structuredContent.getTitle());
        }
        if (structuredContent.getTitle_i18n() != null) {
            existingStructuredContent.setTitle_i18n(structuredContent.getTitle_i18n());
        }
        if (structuredContent.getUuid() != null) {
            existingStructuredContent.setUuid(structuredContent.getUuid());
        }
        if (structuredContent.getViewableBy() != null) {
            existingStructuredContent.setViewableBy(structuredContent.getViewableBy());
        }
        this.preparePatch(structuredContent, existingStructuredContent);
        return this.putStructuredContent(structuredContentId, existingStructuredContent);
    }

    @Operation(description="Replaces the structured content with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public StructuredContent putStructuredContent(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json"})
    @Path(value="/structured-contents/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putStructuredContentBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(StructuredContent.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Deletes the structured content's rating and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @DELETE
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public void deleteStructuredContentMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    @Operation(description="Retrieves the structured content's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public Rating getStructuredContentMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
        return new Rating();
    }

    @Operation(description="Create a rating for the structured content.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Rating postStructuredContentMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId, Rating rating) throws Exception {
        return new Rating();
    }

    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Rating putStructuredContentMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId, Rating rating) throws Exception {
        return new Rating();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/structured-contents/{structuredContentId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getStructuredContentPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(structuredContentId);
        Long resourceId = this.getPermissionCheckerResourceId(structuredContentId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(structuredContentId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getStructuredContentPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putStructuredContentPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Path(value="/structured-contents/{structuredContentId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putStructuredContentPermission(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the structured content's rendered template (the result of applying the structure's values to a template).")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId"), @Parameter(in=ParameterIn.PATH, name="contentTemplateId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @GET
    @Path(value="/structured-contents/{structuredContentId}/rendered-content/{contentTemplateId}")
    @Produces(value={"text/html"})
    public String getStructuredContentRenderedContentTemplate(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId, @Parameter(hidden=true) @NotNull @PathParam(value="contentTemplateId") String contentTemplateId) throws Exception {
        return "";
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Path(value="/structured-contents/{structuredContentId}/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putStructuredContentSubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Tags(value={@Tag(name="StructuredContent")})
    @Path(value="/structured-contents/{structuredContentId}/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putStructuredContentUnsubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    public void create(Collection<StructuredContent> structuredContents, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer structuredContentUnsafeConsumer = structuredContent -> this.postStructuredContentFolderStructuredContent(Long.parseLong((String)parameters.get("structuredContentFolderId")), (StructuredContent)structuredContent);
        if (parameters.containsKey("assetLibraryId")) {
            structuredContentUnsafeConsumer = structuredContent -> this.postAssetLibraryStructuredContent((Long)parameters.get("assetLibraryId"), (StructuredContent)structuredContent);
        } else if (parameters.containsKey("siteId")) {
            structuredContentUnsafeConsumer = structuredContent -> this.postSiteStructuredContent((Long)parameters.get("siteId"), (StructuredContent)structuredContent);
        }
        for (StructuredContent structuredContent2 : structuredContents) {
            structuredContentUnsafeConsumer.accept((Object)structuredContent2);
        }
    }

    public void delete(Collection<StructuredContent> structuredContents, Map<String, Serializable> parameters) throws Exception {
        for (StructuredContent structuredContent : structuredContents) {
            this.deleteStructuredContent(structuredContent.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<StructuredContent> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("assetLibraryId")) {
            return this.getAssetLibraryStructuredContentsPage((Long)parameters.get("assetLibraryId"), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        if (parameters.containsKey("siteId")) {
            return this.getSiteStructuredContentsPage((Long)parameters.get("siteId"), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        return this.getContentStructureStructuredContentsPage(Long.parseLong((String)((Object)parameters.get("contentStructureId"))), search, null, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<StructuredContent> structuredContents, Map<String, Serializable> parameters) throws Exception {
        for (StructuredContent structuredContent : structuredContents) {
            this.putStructuredContent(structuredContent.getId() != null ? structuredContent.getId() : Long.parseLong((String)((Object)parameters.get("structuredContentId"))), structuredContent);
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(StructuredContent structuredContent, StructuredContent existingStructuredContent) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

