/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.DocumentFolder;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.DocumentFolderDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.DocumentFolderEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseDocumentFolderResourceImpl;
import com.liferay.headless.delivery.internal.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.internal.search.filter.FilterUtil;
import com.liferay.headless.delivery.internal.search.sort.SortUtil;
import com.liferay.headless.delivery.resource.v1_0.DocumentFolderResource;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/document-folder.properties"}, scope=ServiceScope.PROTOTYPE, service={DocumentFolderResource.class})
public class DocumentFolderResourceImpl
extends BaseDocumentFolderResourceImpl
implements EntityModelResource {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DocumentFolderDTOConverter _documentFolderDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;

    @Override
    public void deleteDocumentFolder(Long documentFolderId) throws Exception {
        this._dlAppService.deleteFolder(documentFolderId.longValue());
    }

    @Override
    public Page<DocumentFolder> getAssetLibraryDocumentFoldersPage(Long assetLibraryId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getSiteDocumentFoldersPage(assetLibraryId, flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public DocumentFolder getDocumentFolder(Long documentFolderId) throws Exception {
        return this._toDocumentFolder(this._dlAppService.getFolder(documentFolderId.longValue()));
    }

    @Override
    public Page<DocumentFolder> getDocumentFolderDocumentFoldersPage(Long parentDocumentFolderId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Folder folder = this._dlAppService.getFolder(parentDocumentFolderId.longValue());
        return this._getDocumentFoldersPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_SUBFOLDER", folder.getFolderId(), "postDocumentFolderDocumentFolder", folder.getUserId(), "com.liferay.document.library", folder.getGroupId())).put((Object)"get", this.addAction("VIEW", folder.getFolderId(), "getDocumentFolderDocumentFoldersPage", folder.getUserId(), "com.liferay.document.library", folder.getGroupId())).build(), folder.getFolderId(), folder.getGroupId(), flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new DocumentFolderEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(DLFolder.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public Page<DocumentFolder> getSiteDocumentFoldersPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Long documentFolderId = null;
        if (!GetterUtil.getBoolean((Object)flatten)) {
            documentFolderId = 0L;
        }
        return this._getDocumentFoldersPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_FOLDER", "postSiteDocumentFolder", "com.liferay.document.library", siteId)).put((Object)"get", this.addAction("VIEW", "getSiteDocumentFoldersPage", "com.liferay.document.library", siteId)).build(), documentFolderId, siteId, flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public DocumentFolder patchDocumentFolder(Long documentFolderId, DocumentFolder documentFolder) throws Exception {
        Folder existingFolder = this._dlAppService.getFolder(documentFolderId.longValue());
        return this._updateDocumentFolder(documentFolderId, documentFolder.getCustomFields(), Optional.ofNullable(documentFolder.getDescription()).orElse(existingFolder.getDescription()), Optional.ofNullable(documentFolder.getName()).orElse(existingFolder.getName()));
    }

    @Override
    public DocumentFolder postAssetLibraryDocumentFolder(Long assetLibraryId, DocumentFolder documentFolder) throws Exception {
        return this.postSiteDocumentFolder(assetLibraryId, documentFolder);
    }

    @Override
    public DocumentFolder postDocumentFolderDocumentFolder(Long parentDocumentFolderId, DocumentFolder documentFolder) throws Exception {
        Folder folder = this._dlAppService.getFolder(parentDocumentFolderId.longValue());
        return this._addFolder(folder.getGroupId(), folder.getFolderId(), documentFolder);
    }

    @Override
    public DocumentFolder postSiteDocumentFolder(Long siteId, DocumentFolder documentFolder) throws Exception {
        return this._addFolder(siteId, 0L, documentFolder);
    }

    @Override
    public DocumentFolder putDocumentFolder(Long documentFolderId, DocumentFolder documentFolder) throws Exception {
        return this._updateDocumentFolder(documentFolderId, documentFolder.getCustomFields(), documentFolder.getDescription(), documentFolder.getName());
    }

    @Override
    public void putDocumentFolderSubscribe(Long documentFolderId) throws Exception {
        Folder folder = this._dlAppService.getFolder(documentFolderId.longValue());
        this._dlAppService.subscribeFolder(folder.getGroupId(), folder.getFolderId());
    }

    @Override
    public void putDocumentFolderUnsubscribe(Long documentFolderId) throws Exception {
        Folder folder = this._dlAppService.getFolder(documentFolderId.longValue());
        this._dlAppService.unsubscribeFolder(folder.getGroupId(), folder.getFolderId());
    }

    private DocumentFolder _addFolder(Long siteId, Long parentDocumentFolderId, DocumentFolder documentFolder) throws Exception {
        return this._toDocumentFolder(this._dlAppService.addFolder(siteId.longValue(), parentDocumentFolderId.longValue(), documentFolder.getName(), documentFolder.getDescription(), ServiceContextRequestUtil.createServiceContext(CustomFieldsUtil.toMap(DLFolder.class.getName(), this.contextCompany.getCompanyId(), documentFolder.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale()), (long)siteId, (HttpServletRequest)this.contextHttpServletRequest, (String)documentFolder.getViewableByAsString())));
    }

    private Page<DocumentFolder> _getDocumentFoldersPage(Map<String, Map<String, String>> actions, Long parentDocumentFolderId, Long groupId, Boolean flatten, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQuery -> {
            if (parentDocumentFolderId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                String field = "folderId";
                if (GetterUtil.getBoolean((Object)flatten)) {
                    booleanFilter.add((Filter)new TermFilter(field, String.valueOf(parentDocumentFolderId)), BooleanClauseOccur.MUST_NOT);
                    field = "treePath";
                }
                booleanFilter.add((Filter)new TermFilter(field, String.valueOf(parentDocumentFolderId)), BooleanClauseOccur.MUST);
            }
        }, (Filter)FilterUtil.processFilter(this._ddmIndexer, filter), DLFolder.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{groupId});
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation(this._aggregations, this._ddmIndexer, this._queries, searchRequestBuilder, aggregation);
            SortUtil.processSorts(this._ddmIndexer, searchRequestBuilder, searchContext.getSorts(), this._queries, this._sorts);
        }, (Sort[])sorts, document -> this._toDocumentFolder(this._dlAppService.getFolder(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private DocumentFolder _toDocumentFolder(Folder folder) throws Exception {
        return this._documentFolderDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", folder.getFolderId(), "deleteDocumentFolder", folder.getUserId(), "com.liferay.document.library.kernel.model.DLFolder", folder.getGroupId())).put((Object)"get", this.addAction("ACCESS", folder.getFolderId(), "getDocumentFolder", folder.getUserId(), "com.liferay.document.library.kernel.model.DLFolder", folder.getGroupId())).put((Object)"replace", this.addAction("UPDATE", folder.getFolderId(), "putDocumentFolder", folder.getUserId(), "com.liferay.document.library.kernel.model.DLFolder", folder.getGroupId())).put((Object)"subscribe", this.addAction("SUBSCRIBE", folder.getFolderId(), "putDocumentFolderSubscribe", folder.getUserId(), "com.liferay.document.library.kernel.model.DLFolder", folder.getGroupId())).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", folder.getFolderId(), "putDocumentFolderUnsubscribe", folder.getUserId(), "com.liferay.document.library.kernel.model.DLFolder", folder.getGroupId())).put((Object)"update", this.addAction("UPDATE", folder.getFolderId(), "patchDocumentFolder", folder.getUserId(), "com.liferay.document.library.kernel.model.DLFolder", folder.getGroupId())).build(), this._dtoConverterRegistry, (Object)folder.getFolderId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private DocumentFolder _updateDocumentFolder(Long documentFolderId, CustomField[] customFields, String description, String name) throws Exception {
        return this._toDocumentFolder(this._dlAppService.updateFolder(documentFolderId.longValue(), name, description, ServiceContextRequestUtil.createServiceContext(CustomFieldsUtil.toMap(DLFolder.class.getName(), this.contextCompany.getCompanyId(), customFields, this.contextAcceptLanguage.getPreferredLocale()), (long)0L, (HttpServletRequest)this.contextHttpServletRequest, null)));
    }
}

