/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseFolder;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.ParentKnowledgeBaseFolderUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseKnowledgeBaseFolderResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseFolderResource;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.knowledge.base.service.KBFolderService;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/knowledge-base-folder.properties"}, scope=ServiceScope.PROTOTYPE, service={KnowledgeBaseFolderResource.class})
public class KnowledgeBaseFolderResourceImpl
extends BaseKnowledgeBaseFolderResourceImpl {
    @Reference
    private KBArticleService _kbArticleService;
    @Reference
    private KBFolderService _kbFolderService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteKnowledgeBaseFolder(Long knowledgeBaseFolderId) throws Exception {
        this._kbFolderService.deleteKBFolder(knowledgeBaseFolderId.longValue());
    }

    @Override
    public KnowledgeBaseFolder getKnowledgeBaseFolder(Long knowledgeBaseFolderId) throws Exception {
        return this._toKnowledgeBaseFolder(this._kbFolderService.getKBFolder(knowledgeBaseFolderId.longValue()));
    }

    @Override
    public Page<KnowledgeBaseFolder> getKnowledgeBaseFolderKnowledgeBaseFoldersPage(Long parentKnowledgeBaseFolderId, Pagination pagination) throws Exception {
        KBFolder kbFolder = this._kbFolderService.getKBFolder(parentKnowledgeBaseFolderId.longValue());
        return Page.of((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_KB_FOLDER", "postKnowledgeBaseFolderKnowledgeBaseFolder", "com.liferay.knowledge.base.admin", kbFolder.getGroupId())).put((Object)"get", this.addAction("VIEW", "getKnowledgeBaseFolderKnowledgeBaseFoldersPage", "com.liferay.knowledge.base.admin", kbFolder.getGroupId())).build(), this.transform(this._kbFolderService.getKBFolders(kbFolder.getGroupId(), parentKnowledgeBaseFolderId.longValue(), pagination.getStartPosition(), pagination.getEndPosition()), this::_toKnowledgeBaseFolder), (Pagination)pagination, (long)this._kbFolderService.getKBFoldersCount(kbFolder.getGroupId(), parentKnowledgeBaseFolderId.longValue()));
    }

    @Override
    public Page<KnowledgeBaseFolder> getSiteKnowledgeBaseFoldersPage(Long siteId, Pagination pagination) throws Exception {
        return Page.of((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_KB_FOLDER", "postSiteKnowledgeBaseFolder", "com.liferay.knowledge.base.admin", siteId)).put((Object)"get", this.addAction("VIEW", "getSiteKnowledgeBaseFoldersPage", "com.liferay.knowledge.base.admin", siteId)).build(), this.transform(this._kbFolderService.getKBFolders(siteId.longValue(), 0L, pagination.getStartPosition(), pagination.getEndPosition()), this::_toKnowledgeBaseFolder), (Pagination)pagination, (long)this._kbFolderService.getKBFoldersCount(siteId.longValue(), 0L));
    }

    @Override
    public KnowledgeBaseFolder postKnowledgeBaseFolderKnowledgeBaseFolder(Long parentKnowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        KBFolder parentKBFolder = this._kbFolderService.getKBFolder(parentKnowledgeBaseFolderId.longValue());
        return this._toKnowledgeBaseFolder(this._kbFolderService.addKBFolder(parentKBFolder.getGroupId(), this._getClassNameId(), parentKnowledgeBaseFolderId.longValue(), knowledgeBaseFolder.getName(), knowledgeBaseFolder.getDescription(), ServiceContextRequestUtil.createServiceContext(this._getExpandoBridgeAttributes(knowledgeBaseFolder), (long)parentKBFolder.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, (String)knowledgeBaseFolder.getViewableByAsString())));
    }

    @Override
    public KnowledgeBaseFolder postSiteKnowledgeBaseFolder(Long siteId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return this._toKnowledgeBaseFolder(this._kbFolderService.addKBFolder(siteId.longValue(), this._getClassNameId(), 0L, knowledgeBaseFolder.getName(), knowledgeBaseFolder.getDescription(), ServiceContextRequestUtil.createServiceContext(this._getExpandoBridgeAttributes(knowledgeBaseFolder), (long)siteId, (HttpServletRequest)this.contextHttpServletRequest, (String)knowledgeBaseFolder.getViewableByAsString())));
    }

    @Override
    public KnowledgeBaseFolder putKnowledgeBaseFolder(Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        Long parentKnowledgeBaseFolderId = knowledgeBaseFolder.getParentKnowledgeBaseFolderId();
        if (parentKnowledgeBaseFolderId == null) {
            parentKnowledgeBaseFolderId = 0L;
        }
        return this._toKnowledgeBaseFolder(this._kbFolderService.updateKBFolder(this._getClassNameId(), parentKnowledgeBaseFolderId.longValue(), knowledgeBaseFolderId.longValue(), knowledgeBaseFolder.getName(), knowledgeBaseFolder.getDescription(), ServiceContextRequestUtil.createServiceContext(this._getExpandoBridgeAttributes(knowledgeBaseFolder), (long)0L, (HttpServletRequest)this.contextHttpServletRequest, null)));
    }

    private long _getClassNameId() {
        return this._portal.getClassNameId(KBFolder.class.getName());
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(KnowledgeBaseFolder knowledgeBaseFolder) {
        return CustomFieldsUtil.toMap(KBFolder.class.getName(), this.contextCompany.getCompanyId(), knowledgeBaseFolder.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private KnowledgeBaseFolder _toKnowledgeBaseFolder(final KBFolder kbFolder) throws Exception {
        if (kbFolder == null) {
            return null;
        }
        return new KnowledgeBaseFolder(){
            {
                this.actions = HashMapBuilder.put((Object)"delete", KnowledgeBaseFolderResourceImpl.this.addAction("DELETE", (GroupedModel)kbFolder, "deleteKnowledgeBaseFolder")).put((Object)"get", KnowledgeBaseFolderResourceImpl.this.addAction("VIEW", (GroupedModel)kbFolder, "getKnowledgeBaseFolder")).put((Object)"replace", KnowledgeBaseFolderResourceImpl.this.addAction("UPDATE", (GroupedModel)kbFolder, "putKnowledgeBaseFolder")).build();
                this.creator = CreatorUtil.toCreator(KnowledgeBaseFolderResourceImpl.this._portal, Optional.of(KnowledgeBaseFolderResourceImpl.this.contextUriInfo), KnowledgeBaseFolderResourceImpl.this._userLocalService.fetchUser(kbFolder.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(KnowledgeBaseFolderResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), KBFolder.class.getName(), kbFolder.getKbFolderId(), kbFolder.getCompanyId(), KnowledgeBaseFolderResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.dateCreated = kbFolder.getCreateDate();
                this.dateModified = kbFolder.getModifiedDate();
                this.description = kbFolder.getDescription();
                this.id = kbFolder.getKbFolderId();
                this.name = kbFolder.getName();
                this.numberOfKnowledgeBaseArticles = KnowledgeBaseFolderResourceImpl.this._kbArticleService.getKBArticlesCount(kbFolder.getGroupId(), kbFolder.getKbFolderId(), 0);
                this.numberOfKnowledgeBaseFolders = KnowledgeBaseFolderResourceImpl.this._kbFolderService.getKBFoldersCount(kbFolder.getGroupId(), kbFolder.getKbFolderId());
                this.parentKnowledgeBaseFolder = ParentKnowledgeBaseFolderUtil.toParentKnowledgeBaseFolder(kbFolder.getParentKBFolder());
                this.siteId = kbFolder.getGroupId();
            }
        };
    }
}

