/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardSection;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.MessageBoardSectionDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.MessageBoardSectionEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardSectionResourceImpl;
import com.liferay.headless.delivery.internal.resource.v1_0.MessageBoardThreadResourceImpl;
import com.liferay.headless.delivery.internal.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.internal.search.filter.FilterUtil;
import com.liferay.headless.delivery.internal.search.sort.SortUtil;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardSectionResource;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-section.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardSectionResource.class})
public class MessageBoardSectionResourceImpl
extends BaseMessageBoardSectionResourceImpl
implements EntityModelResource {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private MBCategoryService _mbCategoryService;
    @Reference
    private MessageBoardSectionDTOConverter _messageBoardSectionDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;

    @Override
    public void deleteMessageBoardSection(Long messageBoardSectionId) throws Exception {
        this._mbCategoryService.deleteCategory(messageBoardSectionId.longValue(), true);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new MessageBoardSectionEntityModel(new ArrayList<EntityField>(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(MBCategory.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService)));
    }

    @Override
    public MessageBoardSection getMessageBoardSection(Long messageBoardSectionId) throws Exception {
        return this._toMessageBoardSection(this._mbCategoryService.getCategory(messageBoardSectionId.longValue()));
    }

    @Override
    public Page<MessageBoardSection> getMessageBoardSectionMessageBoardSectionsPage(Long parentMessageBoardSectionId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(parentMessageBoardSectionId.longValue());
        return this._getMessageBoardSectionsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_CATEGORY", "postMessageBoardSectionMessageBoardSection", "com.liferay.message.boards", mbCategory.getGroupId())).put((Object)"get", this.addAction("VIEW", "getMessageBoardSectionMessageBoardSectionsPage", "com.liferay.message.boards", mbCategory.getGroupId())).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("parentCategoryId", String.valueOf(mbCategory.getCategoryId())), BooleanClauseOccur.MUST);
        }), mbCategory.getGroupId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Page<MessageBoardSection> getSiteMessageBoardSectionsPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getMessageBoardSectionsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_CATEGORY", "postSiteMessageBoardSection", "com.liferay.message.boards", siteId)).put((Object)"get", this.addAction("VIEW", "getSiteMessageBoardSectionsPage", "com.liferay.message.boards", siteId)).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (!GetterUtil.getBoolean((Object)flatten)) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("parentCategoryId", "0"), BooleanClauseOccur.MUST);
            }
        }), siteId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public MessageBoardSection postMessageBoardSectionMessageBoardSection(Long parentMessageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(parentMessageBoardSectionId.longValue());
        return this._addMessageBoardSection(mbCategory.getGroupId(), parentMessageBoardSectionId, messageBoardSection);
    }

    @Override
    public MessageBoardSection postSiteMessageBoardSection(Long siteId, MessageBoardSection messageBoardSection) throws Exception {
        return this._addMessageBoardSection(siteId, 0L, messageBoardSection);
    }

    @Override
    public MessageBoardSection putMessageBoardSection(Long messageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        return this._toMessageBoardSection(this._mbCategoryService.updateCategory(messageBoardSectionId.longValue(), mbCategory.getParentCategoryId(), messageBoardSection.getTitle(), messageBoardSection.getDescription(), mbCategory.getDisplayStyle(), "", "", "", 0, false, "", "", 0, "", false, "", 0, false, "", "", false, false, false, ServiceContextRequestUtil.createServiceContext(this._getExpandoBridgeAttributes(messageBoardSection), (long)mbCategory.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null)));
    }

    @Override
    public void putMessageBoardSectionSubscribe(Long messageBoardSectionId) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        this._mbCategoryService.subscribeCategory(mbCategory.getGroupId(), mbCategory.getCategoryId());
    }

    @Override
    public void putMessageBoardSectionUnsubscribe(Long messageBoardSectionId) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        this._mbCategoryService.unsubscribeCategory(mbCategory.getGroupId(), mbCategory.getCategoryId());
    }

    private MessageBoardSection _addMessageBoardSection(long siteId, Long parentMessageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        return this._toMessageBoardSection(this._mbCategoryService.addCategory(this.contextUser.getUserId(), parentMessageBoardSectionId.longValue(), messageBoardSection.getTitle(), messageBoardSection.getDescription(), ServiceContextRequestUtil.createServiceContext(this._getExpandoBridgeAttributes(messageBoardSection), (long)siteId, (HttpServletRequest)this.contextHttpServletRequest, (String)messageBoardSection.getViewableByAsString())));
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(MessageBoardSection messageBoardSection) {
        return CustomFieldsUtil.toMap(MBCategory.class.getName(), this.contextCompany.getCompanyId(), messageBoardSection.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private Page<MessageBoardSection> _getMessageBoardSectionsPage(Map<String, Map<String, String>> actions, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Long siteId, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)FilterUtil.processFilter(this._ddmIndexer, filter), MBCategory.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation(this._aggregations, this._ddmIndexer, this._queries, searchRequestBuilder, aggregation);
            SortUtil.processSorts(this._ddmIndexer, searchRequestBuilder, searchContext.getSorts(), this._queries, this._sorts);
        }, (Sort[])sorts, document -> this._toMessageBoardSection(this._mbCategoryService.getCategory(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private MessageBoardSection _toMessageBoardSection(MBCategory mbCategory) throws Exception {
        return this._messageBoardSectionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"add-subcategory", this.addAction("ADD_SUBCATEGORY", (GroupedModel)mbCategory, "postMessageBoardSectionMessageBoardSection")).put((Object)"add-thread", (Object)ActionUtil.addAction((String)"ADD_MESSAGE", MessageBoardThreadResourceImpl.class, (Long)mbCategory.getCategoryId(), (String)"postMessageBoardSectionMessageBoardThread", (Object)this.contextScopeChecker, (Long)mbCategory.getUserId(), (String)MBCategory.class.getName(), (Long)mbCategory.getGroupId(), (UriInfo)this.contextUriInfo)).put((Object)"delete", this.addAction("DELETE", (GroupedModel)mbCategory, "deleteMessageBoardSection")).put((Object)"get", this.addAction("VIEW", (GroupedModel)mbCategory, "getMessageBoardSection")).put((Object)"replace", this.addAction("UPDATE", (GroupedModel)mbCategory, "putMessageBoardSection")).put((Object)"subscribe", this.addAction("SUBSCRIBE", (GroupedModel)mbCategory, "putMessageBoardSectionSubscribe")).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", (GroupedModel)mbCategory, "putMessageBoardSectionUnsubscribe")).build(), this._dtoConverterRegistry, (Object)mbCategory.getCategoryId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

