/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.WikiPageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseWikiPageResourceImpl;
import com.liferay.headless.delivery.internal.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.internal.search.filter.FilterUtil;
import com.liferay.headless.delivery.internal.search.sort.SortUtil;
import com.liferay.headless.delivery.resource.v1_0.WikiPageResource;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeService;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.WikiPageService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/wiki-page.properties"}, scope=ServiceScope.PROTOTYPE, service={WikiPageResource.class})
public class WikiPageResourceImpl
extends BaseWikiPageResourceImpl
implements EntityModelResource {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;
    @Reference
    private WikiNodeService _wikiNodeService;
    @Reference
    private WikiPageLocalService _wikiPageLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private ModelResourcePermission<WikiPage> _wikiPageModelResourcePermission;
    @Reference
    private WikiPageService _wikiPageService;

    @Override
    public void deleteWikiPage(Long wikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPageByPageId(wikiPageId.longValue());
        this._wikiPageService.deletePage(wikiPage.getNodeId(), wikiPage.getTitle());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new WikiPageEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(WikiPage.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public Page<com.liferay.headless.delivery.dto.v1_0.WikiPage> getWikiNodeWikiPagesPage(Long wikiNodeId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        WikiNode wikiNode = this._wikiNodeService.getNode(wikiNodeId.longValue());
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"add-page", this.addAction("ADD_PAGE", (GroupedModel)wikiNode, "postWikiNodeWikiPage")).put((Object)"get", this.addAction("VIEW", (GroupedModel)wikiNode, "getWikiNodeWikiPagesPage")).build(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("nodeId", String.valueOf(wikiNodeId)), BooleanClauseOccur.MUST);
        }, (Filter)FilterUtil.processFilter(this._ddmIndexer, filter), WikiPage.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation(this._aggregations, this._ddmIndexer, this._queries, searchRequestBuilder, aggregation);
            SortUtil.processSorts(this._ddmIndexer, searchRequestBuilder, searchContext.getSorts(), this._queries, this._sorts);
        }, (Sort[])sorts, document -> this._toWikiPage(this._wikiPageService.getPage(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage getWikiPage(Long wikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPageByPageId(wikiPageId.longValue());
        this._wikiPageModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)wikiPage, "VIEW");
        return this._toWikiPage(wikiPage);
    }

    @Override
    public Page<com.liferay.headless.delivery.dto.v1_0.WikiPage> getWikiPageWikiPagesPage(Long parentWikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPageByPageId(parentWikiPageId.longValue());
        this._wikiPageModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)wikiPage, "VIEW");
        return Page.of((Map)HashMapBuilder.put((Object)"add-page", this.addAction("UPDATE", wikiPage.getResourcePrimKey(), "postWikiPageWikiPage", wikiPage.getUserId(), "com.liferay.wiki.model.WikiPage", wikiPage.getGroupId())).put((Object)"get", this.addAction("VIEW", wikiPage.getResourcePrimKey(), "getWikiPageWikiPagesPage", wikiPage.getUserId(), "com.liferay.wiki.model.WikiPage", wikiPage.getGroupId())).build(), this.transform(this._wikiPageService.getChildren(wikiPage.getGroupId(), wikiPage.getNodeId(), true, wikiPage.getTitle()), this::_toWikiPage));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage postWikiNodeWikiPage(Long wikiNodeId, com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) throws Exception {
        WikiNode wikiNode = this._wikiNodeService.getNode(wikiNodeId.longValue());
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext((Long[])wikiPage.getTaxonomyCategoryIds(), (String[])wikiPage.getKeywords(), this._getExpandoBridgeAttributes(wikiPage), (Long)wikiNode.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, (String)wikiPage.getViewableByAsString());
        serviceContext.setCommand("add");
        return this._toWikiPage(this._wikiPageService.addPage(wikiNodeId.longValue(), wikiPage.getHeadline(), wikiPage.getContent(), wikiPage.getHeadline(), true, wikiPage.getEncodingFormat(), null, null, serviceContext));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage postWikiPageWikiPage(Long parentWikiPageId, com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) throws Exception {
        WikiPage parentWikiPage = this._wikiPageLocalService.getPageByPageId(parentWikiPageId.longValue());
        this._wikiNodeModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), parentWikiPage.getNodeId(), "ADD_PAGE");
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext((Long[])wikiPage.getTaxonomyCategoryIds(), (String[])wikiPage.getKeywords(), this._getExpandoBridgeAttributes(wikiPage), (Long)parentWikiPage.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, (String)wikiPage.getViewableByAsString());
        serviceContext.setCommand("add");
        return this._toWikiPage(this._wikiPageLocalService.addPage(this.contextUser.getUserId(), parentWikiPage.getNodeId(), wikiPage.getHeadline(), 1.0, wikiPage.getContent(), wikiPage.getHeadline(), false, wikiPage.getEncodingFormat(), false, parentWikiPage.getTitle(), null, serviceContext));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage putWikiPage(Long wikiPageId, com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) throws Exception {
        WikiPage serviceBuilderWikiPage = this._wikiPageLocalService.getPageByPageId(wikiPageId.longValue());
        this._wikiPageModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)serviceBuilderWikiPage, "UPDATE");
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext((Long[])wikiPage.getTaxonomyCategoryIds(), (String[])wikiPage.getKeywords(), this._getExpandoBridgeAttributes(wikiPage), (Long)serviceBuilderWikiPage.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, (String)wikiPage.getViewableByAsString());
        serviceContext.setCommand("update");
        return this._toWikiPage(this._wikiPageService.updatePage(serviceBuilderWikiPage.getNodeId(), wikiPage.getHeadline(), serviceBuilderWikiPage.getVersion(), wikiPage.getContent(), wikiPage.getDescription(), true, wikiPage.getEncodingFormat(), serviceBuilderWikiPage.getParentTitle(), serviceBuilderWikiPage.getRedirectTitle(), serviceContext));
    }

    @Override
    public void putWikiPageSubscribe(Long wikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPageByPageId(wikiPageId.longValue());
        this._wikiPageService.subscribePage(wikiPage.getNodeId(), wikiPage.getTitle());
    }

    @Override
    public void putWikiPageUnsubscribe(Long wikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPageByPageId(wikiPageId.longValue());
        this._wikiPageService.unsubscribePage(wikiPage.getNodeId(), wikiPage.getTitle());
    }

    private String _getEncodingFormat(WikiPage wikiPage) {
        String format = wikiPage.getFormat();
        if (format.equals("creole")) {
            return "text/x-wiki";
        }
        if (format.equals("html")) {
            return "text/html";
        }
        if (format.equals("plain_text")) {
            return "text/plain";
        }
        return format;
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) {
        return CustomFieldsUtil.toMap(WikiPage.class.getName(), this.contextCompany.getCompanyId(), wikiPage.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private com.liferay.headless.delivery.dto.v1_0.WikiPage _toWikiPage(final WikiPage wikiPage) throws Exception {
        return new com.liferay.headless.delivery.dto.v1_0.WikiPage(){
            {
                this.actions = HashMapBuilder.put((Object)"add-page", WikiPageResourceImpl.this.addAction("UPDATE", wikiPage.getResourcePrimKey(), "postWikiPageWikiPage", wikiPage.getUserId(), "com.liferay.wiki.model.WikiPage", wikiPage.getGroupId())).put((Object)"delete", WikiPageResourceImpl.this.addAction("DELETE", wikiPage.getResourcePrimKey(), "deleteWikiPage", wikiPage.getUserId(), "com.liferay.wiki.model.WikiPage", wikiPage.getGroupId())).put((Object)"get", WikiPageResourceImpl.this.addAction("VIEW", wikiPage.getResourcePrimKey(), "getWikiPage", wikiPage.getUserId(), "com.liferay.wiki.model.WikiPage", wikiPage.getGroupId())).put((Object)"replace", WikiPageResourceImpl.this.addAction("UPDATE", wikiPage.getResourcePrimKey(), "putWikiPage", wikiPage.getUserId(), "com.liferay.wiki.model.WikiPage", wikiPage.getGroupId())).put((Object)"subscribe", WikiPageResourceImpl.this.addAction("SUBSCRIBE", wikiPage.getResourcePrimKey(), "putWikiPageSubscribe", wikiPage.getUserId(), "com.liferay.wiki.model.WikiPage", wikiPage.getGroupId())).put((Object)"unsubscribe", WikiPageResourceImpl.this.addAction("SUBSCRIBE", wikiPage.getResourcePrimKey(), "putWikiPageUnsubscribe", wikiPage.getUserId(), "com.liferay.wiki.model.WikiPage", wikiPage.getGroupId())).build();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(WikiPageResourceImpl.this._ratingsStatsLocalService.fetchStats(WikiPage.class.getName(), wikiPage.getResourcePrimKey()));
                this.content = wikiPage.getContent();
                this.creator = CreatorUtil.toCreator(WikiPageResourceImpl.this._portal, Optional.of(WikiPageResourceImpl.this.contextUriInfo), WikiPageResourceImpl.this._userLocalService.fetchUser(wikiPage.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(WikiPageResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), WikiPage.class.getName(), wikiPage.getPageId(), wikiPage.getCompanyId(), WikiPageResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.dateCreated = wikiPage.getCreateDate();
                this.dateModified = wikiPage.getModifiedDate();
                this.description = wikiPage.getSummary();
                this.encodingFormat = WikiPageResourceImpl.this._getEncodingFormat(wikiPage);
                this.headline = wikiPage.getTitle();
                this.id = wikiPage.getPageId();
                this.keywords = (String[])ListUtil.toArray((List)WikiPageResourceImpl.this._assetTagLocalService.getTags(BlogsEntry.class.getName(), wikiPage.getPageId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfAttachments = wikiPage.getAttachmentsFileEntriesCount();
                this.numberOfWikiPages = Optional.ofNullable(wikiPage.getChildPages()).map(List::size).orElse(0);
                this.relatedContents = RelatedContentUtil.toRelatedContents(WikiPageResourceImpl.this._assetEntryLocalService, WikiPageResourceImpl.this._assetLinkLocalService, WikiPageResourceImpl.this._dtoConverterRegistry, wikiPage.getModelClassName(), wikiPage.getResourcePrimKey(), WikiPageResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.siteId = wikiPage.getGroupId();
                this.subscribed = WikiPageResourceImpl.this._subscriptionLocalService.isSubscribed(wikiPage.getCompanyId(), WikiPageResourceImpl.this.contextUser.getUserId(), WikiPage.class.getName(), wikiPage.getResourcePrimKey());
                this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)WikiPageResourceImpl.this._assetCategoryLocalService.getCategories(WikiPage.class.getName(), wikiPage.getPageId()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, (DTOConverterContext)new DefaultDTOConverterContext(WikiPageResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), Collections.emptyMap(), WikiPageResourceImpl.this._dtoConverterRegistry, WikiPageResourceImpl.this.contextHttpServletRequest, (Object)assetCategory.getCategoryId(), WikiPageResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), WikiPageResourceImpl.this.contextUriInfo, WikiPageResourceImpl.this.contextUser)), TaxonomyCategoryBrief.class);
                this.setParentWikiPageId(() -> {
                    WikiPage parentWikiPage = wikiPage.getParentPage();
                    if (parentWikiPage == null || parentWikiPage.getPageId() == 0L) {
                        return null;
                    }
                    return parentWikiPage.getPageId();
                });
            }
        };
    }
}

