/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.link.service.AssetLinkLocalService;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.BlogPosting;
import com.liferay.headless.delivery.dto.v1_0.Image;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.dto.v1_0.util.ContentValueUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.DisplayPageRendererUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseBlogPostingResourceImpl;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.blogs.model.BlogsEntry"}, service={DTOConverter.class})
public class BlogPostingDTOConverter
implements DTOConverter<BlogsEntry, BlogPosting> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private Html _html;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutDisplayPageProviderRegistry _layoutDisplayPageProviderRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return BlogPosting.class.getSimpleName();
    }

    public String getJaxRsLink(long classPK, UriInfo uriInfo) {
        return JaxRsLinkUtil.getJaxRsLink((String)"headless-delivery", BaseBlogPostingResourceImpl.class, (String)"getBlogPosting", (UriInfo)uriInfo, (Object[])new Object[]{classPK});
    }

    public BlogPosting toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final BlogsEntry blogsEntry = this._blogsEntryService.getEntry(((Long)dtoConverterContext.getId()).longValue());
        return new BlogPosting(){
            {
                this.actions = dtoConverterContext.getActions();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(BlogPostingDTOConverter.this._ratingsStatsLocalService.fetchStats(BlogsEntry.class.getName(), blogsEntry.getEntryId()));
                this.alternativeHeadline = blogsEntry.getSubtitle();
                this.articleBody = blogsEntry.getContent();
                this.creator = CreatorUtil.toCreator((Portal)BlogPostingDTOConverter.this._portal, (UriInfo)dtoConverterContext.getUriInfo(), (User)BlogPostingDTOConverter.this._userLocalService.fetchUser(blogsEntry.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)BlogsEntry.class.getName(), (long)blogsEntry.getEntryId(), (long)blogsEntry.getCompanyId(), (Locale)dtoConverterContext.getLocale());
                this.dateCreated = blogsEntry.getCreateDate();
                this.dateModified = blogsEntry.getModifiedDate();
                this.datePublished = blogsEntry.getDisplayDate();
                this.encodingFormat = "text/html";
                this.externalReferenceCode = blogsEntry.getExternalReferenceCode();
                this.friendlyUrlPath = blogsEntry.getUrlTitle();
                this.headline = blogsEntry.getTitle();
                this.id = blogsEntry.getEntryId();
                this.image = BlogPostingDTOConverter.this._getImage(blogsEntry, dtoConverterContext);
                this.keywords = (String[])ListUtil.toArray((List)BlogPostingDTOConverter.this._assetTagLocalService.getTags(BlogsEntry.class.getName(), blogsEntry.getEntryId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfComments = BlogPostingDTOConverter.this._commentManager.getCommentsCount(BlogsEntry.class.getName(), blogsEntry.getEntryId());
                this.relatedContents = RelatedContentUtil.toRelatedContents(BlogPostingDTOConverter.this._assetEntryLocalService, BlogPostingDTOConverter.this._assetLinkLocalService, dtoConverterContext.getDTOConverterRegistry(), blogsEntry.getModelClassName(), blogsEntry.getEntryId(), dtoConverterContext.getLocale());
                this.siteId = blogsEntry.getGroupId();
                this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)BlogPostingDTOConverter.this._assetCategoryLocalService.getCategories(BlogsEntry.class.getName(), blogsEntry.getEntryId()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, dtoConverterContext), TaxonomyCategoryBrief.class);
                this.viewableBy = BlogPosting.ViewableBy.ANYONE;
                this.setDescription(() -> {
                    String description = blogsEntry.getDescription();
                    if (Validator.isNotNull((String)description)) {
                        return description;
                    }
                    return BlogPostingDTOConverter.this._html.stripHtml(StringUtil.shorten((String)blogsEntry.getContent(), (int)PropsValues.BLOGS_PAGE_ABSTRACT_LENGTH));
                });
                this.setRenderedContents(() -> DisplayPageRendererUtil.getRenderedContent(BaseBlogPostingResourceImpl.class, BlogsEntry.class.getName(), blogsEntry.getEntryId(), 0L, dtoConverterContext, blogsEntry.getGroupId(), blogsEntry, BlogPostingDTOConverter.this._infoItemServiceRegistry, BlogPostingDTOConverter.this._layoutDisplayPageProviderRegistry, BlogPostingDTOConverter.this._layoutLocalService, BlogPostingDTOConverter.this._layoutPageTemplateEntryService, "getBlogPostingRenderedContentByDisplayPageDisplayPageKey"));
            }
        };
    }

    private Image _getImage(final BlogsEntry blogsEntry, final DTOConverterContext dtoConverterContext) throws Exception {
        final long coverImageFileEntryId = blogsEntry.getCoverImageFileEntryId();
        if (coverImageFileEntryId == 0L) {
            return null;
        }
        final FileEntry fileEntry = this._dlAppService.getFileEntry(coverImageFileEntryId);
        return new Image(){
            {
                this.caption = blogsEntry.getCoverImageCaption();
                this.contentUrl = BlogPostingDTOConverter.this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false);
                this.contentValue = ContentValueUtil.toContentValue((String)"image.contentValue", () -> ((FileEntry)fileEntry).getContentStream(), (UriInfo)dtoConverterContext.getUriInfo());
                this.imageId = coverImageFileEntryId;
            }
        };
    }
}

