/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.client.extension.type.CET;
import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.ClientExtension;
import com.liferay.headless.delivery.dto.v1_0.MasterPage;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.headless.delivery.dto.v1_0.Settings;
import com.liferay.headless.delivery.dto.v1_0.StyleBook;
import com.liferay.headless.delivery.dto.v1_0.util.ContentDocumentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapperRegistry;
import com.liferay.headless.delivery.internal.dto.v1_0.util.PageElementUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.LayoutStructure"}, service={DTOConverter.class})
public class PageDefinitionDTOConverter
implements DTOConverter<LayoutStructure, PageDefinition> {
    private static final Log _log = LogFactoryUtil.getLog(PageDefinitionDTOConverter.class);
    @Reference
    private CETManager _cetManager;
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutStructureItemMapperRegistry _layoutStructureItemMapperRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private StyleBookEntryLocalService _styleBookEntryLocalService;

    public String getContentType() {
        return PageDefinition.class.getSimpleName();
    }

    public PageDefinition toDTO(final DTOConverterContext dtoConverterContext, final LayoutStructure layoutStructure) throws Exception {
        final Layout layout = (Layout)dtoConverterContext.getAttribute("layout");
        if (layout == null) {
            throw new IllegalArgumentException("Layout is not defined for layout structure item " + layoutStructure.getMainItemId());
        }
        final LayoutStructureItem mainLayoutStructureItem = layoutStructure.getMainLayoutStructureItem();
        final boolean saveInlineContent = GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("saveInlineContent"), (boolean)true);
        final boolean saveMappingConfiguration = GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("saveMappingConfiguration"), (boolean)true);
        return new PageDefinition(){
            {
                this.pageElement = PageElementUtil.toPageElement(layout.getGroupId(), layoutStructure, mainLayoutStructureItem, PageDefinitionDTOConverter.this._layoutStructureItemMapperRegistry, saveInlineContent, saveMappingConfiguration);
                this.settings = PageDefinitionDTOConverter.this._toSettings(dtoConverterContext, layout);
                this.version = 1.1;
            }
        };
    }

    private CET _getCET(long classNameId, long classPK, long companyId, String type) {
        ClientExtensionEntryRel clientExtensionEntryRel = this._clientExtensionEntryRelLocalService.fetchClientExtensionEntryRel(classNameId, classPK, type);
        if (clientExtensionEntryRel == null) {
            return null;
        }
        return this._cetManager.getCET(companyId, clientExtensionEntryRel.getCETExternalReferenceCode());
    }

    private Map<String, String> _getClientExtensionConfig(ClientExtensionEntryRel clientExtensionEntryRel) {
        if (clientExtensionEntryRel == null) {
            return null;
        }
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.fastLoad((String)clientExtensionEntryRel.getTypeSettings()).build();
        if (unicodeProperties.isEmpty()) {
            return null;
        }
        HashMap<String, String> clientExtensionConfig = new HashMap<String, String>();
        for (Map.Entry entry : unicodeProperties.entrySet()) {
            clientExtensionConfig.put((String)entry.getKey(), (String)entry.getValue());
        }
        return clientExtensionConfig;
    }

    private ClientExtension[] _getClientExtensions(long classNameId, DTOConverterContext dtoConverterContext, Layout layout, String type) {
        Object[] clientExtensions = (ClientExtension[])TransformUtil.transformToArray((Collection)this._clientExtensionEntryRelLocalService.getClientExtensionEntryRels(classNameId, layout.getPlid(), type), clientExtensionEntryRel -> {
            CET cet = this._cetManager.getCET(layout.getCompanyId(), clientExtensionEntryRel.getCETExternalReferenceCode());
            if (cet == null) {
                return null;
            }
            return new ClientExtension((ClientExtensionEntryRel)clientExtensionEntryRel, cet, dtoConverterContext){
                final /* synthetic */ ClientExtensionEntryRel val$clientExtensionEntryRel;
                final /* synthetic */ CET val$cet;
                final /* synthetic */ DTOConverterContext val$dtoConverterContext;
                {
                    this.val$clientExtensionEntryRel = clientExtensionEntryRel;
                    this.val$cet = cET;
                    this.val$dtoConverterContext = dTOConverterContext;
                    this.clientExtensionConfig = PageDefinitionDTOConverter.this._getClientExtensionConfig(this.val$clientExtensionEntryRel);
                    this.externalReferenceCode = this.val$cet.getExternalReferenceCode();
                    this.name = this.val$cet.getName(this.val$dtoConverterContext.getLocale());
                }
            };
        }, ClientExtension.class);
        if (ArrayUtil.isEmpty((Object[])clientExtensions)) {
            return null;
        }
        return clientExtensions;
    }

    private ClientExtension _getThemeCSSClientExtension(long classNameId, Layout layout, final DTOConverterContext dtoConverterContext) {
        final CET cet = this._getCET(classNameId, layout.getPlid(), layout.getCompanyId(), "themeCSS");
        if (cet == null) {
            return null;
        }
        return new ClientExtension(){
            {
                this.externalReferenceCode = cet.getExternalReferenceCode();
                this.name = cet.getName(dtoConverterContext.getLocale());
            }
        };
    }

    private Settings _toSettings(final DTOConverterContext dtoConverterContext, final Layout layout) {
        final long classNameId = this._portal.getClassNameId(Layout.class.getName());
        final UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        return new Settings(){
            {
                this.globalCSSClientExtensions = PageDefinitionDTOConverter.this._getClientExtensions(classNameId, dtoConverterContext, layout, "globalCSS");
                this.globalJSClientExtensions = PageDefinitionDTOConverter.this._getClientExtensions(classNameId, dtoConverterContext, layout, "globalJS");
                this.themeCSSClientExtension = PageDefinitionDTOConverter.this._getThemeCSSClientExtension(classNameId, layout, dtoConverterContext);
                this.setColorSchemeName(() -> {
                    ColorScheme colorScheme;
                    block3: {
                        colorScheme = null;
                        try {
                            colorScheme = layout.getColorScheme();
                        }
                        catch (PortalException portalException) {
                            if (!_log.isWarnEnabled()) break block3;
                            _log.warn((Throwable)portalException);
                        }
                    }
                    if (colorScheme == null) {
                        return null;
                    }
                    return colorScheme.getName();
                });
                this.setCss(() -> {
                    if (Validator.isNull((String)layout.getCss())) {
                        return null;
                    }
                    return layout.getCss();
                });
                this.setFavIcon(() -> {
                    final CET cet = PageDefinitionDTOConverter.this._getCET(classNameId, layout.getPlid(), layout.getCompanyId(), "themeFavicon");
                    if (cet != null) {
                        return new ClientExtension(){
                            {
                                this.externalReferenceCode = cet.getExternalReferenceCode();
                                this.name = cet.getName(dtoConverterContext.getLocale());
                            }
                        };
                    }
                    long faviconFileEntryId = layout.getFaviconFileEntryId();
                    if (faviconFileEntryId != 0L) {
                        return ContentDocumentUtil.toContentDocument((DLURLHelper)PageDefinitionDTOConverter.this._dlURLHelper, (String)"settings.favIcon.image", (FileEntry)PageDefinitionDTOConverter.this._dlAppService.getFileEntry(faviconFileEntryId), (UriInfo)dtoConverterContext.getUriInfo());
                    }
                    return null;
                });
                this.setJavascript(() -> {
                    for (Map.Entry entry : unicodeProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.equals("javascript")) continue;
                        return (String)entry.getValue();
                    }
                    return null;
                });
                this.setMasterPage(() -> {
                    final LayoutPageTemplateEntry layoutPageTemplateEntry = PageDefinitionDTOConverter.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getMasterLayoutPlid());
                    if (layoutPageTemplateEntry == null) {
                        return null;
                    }
                    return new MasterPage(){
                        {
                            this.key = layoutPageTemplateEntry.getLayoutPageTemplateEntryKey();
                        }
                    };
                });
                this.setStyleBook(() -> {
                    final StyleBookEntry styleBookEntry = PageDefinitionDTOConverter.this._styleBookEntryLocalService.fetchStyleBookEntry(layout.getStyleBookEntryId());
                    if (styleBookEntry == null) {
                        return null;
                    }
                    return new StyleBook(){
                        {
                            this.key = styleBookEntry.getStyleBookEntryKey();
                            this.name = styleBookEntry.getName();
                        }
                    };
                });
                this.setThemeName(() -> {
                    Theme theme = layout.getTheme();
                    if (theme == null) {
                        return null;
                    }
                    return theme.getName();
                });
                this.setThemeSettings(() -> {
                    UnicodeProperties themeSettingsUnicodeProperties = new UnicodeProperties();
                    for (Map.Entry entry : unicodeProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.startsWith("lfr-theme:")) continue;
                        themeSettingsUnicodeProperties.setProperty(key, (String)entry.getValue());
                    }
                    if (themeSettingsUnicodeProperties.isEmpty()) {
                        return null;
                    }
                    return themeSettingsUnicodeProperties;
                });
            }
        };
    }
}

