/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.headless.delivery.dto.v1_0.Experience;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.headless.delivery.dto.v1_0.PagePermission;
import com.liferay.headless.delivery.dto.v1_0.ParentSitePage;
import com.liferay.headless.delivery.dto.v1_0.SitePage;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.PageSettingsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RenderedPageUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.segments.model.SegmentsExperience;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.portal.kernel.model.Layout"}, service={DTOConverter.class})
public class SitePageDTOConverter
implements DTOConverter<Layout, SitePage> {
    private static final Log _log = LogFactoryUtil.getLog(SitePageDTOConverter.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DDMStorageEngineManager _ddmStorageEngineManager;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference(target="(component.name=com.liferay.headless.delivery.internal.dto.v1_0.converter.ExperienceDTOConverter)")
    private DTOConverter<SegmentsExperience, Experience> _experienceDTOConverter;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference(target="(component.name=com.liferay.headless.delivery.internal.dto.v1_0.converter.PageDefinitionDTOConverter)")
    private DTOConverter<LayoutStructure, PageDefinition> _pageDefinitionDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TeamLocalService _teamLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return SitePage.class.getSimpleName();
    }

    public SitePage toDTO(final DTOConverterContext dtoConverterContext, final Layout layout) throws Exception {
        return new SitePage(){
            {
                this.actions = dtoConverterContext.getActions();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(SitePageDTOConverter.this._ratingsStatsLocalService.fetchStats(Layout.class.getName(), layout.getPlid()));
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])layout.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator((Portal)SitePageDTOConverter.this._portal, (UriInfo)dtoConverterContext.getUriInfo(), (User)SitePageDTOConverter.this._userLocalService.fetchUser(layout.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)Layout.class.getName(), (long)layout.getPlid(), (long)layout.getCompanyId(), (Locale)dtoConverterContext.getLocale());
                this.dateCreated = layout.getCreateDate();
                this.dateModified = layout.getModifiedDate();
                this.datePublished = layout.getPublishDate();
                this.friendlyUrlPath = layout.getFriendlyURL(dtoConverterContext.getLocale());
                this.friendlyUrlPath_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getFriendlyURLMap());
                this.id = layout.getPlid();
                this.keywords = (String[])ListUtil.toArray((List)SitePageDTOConverter.this._assetTagLocalService.getTags(Layout.class.getName(), layout.getPlid()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.pageSettings = PageSettingsUtil.getPageSettings(SitePageDTOConverter.this._ddmStorageEngineManager, SitePageDTOConverter.this._dlAppService, SitePageDTOConverter.this._dlURLHelper, dtoConverterContext, SitePageDTOConverter.this._layoutSEOEntryLocalService, layout);
                this.renderedPage = RenderedPageUtil.getRenderedPage(dtoConverterContext, layout, SitePageDTOConverter.this._layoutPageTemplateEntryLocalService, SitePageDTOConverter.this._portal);
                this.siteId = layout.getGroupId();
                this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)SitePageDTOConverter.this._assetCategoryLocalService.getCategories(Layout.class.getName(), layout.getPlid()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, dtoConverterContext), TaxonomyCategoryBrief.class);
                this.title = layout.getName(dtoConverterContext.getLocale());
                this.title_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getNameMap());
                this.uuid = layout.getUuid();
                this.setExperience(() -> {
                    boolean showSegmentsExperience = GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("showExperience"));
                    if (!showSegmentsExperience) {
                        return null;
                    }
                    SegmentsExperience segmentsExperience = (SegmentsExperience)dtoConverterContext.getAttribute("segmentsExperience");
                    return (Experience)SitePageDTOConverter.this._experienceDTOConverter.toDTO(dtoConverterContext, (Object)segmentsExperience);
                });
                this.setPageDefinition(() -> {
                    boolean embeddedPageDefinition = GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("embeddedPageDefinition"));
                    if (!layout.isTypeContent() || !embeddedPageDefinition) {
                        return null;
                    }
                    dtoConverterContext.setAttribute("layout", (Object)layout);
                    LayoutPageTemplateStructure layoutPageTemplateStructure = SitePageDTOConverter.this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
                    if (layoutPageTemplateStructure == null) {
                        return null;
                    }
                    String segmentsExperienceKey = "DEFAULT";
                    SegmentsExperience segmentsExperience = (SegmentsExperience)dtoConverterContext.getAttribute("segmentsExperience");
                    if (segmentsExperience != null) {
                        segmentsExperienceKey = segmentsExperience.getSegmentsExperienceKey();
                    }
                    LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperienceKey));
                    return (PageDefinition)SitePageDTOConverter.this._pageDefinitionDTOConverter.toDTO(dtoConverterContext, (Object)layoutStructure);
                });
                this.setPagePermissions(() -> {
                    List resourcePermissions = SitePageDTOConverter.this._resourcePermissionLocalService.getResourcePermissions(layout.getCompanyId(), Layout.class.getName(), 4, String.valueOf(layout.getPlid()));
                    if (ListUtil.isEmpty((List)resourcePermissions)) {
                        return null;
                    }
                    List resourceActions = SitePageDTOConverter.this._resourceActionLocalService.getResourceActions(Layout.class.getName());
                    if (ListUtil.isEmpty((List)resourceActions)) {
                        return null;
                    }
                    ArrayList<1> pagePermissions = new ArrayList<1>();
                    for (ResourcePermission resourcePermission : resourcePermissions) {
                        Team team;
                        Role role = SitePageDTOConverter.this._roleLocalService.fetchRole(resourcePermission.getRoleId());
                        if (role == null) {
                            if (!_log.isWarnEnabled()) continue;
                            _log.warn((Object)String.format("Resource permission %s will not be included since no role was found with role ID %s", resourcePermission.getName(), resourcePermission.getRoleId()));
                            continue;
                        }
                        final HashSet<String> actionIdsSet = new HashSet<String>();
                        long actionIds = resourcePermission.getActionIds();
                        for (ResourceAction resourceAction : resourceActions) {
                            long bitwiseValue = resourceAction.getBitwiseValue();
                            if ((actionIds & bitwiseValue) != bitwiseValue) continue;
                            actionIdsSet.add(resourceAction.getActionId());
                        }
                        String roleKey = role.getName();
                        if (role.getClassNameId() == SitePageDTOConverter.this._portal.getClassNameId(Team.class) && (team = SitePageDTOConverter.this._teamLocalService.fetchTeam(role.getClassPK())) != null) {
                            roleKey = team.getName();
                        }
                        final String finalRoleKey = roleKey;
                        pagePermissions.add(new PagePermission(){
                            {
                                this.actionKeys = actionIdsSet.toArray(new String[0]);
                                this.roleKey = finalRoleKey;
                            }
                        });
                    }
                    return pagePermissions.toArray(new PagePermission[0]);
                });
                this.setPageType(() -> {
                    LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController((String)layout.getType());
                    return SitePageDTOConverter.this._language.get(dtoConverterContext.getHttpServletRequest(), ResourceBundleUtil.getBundle((String)"content.Language", (Locale)dtoConverterContext.getLocale(), layoutTypeController.getClass()), "layout.types." + layout.getType());
                });
                this.setParentSitePage(() -> {
                    if (layout.getParentLayoutId() == 0L) {
                        return null;
                    }
                    final Layout parentLayout = SitePageDTOConverter.this._layoutLocalService.fetchLayout(layout.getParentPlid());
                    return new ParentSitePage(){
                        {
                            this.friendlyUrlPath = parentLayout.getFriendlyURL();
                        }
                    };
                });
            }
        };
    }
}

