/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentFolder;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Locale;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.journal.model.JournalFolder"}, service={DTOConverter.class})
public class StructuredContentFolderDTOConverter
implements DTOConverter<DLFolder, StructuredContentFolder> {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalFolderService _journalFolderService;
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return StructuredContentFolder.class.getSimpleName();
    }

    public StructuredContentFolder toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final JournalFolder journalFolder = this._journalFolderService.getFolder(((Long)dtoConverterContext.getId()).longValue());
        final Group group = this._groupLocalService.fetchGroup(journalFolder.getGroupId());
        return new StructuredContentFolder(){
            {
                this.actions = dtoConverterContext.getActions();
                this.assetLibraryKey = GroupUtil.getAssetLibraryKey((Group)group);
                this.creator = CreatorUtil.toCreator((Portal)StructuredContentFolderDTOConverter.this._portal, (UriInfo)dtoConverterContext.getUriInfo(), (User)StructuredContentFolderDTOConverter.this._userLocalService.fetchUser(journalFolder.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)JournalFolder.class.getName(), (long)journalFolder.getFolderId(), (long)journalFolder.getCompanyId(), (Locale)dtoConverterContext.getLocale());
                this.dateCreated = journalFolder.getCreateDate();
                this.dateModified = journalFolder.getModifiedDate();
                this.description = journalFolder.getDescription();
                this.externalReferenceCode = journalFolder.getExternalReferenceCode();
                this.id = journalFolder.getFolderId();
                this.name = journalFolder.getName();
                this.numberOfStructuredContentFolders = StructuredContentFolderDTOConverter.this._journalFolderService.getFoldersCount(journalFolder.getGroupId(), journalFolder.getFolderId());
                this.numberOfStructuredContents = StructuredContentFolderDTOConverter.this._journalArticleService.getArticlesCount(journalFolder.getGroupId(), journalFolder.getFolderId(), 0);
                this.siteId = GroupUtil.getSiteId((Group)group);
                this.subscribed = StructuredContentFolderDTOConverter.this._subscriptionLocalService.isSubscribed(journalFolder.getCompanyId(), dtoConverterContext.getUserId(), JournalFolder.class.getName(), journalFolder.getFolderId());
                this.setParentStructuredContentFolderId(() -> {
                    if (journalFolder.getParentFolderId() == 0L) {
                        return null;
                    }
                    return journalFolder.getParentFolderId();
                });
            }
        };
    }
}

