/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.link.service.AssetLinkLocalService;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.wiki.model.WikiPage"}, service={DTOConverter.class})
public class WikiPageDTOConverter
implements DTOConverter<WikiPage, com.liferay.headless.delivery.dto.v1_0.WikiPage> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WikiPageService _wikiPageService;

    public String getContentType() {
        return com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getSimpleName();
    }

    public com.liferay.headless.delivery.dto.v1_0.WikiPage toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final WikiPage wikiPage = this._wikiPageService.getPage(((Long)dtoConverterContext.getId()).longValue());
        return new com.liferay.headless.delivery.dto.v1_0.WikiPage(){
            {
                this.actions = dtoConverterContext.getActions();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(WikiPageDTOConverter.this._ratingsStatsLocalService.fetchStats(WikiPage.class.getName(), wikiPage.getResourcePrimKey()));
                this.content = wikiPage.getContent();
                this.creator = CreatorUtil.toCreator((Portal)WikiPageDTOConverter.this._portal, (UriInfo)dtoConverterContext.getUriInfo(), (User)WikiPageDTOConverter.this._userLocalService.fetchUser(wikiPage.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)WikiPage.class.getName(), (long)wikiPage.getPageId(), (long)wikiPage.getCompanyId(), (Locale)dtoConverterContext.getLocale());
                this.dateCreated = wikiPage.getCreateDate();
                this.dateModified = wikiPage.getModifiedDate();
                this.description = wikiPage.getSummary();
                this.encodingFormat = WikiPageDTOConverter.this._getEncodingFormat(wikiPage);
                this.externalReferenceCode = wikiPage.getExternalReferenceCode();
                this.headline = wikiPage.getTitle();
                this.id = wikiPage.getResourcePrimKey();
                this.keywords = (String[])ListUtil.toArray((List)WikiPageDTOConverter.this._assetTagLocalService.getTags(BlogsEntry.class.getName(), wikiPage.getPageId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfAttachments = wikiPage.getAttachmentsFileEntriesCount();
                this.relatedContents = RelatedContentUtil.toRelatedContents(WikiPageDTOConverter.this._assetEntryLocalService, WikiPageDTOConverter.this._assetLinkLocalService, WikiPageDTOConverter.this._dtoConverterRegistry, wikiPage.getModelClassName(), wikiPage.getResourcePrimKey(), dtoConverterContext.getLocale());
                this.siteId = wikiPage.getGroupId();
                this.subscribed = WikiPageDTOConverter.this._subscriptionLocalService.isSubscribed(wikiPage.getCompanyId(), dtoConverterContext.getUserId(), WikiPage.class.getName(), wikiPage.getResourcePrimKey());
                this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)WikiPageDTOConverter.this._assetCategoryLocalService.getCategories(WikiPage.class.getName(), wikiPage.getPageId()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, (DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), Collections.emptyMap(), WikiPageDTOConverter.this._dtoConverterRegistry, dtoConverterContext.getHttpServletRequest(), (Object)assetCategory.getCategoryId(), dtoConverterContext.getLocale(), dtoConverterContext.getUriInfo(), dtoConverterContext.getUser())), TaxonomyCategoryBrief.class);
                this.wikiNodeId = wikiPage.getNodeId();
                this.setNumberOfWikiPages(() -> {
                    List wikiPages = wikiPage.getChildPages();
                    if (wikiPages != null) {
                        return wikiPages.size();
                    }
                    return 0;
                });
                this.setParentWikiPageId(() -> {
                    WikiPage parentWikiPage = wikiPage.getParentPage();
                    if (parentWikiPage == null || parentWikiPage.getPageId() == 0L) {
                        return null;
                    }
                    return parentWikiPage.getResourcePrimKey();
                });
            }
        };
    }

    private String _getEncodingFormat(WikiPage wikiPage) {
        String format = wikiPage.getFormat();
        if (format.equals("creole")) {
            return "text/x-wiki";
        }
        if (format.equals("html")) {
            return "text/html";
        }
        if (format.equals("plain_text")) {
            return "text/plain";
        }
        return format;
    }
}

