/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.headless.delivery.dto.v1_0.FragmentInlineValue;
import com.liferay.headless.delivery.dto.v1_0.FragmentLink;
import com.liferay.headless.delivery.dto.v1_0.HtmlProperties;
import com.liferay.headless.delivery.dto.v1_0.Layout;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.dto.v1_0.PageSectionDefinition;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.BaseStyledLayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.FragmentMappedValueUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.LocalizedValueUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.StyledLayoutStructureItemUtil;
import com.liferay.layout.converter.AlignConverter;
import com.liferay.layout.converter.BorderRadiusConverter;
import com.liferay.layout.converter.ContentDisplayConverter;
import com.liferay.layout.converter.ContentVisibilityConverter;
import com.liferay.layout.converter.FlexWrapConverter;
import com.liferay.layout.converter.HtmlTagConverter;
import com.liferay.layout.converter.JustifyConverter;
import com.liferay.layout.converter.MarginConverter;
import com.liferay.layout.converter.PaddingConverter;
import com.liferay.layout.converter.ShadowConverter;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;

@Component(service={LayoutStructureItemMapper.class})
public class ContainerLayoutStructureItemMapper
extends BaseStyledLayoutStructureItemMapper {
    @Override
    public String getClassName() {
        return ContainerStyledLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(long groupId, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, final boolean saveMappingConfiguration) {
        final ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem = (ContainerStyledLayoutStructureItem)layoutStructureItem;
        return new PageElement(){
            {
                this.definition = new PageSectionDefinition(){
                    {
                        this.cssClasses = StyledLayoutStructureItemUtil.getCssClasses((StyledLayoutStructureItem)containerStyledLayoutStructureItem);
                        this.customCSS = StyledLayoutStructureItemUtil.getCustomCSS((StyledLayoutStructureItem)containerStyledLayoutStructureItem);
                        this.customCSSViewports = StyledLayoutStructureItemUtil.getCustomCSSViewports((StyledLayoutStructureItem)containerStyledLayoutStructureItem);
                        this.fragmentLink = ContainerLayoutStructureItemMapper.this._toFragmentLink(containerStyledLayoutStructureItem.getLinkJSONObject(), saveMappingConfiguration);
                        this.indexed = containerStyledLayoutStructureItem.isIndexed();
                        this.layout = ContainerLayoutStructureItemMapper.this._toLayout(containerStyledLayoutStructureItem);
                        this.setContentVisibility(() -> {
                            String contentVisibility = containerStyledLayoutStructureItem.getContentVisibility();
                            if (Validator.isNull((String)contentVisibility)) {
                                return null;
                            }
                            return ContentVisibilityConverter.convertToExternalValue((String)contentVisibility);
                        });
                        this.setFragmentStyle(() -> {
                            JSONObject itemConfigJSONObject = containerStyledLayoutStructureItem.getItemConfigJSONObject();
                            return ContainerLayoutStructureItemMapper.this.toFragmentStyle(itemConfigJSONObject.getJSONObject("styles"), saveMappingConfiguration);
                        });
                        this.setFragmentViewports(() -> ContainerLayoutStructureItemMapper.this.getFragmentViewPorts(containerStyledLayoutStructureItem.getItemConfigJSONObject()));
                        this.setHtmlProperties(() -> ContainerLayoutStructureItemMapper.this._toHtmlProperties(containerStyledLayoutStructureItem));
                        this.setName(() -> ((ContainerStyledLayoutStructureItem)containerStyledLayoutStructureItem).getName());
                    }
                };
                this.type = PageElement.Type.SECTION;
            }
        };
    }

    private Object _getStyleProperty(JSONObject stylesJSONObject, String propertyKey) {
        return stylesJSONObject.get(propertyKey);
    }

    private FragmentLink _toFragmentLink(final JSONObject jsonObject, boolean saveMapping) {
        if (jsonObject == null) {
            return null;
        }
        final boolean saveFragmentMappedValue = FragmentMappedValueUtil.isSaveFragmentMappedValue(jsonObject, saveMapping);
        if (jsonObject.isNull("href") && !saveFragmentMappedValue) {
            return null;
        }
        return new FragmentLink(){
            {
                this.setHref(() -> {
                    if (saveFragmentMappedValue) {
                        return ContainerLayoutStructureItemMapper.this.toFragmentMappedValue(ContainerLayoutStructureItemMapper.this.toDefaultMappingValue(jsonObject, null), jsonObject);
                    }
                    return new FragmentInlineValue(){
                        {
                            this.value_i18n = LocalizedValueUtil.toLocalizedValues(jsonObject.getJSONObject("href"));
                        }
                    };
                });
                this.setTarget(() -> {
                    String target = jsonObject.getString("target");
                    if (Validator.isNull((String)target)) {
                        return null;
                    }
                    if (StringUtil.equalsIgnoreCase((String)target, (String)"_parent") || StringUtil.equalsIgnoreCase((String)target, (String)"_top")) {
                        target = "_self";
                    }
                    return FragmentLink.Target.create((String)StringUtil.upperCaseFirstLetter((String)target.substring(1)));
                });
            }
        };
    }

    private HtmlProperties _toHtmlProperties(ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem) {
        final String value = containerStyledLayoutStructureItem.getHtmlTag();
        if (Validator.isNull((String)value)) {
            return null;
        }
        return new HtmlProperties(){
            {
                this.setHtmlTag(() -> HtmlProperties.HtmlTag.create((String)HtmlTagConverter.convertToExternalValue((String)value)));
            }
        };
    }

    private Layout _toLayout(final ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem) {
        JSONObject itemConfigJSONObject = containerStyledLayoutStructureItem.getItemConfigJSONObject();
        final JSONObject stylesJSONObject = itemConfigJSONObject.getJSONObject("styles");
        return new Layout(){
            {
                this.setAlign(() -> {
                    String align = containerStyledLayoutStructureItem.getAlign();
                    if (Validator.isNull((String)align)) {
                        return null;
                    }
                    return Layout.Align.create((String)AlignConverter.convertToExternalValue((String)align));
                });
                this.setBorderColor(() -> {
                    Object borderColor = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "borderColor");
                    if (Validator.isNull((Object)borderColor)) {
                        return null;
                    }
                    return GetterUtil.getString((Object)borderColor);
                });
                this.setBorderRadius(() -> {
                    Object borderRadius = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "borderRadius");
                    if (Validator.isNull((Object)borderRadius)) {
                        return null;
                    }
                    return Layout.BorderRadius.create((String)BorderRadiusConverter.convertToExternalValue((String)GetterUtil.getString((Object)borderRadius)));
                });
                this.setBorderWidth(() -> {
                    Object borderWidth = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "borderWidth");
                    if (Validator.isNull((Object)borderWidth) || GetterUtil.getInteger((Object)borderWidth) == 0) {
                        return null;
                    }
                    return GetterUtil.getInteger((Object)borderWidth);
                });
                this.setContentDisplay(() -> {
                    String contentDisplay = containerStyledLayoutStructureItem.getContentDisplay();
                    if (Validator.isNull((Object)contentDisplay)) {
                        return null;
                    }
                    return Layout.ContentDisplay.create((String)ContentDisplayConverter.convertToExternalValue((String)GetterUtil.getString((Object)contentDisplay)));
                });
                this.setFlexWrap(() -> {
                    String flexWrap = containerStyledLayoutStructureItem.getFlexWrap();
                    if (Validator.isNull((String)flexWrap)) {
                        return null;
                    }
                    return Layout.FlexWrap.create((String)FlexWrapConverter.convertToExternalValue((String)flexWrap));
                });
                this.setJustify(() -> {
                    String justify = containerStyledLayoutStructureItem.getJustify();
                    if (Validator.isNull((String)justify)) {
                        return null;
                    }
                    return Layout.Justify.create((String)JustifyConverter.convertToExternalValue((String)justify));
                });
                this.setMarginBottom(() -> {
                    Object marginBottom = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "marginBottom");
                    if (Validator.isNull((Object)marginBottom) || Validator.isNull((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)marginBottom)))) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)marginBottom)));
                });
                this.setMarginLeft(() -> {
                    Object marginLeft = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "marginLeft");
                    if (Validator.isNull((Object)marginLeft) || Validator.isNull((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)marginLeft)))) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)marginLeft)));
                });
                this.setMarginRight(() -> {
                    Object marginRight = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "marginRight");
                    if (Validator.isNull((Object)marginRight) || Validator.isNull((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)marginRight)))) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)marginRight)));
                });
                this.setMarginTop(() -> {
                    Object marginTop = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "marginTop");
                    if (Validator.isNull((Object)marginTop) || Validator.isNull((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)marginTop)))) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)marginTop)));
                });
                this.setOpacity(() -> {
                    Object opacity = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "opacity");
                    if (Validator.isNull((Object)opacity) || Objects.equals(opacity, "100")) {
                        return null;
                    }
                    return GetterUtil.getInteger((Object)opacity, (int)100);
                });
                this.setPaddingBottom(() -> {
                    Object paddingBottom = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "paddingBottom");
                    if (Validator.isNull((Object)paddingBottom) || Validator.isNull((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)paddingBottom)))) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)PaddingConverter.convertToExternalValue((String)GetterUtil.getString((Object)paddingBottom)));
                });
                this.setPaddingLeft(() -> {
                    Object paddingLeft = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "paddingLeft");
                    if (Validator.isNull((Object)paddingLeft) || Validator.isNull((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)paddingLeft)))) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)PaddingConverter.convertToExternalValue((String)GetterUtil.getString((Object)paddingLeft)));
                });
                this.setPaddingRight(() -> {
                    Object paddingRight = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "paddingRight");
                    if (Validator.isNull((Object)paddingRight) || Validator.isNull((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)paddingRight)))) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)PaddingConverter.convertToExternalValue((String)GetterUtil.getString((Object)paddingRight)));
                });
                this.setPaddingTop(() -> {
                    Object paddingTop = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "paddingTop");
                    if (Validator.isNull((Object)paddingTop) || Validator.isNull((String)MarginConverter.convertToExternalValue((String)GetterUtil.getString((Object)paddingTop)))) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)PaddingConverter.convertToExternalValue((String)GetterUtil.getString((Object)paddingTop)));
                });
                this.setShadow(() -> {
                    Object shadow = ContainerLayoutStructureItemMapper.this._getStyleProperty(stylesJSONObject, "shadow");
                    if (Validator.isNull((Object)shadow)) {
                        return null;
                    }
                    return Layout.Shadow.create((String)ShadowConverter.convertToExternalValue((String)GetterUtil.getString((Object)shadow)));
                });
                this.setWidthType(() -> {
                    String widthType = containerStyledLayoutStructureItem.getWidthType();
                    if (Validator.isNotNull((String)widthType) && !Objects.equals(widthType, "fluid")) {
                        return Layout.WidthType.create((String)StringUtil.upperCaseFirstLetter((String)widthType));
                    }
                    return null;
                });
            }
        };
    }
}

