/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.BaseStyledLayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.PageFragmentInstanceDefinitionMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.WidgetInstanceMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.util.PageWidgetInstanceDefinitionUtil;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureItemMapper.class})
public class FragmentLayoutStructureItemMapper
extends BaseStyledLayoutStructureItemMapper {
    private static final Log _log = LogFactoryUtil.getLog(FragmentLayoutStructureItemMapper.class);
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private PageFragmentInstanceDefinitionMapper _pageFragmentInstanceDefinitionMapper;
    @Reference
    private WidgetInstanceMapper _widgetInstanceMapper;

    @Override
    public String getClassName() {
        return FragmentStyledLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(long groupId, LayoutStructureItem layoutStructureItem, final boolean saveInlineContent, final boolean saveMappingConfiguration) {
        final FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem;
        final FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId());
        if (fragmentEntryLink == null) {
            return null;
        }
        JSONObject editableValuesJSONObject = null;
        try {
            editableValuesJSONObject = this._jsonFactory.createJSONObject(fragmentEntryLink.getEditableValues());
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return null;
        }
        final String portletId = editableValuesJSONObject.getString("portletId");
        final JSONObject itemConfigJSONObject = fragmentStyledLayoutStructureItem.getItemConfigJSONObject();
        if (Validator.isNull((String)portletId)) {
            return new PageElement(){
                {
                    this.definition = FragmentLayoutStructureItemMapper.this._pageFragmentInstanceDefinitionMapper.getPageFragmentInstanceDefinition(fragmentStyledLayoutStructureItem, FragmentLayoutStructureItemMapper.this.toFragmentStyle(itemConfigJSONObject.getJSONObject("styles"), saveMappingConfiguration), FragmentLayoutStructureItemMapper.this.getFragmentViewPorts(itemConfigJSONObject), saveInlineContent, saveMappingConfiguration);
                    this.type = PageElement.Type.FRAGMENT;
                }
            };
        }
        final String instanceId = editableValuesJSONObject.getString("instanceId");
        return new PageElement(){
            {
                this.definition = PageWidgetInstanceDefinitionUtil.toPageWidgetInstanceDefinition(fragmentEntryLink, fragmentStyledLayoutStructureItem, itemConfigJSONObject.getString("name", null), FragmentLayoutStructureItemMapper.this.toFragmentStyle(itemConfigJSONObject.getJSONObject("styles"), saveMappingConfiguration), FragmentLayoutStructureItemMapper.this.getFragmentViewPorts(itemConfigJSONObject.getJSONObject("style")), PortletIdCodec.encode((String)portletId, (String)instanceId), FragmentLayoutStructureItemMapper.this._widgetInstanceMapper);
                this.type = PageElement.Type.WIDGET;
            }
        };
    }
}

