/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper.util;

import com.liferay.headless.delivery.dto.v1_0.ClassFieldsReference;
import com.liferay.headless.delivery.dto.v1_0.ClassPKReference;
import com.liferay.headless.delivery.dto.v1_0.ContextReference;
import com.liferay.headless.delivery.dto.v1_0.Field;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;

public class FragmentMappedValueUtil {
    private static final Log _log = LogFactoryUtil.getLog(FragmentMappedValueUtil.class);

    public static String getFieldKey(JSONObject jsonObject) {
        String collectionFieldId = jsonObject.getString("collectionFieldId");
        if (Validator.isNotNull((String)collectionFieldId)) {
            return collectionFieldId;
        }
        String fieldId = jsonObject.getString("fieldId");
        if (Validator.isNotNull((String)fieldId)) {
            return fieldId;
        }
        String mappedField = jsonObject.getString("mappedField");
        if (Validator.isNotNull((String)mappedField)) {
            return mappedField;
        }
        return null;
    }

    public static boolean isSaveFragmentMappedValue(JSONObject jsonObject, boolean saveMapping) {
        if (jsonObject == null || !saveMapping) {
            return false;
        }
        if (jsonObject.has("classNameId") && jsonObject.has("classPK") && jsonObject.has("fieldId")) {
            return true;
        }
        return jsonObject.has("collectionFieldId") || jsonObject.has("layout") || jsonObject.has("mappedField");
    }

    public static Object toItemReference(final JSONObject jsonObject) {
        String collectionFieldId = jsonObject.getString("collectionFieldId");
        String fieldId = jsonObject.getString("fieldId");
        JSONObject layoutJSONObject = jsonObject.getJSONObject("layout");
        String mappedField = jsonObject.getString("mappedField");
        if (Validator.isNull((String)collectionFieldId) && Validator.isNull((String)fieldId) && layoutJSONObject == null && Validator.isNull((String)mappedField)) {
            return null;
        }
        if (Validator.isNotNull((String)collectionFieldId)) {
            return new ContextReference(){
                {
                    this.contextSource = ContextReference.ContextSource.COLLECTION_ITEM;
                }
            };
        }
        if (layoutJSONObject != null) {
            return FragmentMappedValueUtil.toLayoutClassFieldsReference(layoutJSONObject);
        }
        if (Validator.isNotNull((String)mappedField)) {
            return new ContextReference(){
                {
                    this.contextSource = ContextReference.ContextSource.DISPLAY_PAGE_ITEM;
                }
            };
        }
        return new ClassPKReference(){
            {
                this.className = FragmentMappedValueUtil._toItemClassName(jsonObject);
                this.classPK = FragmentMappedValueUtil._toItemClassPK(jsonObject);
            }
        };
    }

    public static ClassFieldsReference toLayoutClassFieldsReference(JSONObject layoutJSONObject) {
        Layout layout;
        try {
            layout = LayoutLocalServiceUtil.getLayout((long)layoutJSONObject.getLong("groupId"), (boolean)layoutJSONObject.getBoolean("privateLayout"), (long)layoutJSONObject.getLong("layoutId"));
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Item reference could not be set since no layout could be obtained", (Throwable)portalException);
            }
            return null;
        }
        return new ClassFieldsReference(){
            {
                this.className = Layout.class.getName();
                this.setFields(() -> {
                    Field friendlyURLField = new Field();
                    friendlyURLField.setFieldName("friendlyURL");
                    friendlyURLField.setFieldValue(layout.getFriendlyURL());
                    Field privatePageField = new Field();
                    privatePageField.setFieldName("privatePage");
                    privatePageField.setFieldValue(String.valueOf(layout.isPrivateLayout()));
                    Field siteKeyField = new Field();
                    Group group = GroupLocalServiceUtil.getGroup((long)layout.getGroupId());
                    siteKeyField.setFieldName("siteKey");
                    siteKeyField.setFieldValue(group.getGroupKey());
                    return new Field[]{friendlyURLField, privatePageField, siteKeyField};
                });
            }
        };
    }

    private static String _toItemClassName(JSONObject jsonObject) {
        String classNameIdString = jsonObject.getString("classNameId");
        if (Validator.isNull((String)classNameIdString)) {
            return null;
        }
        long classNameId = 0L;
        try {
            classNameId = Long.parseLong(classNameIdString);
        }
        catch (NumberFormatException numberFormatException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)String.format("Item class name could not be set since class name ID %s could not be parsed to a long", classNameIdString), (Throwable)numberFormatException);
            }
            return null;
        }
        String className = null;
        try {
            className = PortalUtil.getClassName((long)classNameId);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Item class name could not be set since no class name could be obtained for class name ID " + classNameId), (Throwable)exception);
            }
            return null;
        }
        return className;
    }

    private static Long _toItemClassPK(JSONObject jsonObject) {
        String classPKString = jsonObject.getString("classPK");
        if (Validator.isNull((String)classPKString)) {
            return null;
        }
        Long classPK = null;
        try {
            classPK = Long.parseLong(classPKString);
        }
        catch (NumberFormatException numberFormatException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)String.format("Item class PK could not be set since class PK %s could not be parsed to a long", classPKString), (Throwable)numberFormatException);
            }
            return null;
        }
        return classPK;
    }
}

