/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.headless.delivery.dto.v1_0.ContentTemplate;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import javax.ws.rs.core.UriInfo;

public class ContentTemplateUtil {
    public static ContentTemplate toContentTemplate(final DDMTemplate ddmTemplate, final DTOConverterContext dtoConverterContext, GroupLocalService groupLocalService, final Portal portal, final UserLocalService userLocalService) {
        final Group group = groupLocalService.fetchGroup(ddmTemplate.getGroupId());
        return new ContentTemplate(){
            {
                this.actions = dtoConverterContext.getActions();
                this.assetLibraryKey = GroupUtil.getAssetLibraryKey((Group)group);
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])ddmTemplate.getAvailableLanguageIds());
                this.contentStructureId = ddmTemplate.getClassPK();
                this.creator = CreatorUtil.toCreator((Portal)portal, (UriInfo)dtoConverterContext.getUriInfo(), (User)userLocalService.fetchUser(ddmTemplate.getUserId()));
                this.dateCreated = ddmTemplate.getCreateDate();
                this.dateModified = ddmTemplate.getModifiedDate();
                this.description = ddmTemplate.getDescription(dtoConverterContext.getLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)ddmTemplate.getDescriptionMap());
                this.id = ddmTemplate.getTemplateKey();
                this.name = ddmTemplate.getName(dtoConverterContext.getLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)ddmTemplate.getNameMap());
                this.programmingLanguage = ddmTemplate.getLanguage();
                this.siteId = GroupUtil.getSiteId((Group)group);
                this.templateScript = ddmTemplate.getScript();
            }
        };
    }
}

