/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.OpenGraphSettings;
import com.liferay.headless.delivery.dto.v1_0.util.ContentDocumentUtil;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import javax.ws.rs.core.UriInfo;

public class OpenGraphSettingsUtil {
    public static OpenGraphSettings getOpenGraphSettings(final DLAppService dlAppService, final DLURLHelper dlURLHelper, final DTOConverterContext dtoConverterContext, LayoutSEOEntryLocalService layoutSEOEntryLocalService, Layout layout) {
        final LayoutSEOEntry layoutSEOEntry = layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null) {
            return null;
        }
        return new OpenGraphSettings(){
            {
                this.description = layoutSEOEntry.getOpenGraphDescription(dtoConverterContext.getLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layoutSEOEntry.getOpenGraphDescriptionMap());
                this.imageAlt = layoutSEOEntry.getOpenGraphImageAlt(dtoConverterContext.getLocale());
                this.imageAlt_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layoutSEOEntry.getOpenGraphImageAltMap());
                this.title = layoutSEOEntry.getOpenGraphTitle(dtoConverterContext.getLocale());
                this.title_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layoutSEOEntry.getOpenGraphTitleMap());
                this.setImage(() -> {
                    long openGraphImageFileEntryId = layoutSEOEntry.getOpenGraphImageFileEntryId();
                    if (openGraphImageFileEntryId == 0L) {
                        return null;
                    }
                    return ContentDocumentUtil.toContentDocument((DLURLHelper)dlURLHelper, (String)"openGraphSettings.contentFieldValue.image", (FileEntry)dlAppService.getFileEntry(openGraphImageFileEntryId), (UriInfo)dtoConverterContext.getUriInfo());
                });
            }
        };
    }
}

