/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.headless.delivery.dto.v1_0.CustomMetaTag;
import com.liferay.headless.delivery.dto.v1_0.PageSettings;
import com.liferay.headless.delivery.dto.v1_0.SitePageNavigationMenuSettings;
import com.liferay.headless.delivery.internal.dto.v1_0.util.OpenGraphSettingsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.SEOSettingsUtil;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class PageSettingsUtil {
    public static PageSettings getPageSettings(final DDMStorageEngineManager ddmStorageEngineManager, final DLAppService dlAppService, final DLURLHelper dlURLHelper, final DTOConverterContext dtoConverterContext, final LayoutSEOEntryLocalService layoutSEOEntryLocalService, final Layout layout) {
        return new PageSettings(){
            {
                this.hiddenFromNavigation = layout.isHidden();
                this.openGraphSettings = OpenGraphSettingsUtil.getOpenGraphSettings(dlAppService, dlURLHelper, dtoConverterContext, layoutSEOEntryLocalService, layout);
                this.seoSettings = SEOSettingsUtil.getSeoSettings(dtoConverterContext, layoutSEOEntryLocalService, layout);
                this.sitePageNavigationMenuSettings = PageSettingsUtil._toSitePageNavigationMenuSettings(layout.getTypeSettingsProperties());
                this.setCustomMetaTags(() -> PageSettingsUtil._getCustomMetaTags(dtoConverterContext, layout, layoutSEOEntryLocalService, dtoConverterContext.getLocale(), ddmStorageEngineManager));
            }
        };
    }

    private static CustomMetaTag[] _getCustomMetaTags(final DTOConverterContext dtoConverterContext, Layout layout, LayoutSEOEntryLocalService layoutSEOEntryLocalService, Locale locale, DDMStorageEngineManager ddmStorageEngineManager) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null || layoutSEOEntry.getDDMStorageId() == 0L) {
            return null;
        }
        ArrayList<2> customMetaTags = new ArrayList<2>();
        DDMFormValues ddmFormValues = ddmStorageEngineManager.getDDMFormValues(layoutSEOEntry.getDDMStorageId());
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            Value value = ddmFormFieldValue.getValue();
            final String valueString = value.getString(LocaleUtil.ROOT);
            List nestedDDMFormFieldValues = ddmFormFieldValue.getNestedDDMFormFieldValues();
            DDMFormFieldValue nestedDDMFormFieldValue = (DDMFormFieldValue)nestedDDMFormFieldValues.get(0);
            value = nestedDDMFormFieldValue.getValue();
            final String nestedValueString = value.getString(locale);
            final Map nestedValuesLocaleMap = value.getValues();
            customMetaTags.add(new CustomMetaTag(){
                {
                    this.key = valueString;
                    this.value = nestedValueString;
                    this.value_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)nestedValuesLocaleMap);
                }
            });
        }
        return customMetaTags.toArray(new CustomMetaTag[0]);
    }

    private static SitePageNavigationMenuSettings _toSitePageNavigationMenuSettings(UnicodeProperties unicodeProperties) {
        final String queryStringPropertyValue = unicodeProperties.getProperty("query-string");
        final String targetPropertyValue = unicodeProperties.getProperty("target");
        final String targetTypePropertyValue = unicodeProperties.getProperty("targetType");
        if (queryStringPropertyValue == null && targetPropertyValue == null && targetTypePropertyValue == null) {
            return null;
        }
        return new SitePageNavigationMenuSettings(){
            {
                this.queryString = queryStringPropertyValue;
                this.target = targetPropertyValue;
                this.setTargetType(() -> {
                    if (targetTypePropertyValue == null) {
                        return null;
                    }
                    if (Objects.equals(targetTypePropertyValue, "useNewTab")) {
                        return SitePageNavigationMenuSettings.TargetType.NEW_TAB;
                    }
                    return SitePageNavigationMenuSettings.TargetType.SPECIFIC_FRAME;
                });
            }
        };
    }
}

