/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.headless.delivery.dto.v1_0.RenderedPage;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseSitePageResourceImpl;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.segments.model.SegmentsExperience;
import java.util.ArrayList;
import javax.ws.rs.core.UriInfo;

public class RenderedPageUtil {
    public static RenderedPage getRenderedPage(final DTOConverterContext dtoConverterContext, final Layout layout, LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService, Portal portal) throws PortalException {
        final LayoutPageTemplateEntry layoutPageTemplateEntry = RenderedPageUtil._getLayoutPageTemplateEntry(layout, layoutPageTemplateEntryLocalService, portal);
        final LayoutPageTemplateEntry masterLayout = RenderedPageUtil._getMasterLayout(layout, layoutPageTemplateEntryLocalService);
        return new RenderedPage(){
            {
                this.renderedPageURL = RenderedPageUtil._getJaxRsLink(dtoConverterContext, layout);
                this.setMasterPageId(() -> {
                    if (masterLayout != null) {
                        return masterLayout.getLayoutPageTemplateEntryKey();
                    }
                    return null;
                });
                this.setMasterPageName(() -> {
                    if (masterLayout != null) {
                        return masterLayout.getName();
                    }
                    return null;
                });
                this.setPageTemplateId(() -> {
                    if (layoutPageTemplateEntry != null) {
                        return layoutPageTemplateEntry.getLayoutPageTemplateEntryKey();
                    }
                    return null;
                });
                this.setPageTemplateName(() -> {
                    if (layoutPageTemplateEntry != null) {
                        return layoutPageTemplateEntry.getName();
                    }
                    return null;
                });
            }
        };
    }

    private static String _getJaxRsLink(DTOConverterContext dtoConverterContext, Layout layout) throws PortalException {
        UriInfo uriInfo = dtoConverterContext.getUriInfo();
        if (uriInfo == null) {
            return null;
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(layout.getGroupId());
        String friendlyURL = layout.getFriendlyURL(dtoConverterContext.getLocale());
        arguments.add(friendlyURL.substring(1));
        boolean showSegmentsExperience = GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("showExperience"));
        if (!showSegmentsExperience) {
            return JaxRsLinkUtil.getJaxRsLink((String)"headless-delivery", BaseSitePageResourceImpl.class, (String)"getSiteSitePageRenderedPage", (UriInfo)uriInfo, (Object[])arguments.toArray(new Object[0]));
        }
        SegmentsExperience segmentsExperience = (SegmentsExperience)dtoConverterContext.getAttribute("segmentsExperience");
        arguments.add(segmentsExperience.getSegmentsExperienceKey());
        return JaxRsLinkUtil.getJaxRsLink((String)"headless-delivery", BaseSitePageResourceImpl.class, (String)"getSiteSitePageExperienceExperienceKeyRenderedPage", (UriInfo)uriInfo, (Object[])arguments.toArray(new Object[0]));
    }

    private static LayoutPageTemplateEntry _getLayoutPageTemplateEntry(Layout layout, LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService, Portal portal) {
        if (layout.getClassNameId() != portal.getClassNameId(LayoutPageTemplateEntry.class)) {
            return null;
        }
        return layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layout.getClassPK());
    }

    private static LayoutPageTemplateEntry _getMasterLayout(Layout layout, LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService) {
        Layout masterLayout = LayoutLocalServiceUtil.fetchLayout((long)layout.getMasterLayoutPlid());
        if (masterLayout == null) {
            return null;
        }
        return layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(masterLayout.getClassPK());
    }
}

