/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.headless.delivery.dto.v1_0.SEOSettings;
import com.liferay.headless.delivery.dto.v1_0.SiteMapSettings;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;

public class SEOSettingsUtil {
    private static final Log _log = LogFactoryUtil.getLog(SEOSettingsUtil.class);

    public static SEOSettings getSeoSettings(final DTOConverterContext dtoConverterContext, LayoutSEOEntryLocalService layoutSEOEntryLocalService, final Layout layout) {
        LayoutSEOEntry layoutSEOEntry = layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        SEOSettings seoSettings = new SEOSettings(){
            {
                this.description = layout.getDescription(dtoConverterContext.getLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getDescriptionMap());
                this.htmlTitle = layout.getTitle(dtoConverterContext.getLocale());
                this.htmlTitle_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getTitleMap());
                this.robots = layout.getRobots(dtoConverterContext.getLocale());
                this.robots_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getRobotsMap());
                this.seoKeywords = layout.getKeywords(dtoConverterContext.getLocale());
                this.seoKeywords_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getKeywordsMap());
                this.siteMapSettings = SEOSettingsUtil._toSiteMapSettings(layout.getTypeSettingsProperties());
            }
        };
        if (layoutSEOEntry != null && layoutSEOEntry.isCanonicalURLEnabled()) {
            seoSettings.setCustomCanonicalURL(layoutSEOEntry.getCanonicalURL(dtoConverterContext.getLocale()));
            seoSettings.setCustomCanonicalURL_i18n(LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layoutSEOEntry.getCanonicalURLMap()));
        }
        return seoSettings;
    }

    private static SiteMapSettings _toSiteMapSettings(UnicodeProperties unicodeProperties) {
        final String siteMapChangeFreq = unicodeProperties.getProperty("sitemap-changefreq");
        final String siteMapInclude = unicodeProperties.getProperty("sitemap-include");
        final String siteMapPriority = unicodeProperties.getProperty("sitemap-priority");
        if (siteMapChangeFreq == null && siteMapInclude == null && siteMapPriority == null) {
            return null;
        }
        return new SiteMapSettings(){
            {
                this.setChangeFrequency(() -> {
                    if (siteMapChangeFreq == null) {
                        return null;
                    }
                    return SiteMapSettings.ChangeFrequency.create((String)StringUtil.upperCaseFirstLetter((String)siteMapChangeFreq));
                });
                this.setInclude(() -> {
                    if (siteMapInclude == null) {
                        return null;
                    }
                    if (siteMapInclude.equals("0")) {
                        return false;
                    }
                    if (siteMapInclude.equals("1")) {
                        return true;
                    }
                    return null;
                });
                this.setPagePriority(() -> {
                    if (siteMapPriority == null) {
                        return null;
                    }
                    try {
                        return Double.parseDouble(siteMapPriority);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Throwable)numberFormatException);
                        }
                        return null;
                    }
                });
            }
        };
    }
}

