/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryReference;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.UriInfo;

public class TaxonomyCategoryBriefUtil {
    public static TaxonomyCategoryBrief toTaxonomyCategoryBrief(final AssetCategory assetCategory, final DTOConverterContext dtoConverterContext) throws Exception {
        return new TaxonomyCategoryBrief(){
            {
                this.embeddedTaxonomyCategory = TaxonomyCategoryBriefUtil._toTaxonomyCategory(assetCategory.getCategoryId(), dtoConverterContext);
                this.taxonomyCategoryId = assetCategory.getCategoryId();
                this.taxonomyCategoryName = assetCategory.getTitle(dtoConverterContext.getLocale());
                this.taxonomyCategoryName_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)assetCategory.getTitleMap());
                this.taxonomyCategoryReference = TaxonomyCategoryBriefUtil._toTaxonomyCategoryReference(assetCategory, dtoConverterContext);
            }
        };
    }

    private static Object _toTaxonomyCategory(long categoryId, DTOConverterContext dtoConverterContext) throws Exception {
        UriInfo uriInfo = dtoConverterContext.getUriInfo();
        if (!dtoConverterContext.containsNestedFieldsValue("embeddedTaxonomyCategory")) {
            return null;
        }
        DTOConverterRegistry dtoConverterRegistry = dtoConverterContext.getDTOConverterRegistry();
        DTOConverter dtoConverter = dtoConverterRegistry.getDTOConverter("Liferay.Headless.Admin.Taxonomy", AssetCategory.class.getName(), "v1.0");
        if (dtoConverter == null) {
            return null;
        }
        return dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), Collections.emptyMap(), dtoConverterRegistry, dtoConverterContext.getHttpServletRequest(), (Object)categoryId, dtoConverterContext.getLocale(), uriInfo, dtoConverterContext.getUser()));
    }

    private static TaxonomyCategoryReference _toTaxonomyCategoryReference(final AssetCategory assetCategory, final DTOConverterContext dtoConverterContext) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-178052")) {
            return null;
        }
        return new TaxonomyCategoryReference(){
            {
                this.externalReferenceCode = assetCategory.getExternalReferenceCode();
                this.setSiteKey(() -> {
                    if (Objects.equals(GetterUtil.getLong((Object)assetCategory.getGroupId()), dtoConverterContext.getAttribute("groupId"))) {
                        return null;
                    }
                    Group group = GroupLocalServiceUtil.fetchGroup((long)assetCategory.getGroupId());
                    return group.getGroupKey();
                });
            }
        };
    }
}

