/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.StructuredContentFolder;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentFolderResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseStructuredContentFolderResourceImpl
implements EntityModelResource,
StructuredContentFolderResource,
VulcanBatchEngineTaskItemDelegate<StructuredContentFolder> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<StructuredContentFolder>, UnsafeFunction<StructuredContentFolder, StructuredContentFolder, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<StructuredContentFolder>, UnsafeConsumer<StructuredContentFolder, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseStructuredContentFolderResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}/structured-content-folders")
    @Produces(value={"application/json", "application/xml"})
    public Page<StructuredContentFolder> getAssetLibraryStructuredContentFoldersPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort"), @Parameter(in=ParameterIn.QUERY, name="callbackURL"), @Parameter(in=ParameterIn.QUERY, name="contentType"), @Parameter(in=ParameterIn.QUERY, name="fieldNames")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json"})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-content-folders/export-batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAssetLibraryStructuredContentFoldersPageExportBatch(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Sort[] sorts, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, @Parameter(hidden=true) @DefaultValue(value="JSON") @QueryParam(value="contentType") String contentType, @Parameter(hidden=true) @QueryParam(value="fieldNames") String fieldNames) throws Exception {
        this.vulcanBatchEngineExportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineExportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineExportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineExportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineExportTaskResource.setContextUser(this.contextUser);
        this.vulcanBatchEngineExportTaskResource.setGroupLocalService(this.groupLocalService);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineExportTaskResource.postExportTask(StructuredContentFolder.class.getName(), callbackURL, contentType, fieldNames)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-content-folders")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public StructuredContentFolder postAssetLibraryStructuredContentFolder(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, StructuredContentFolder structuredContentFolder) throws Exception {
        return new StructuredContentFolder();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json"})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-content-folders/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAssetLibraryStructuredContentFolderBatch(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(StructuredContentFolder.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes the asset library's structured content folder by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryId}/structured-content-folders/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryStructuredContentFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Retrieves the asset library's structured content folder by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}/structured-content-folders/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public StructuredContentFolder getAssetLibraryStructuredContentFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new StructuredContentFolder();
    }

    @Operation(description="Updates the asset library's structured content folder with the given external reference code, or creates it if it not exists.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-content-folders/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public StructuredContentFolder putAssetLibraryStructuredContentFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, StructuredContentFolder structuredContentFolder) throws Exception {
        return new StructuredContentFolder();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}/structured-content-folders/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getAssetLibraryStructuredContentFolderPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(assetLibraryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)assetLibraryId, (Long)assetLibraryId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getAssetLibraryStructuredContentFolderPermissionsPage", portletName, assetLibraryId)).put((Object)"replace", this.addAction("PERMISSIONS", "putAssetLibraryStructuredContentFolderPermissionsPage", portletName, assetLibraryId)).build(), assetLibraryId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-content-folders/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putAssetLibraryStructuredContentFolderPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(assetLibraryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)assetLibraryId, (Long)assetLibraryId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), assetLibraryId.longValue(), portletName, String.valueOf(assetLibraryId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)assetLibraryId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getAssetLibraryStructuredContentFolderPermissionsPage", portletName, assetLibraryId)).put((Object)"replace", this.addAction("PERMISSIONS", "putAssetLibraryStructuredContentFolderPermissionsPage", portletName, assetLibraryId)).build(), assetLibraryId, portletName, null);
    }

    @Operation(description="Retrieves the site's structured content folders. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @GET
    @Path(value="/sites/{siteId}/structured-content-folders")
    @Produces(value={"application/json", "application/xml"})
    public Page<StructuredContentFolder> getSiteStructuredContentFoldersPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort"), @Parameter(in=ParameterIn.QUERY, name="callbackURL"), @Parameter(in=ParameterIn.QUERY, name="contentType"), @Parameter(in=ParameterIn.QUERY, name="fieldNames")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteId}/structured-content-folders/export-batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteStructuredContentFoldersPageExportBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Sort[] sorts, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, @Parameter(hidden=true) @DefaultValue(value="JSON") @QueryParam(value="contentType") String contentType, @Parameter(hidden=true) @QueryParam(value="fieldNames") String fieldNames) throws Exception {
        this.vulcanBatchEngineExportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineExportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineExportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineExportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineExportTaskResource.setContextUser(this.contextUser);
        this.vulcanBatchEngineExportTaskResource.setGroupLocalService(this.groupLocalService);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineExportTaskResource.postExportTask(StructuredContentFolder.class.getName(), callbackURL, contentType, fieldNames)).build();
    }

    @Operation(description="Creates a new structured content folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/structured-content-folders")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public StructuredContentFolder postSiteStructuredContentFolder(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, StructuredContentFolder structuredContentFolder) throws Exception {
        return new StructuredContentFolder();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteId}/structured-content-folders/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteStructuredContentFolderBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(StructuredContentFolder.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @DELETE
    @Path(value="/sites/{siteId}/structured-content-folders/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteSiteStructuredContentFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @GET
    @Path(value="/sites/{siteId}/structured-content-folders/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public StructuredContentFolder getSiteStructuredContentFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new StructuredContentFolder();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/structured-content-folders/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public StructuredContentFolder putSiteStructuredContentFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, StructuredContentFolder structuredContentFolder) throws Exception {
        return new StructuredContentFolder();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @GET
    @Path(value="/sites/{siteId}/structured-content-folders/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteStructuredContentFolderPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteStructuredContentFolderPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteStructuredContentFolderPermissionsPage", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Path(value="/sites/{siteId}/structured-content-folders/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteStructuredContentFolderPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteStructuredContentFolderPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteStructuredContentFolderPermissionsPage", portletName, siteId)).build(), siteId, portletName, null);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @GET
    @Path(value="/structured-content-folder/{structuredContentFolderId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getStructuredContentFolderPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(structuredContentFolderId);
        Long resourceId = this.getPermissionCheckerResourceId(structuredContentFolderId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(structuredContentFolderId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getStructuredContentFolderPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putStructuredContentFolderPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Path(value="/structured-content-folder/{structuredContentFolderId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putStructuredContentFolderPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(structuredContentFolderId);
        Long resourceId = this.getPermissionCheckerResourceId(structuredContentFolderId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(structuredContentFolderId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(structuredContentFolderId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getStructuredContentFolderPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putStructuredContentFolderPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @Operation(description="Retrieves the parent structured content folder's subfolders. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentStructuredContentFolderId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @GET
    @Path(value="/structured-content-folders/{parentStructuredContentFolderId}/structured-content-folders")
    @Produces(value={"application/json", "application/xml"})
    public Page<StructuredContentFolder> getStructuredContentFolderStructuredContentFoldersPage(@Parameter(hidden=true) @NotNull @PathParam(value="parentStructuredContentFolderId") Long parentStructuredContentFolderId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new structured content folder in an existing folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentStructuredContentFolderId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/structured-content-folders/{parentStructuredContentFolderId}/structured-content-folders")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public StructuredContentFolder postStructuredContentFolderStructuredContentFolder(@Parameter(hidden=true) @NotNull @PathParam(value="parentStructuredContentFolderId") Long parentStructuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        return new StructuredContentFolder();
    }

    @Operation(description="Deletes the structured content folder and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @DELETE
    @Path(value="/structured-content-folders/{structuredContentFolderId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteStructuredContentFolder(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/structured-content-folders/batch")
    @Produces(value={"application/json"})
    public Response deleteStructuredContentFolderBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(StructuredContentFolder.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the structured content folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @GET
    @Path(value="/structured-content-folders/{structuredContentFolderId}")
    @Produces(value={"application/json", "application/xml"})
    public StructuredContentFolder getStructuredContentFolder(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId) throws Exception {
        return new StructuredContentFolder();
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/structured-content-folders/{structuredContentFolderId}")
    @Produces(value={"application/json", "application/xml"})
    public StructuredContentFolder patchStructuredContentFolder(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        StructuredContentFolder existingStructuredContentFolder = this.getStructuredContentFolder(structuredContentFolderId);
        existingStructuredContentFolder.setCustomFields(structuredContentFolder.getCustomFields());
        if (structuredContentFolder.getDescription() != null) {
            existingStructuredContentFolder.setDescription(structuredContentFolder.getDescription());
        }
        if (structuredContentFolder.getExternalReferenceCode() != null) {
            existingStructuredContentFolder.setExternalReferenceCode(structuredContentFolder.getExternalReferenceCode());
        }
        if (structuredContentFolder.getName() != null) {
            existingStructuredContentFolder.setName(structuredContentFolder.getName());
        }
        if (structuredContentFolder.getParentStructuredContentFolderId() != null) {
            existingStructuredContentFolder.setParentStructuredContentFolderId(structuredContentFolder.getParentStructuredContentFolderId());
        }
        if (structuredContentFolder.getViewableBy() != null) {
            existingStructuredContentFolder.setViewableBy(structuredContentFolder.getViewableBy());
        }
        this.preparePatch(structuredContentFolder, existingStructuredContentFolder);
        return this.putStructuredContentFolder(structuredContentFolderId, existingStructuredContentFolder);
    }

    @Operation(description="Replaces the structured content folder with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/structured-content-folders/{structuredContentFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public StructuredContentFolder putStructuredContentFolder(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        return new StructuredContentFolder();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Consumes(value={"application/json"})
    @Path(value="/structured-content-folders/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putStructuredContentFolderBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(StructuredContentFolder.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putStructuredContentFolderSubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putStructuredContentFolderUnsubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="structuredContentFolderId") Long structuredContentFolderId) throws Exception {
    }

    public void create(Collection<StructuredContentFolder> structuredContentFolders, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction structuredContentFolderUnsafeFunction = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"INSERT")) {
            if (parameters.containsKey("assetLibraryId")) {
                structuredContentFolderUnsafeFunction = structuredContentFolder -> this.postAssetLibraryStructuredContentFolder((Long)parameters.get("assetLibraryId"), (StructuredContentFolder)structuredContentFolder);
            } else if (parameters.containsKey("siteId")) {
                structuredContentFolderUnsafeFunction = structuredContentFolder -> this.postSiteStructuredContentFolder((Long)parameters.get("siteId"), (StructuredContentFolder)structuredContentFolder);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [assetLibraryId, siteId]");
            }
        }
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"UPSERT")) {
            String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
            if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"UPDATE")) {
                structuredContentFolderUnsafeFunction = structuredContentFolder -> this.putSiteStructuredContentFolderByExternalReferenceCode(structuredContentFolder.getSiteId() != null ? structuredContentFolder.getSiteId() : (Long)parameters.get("siteId"), structuredContentFolder.getExternalReferenceCode(), (StructuredContentFolder)structuredContentFolder);
            }
            if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
                structuredContentFolderUnsafeFunction = structuredContentFolder -> {
                    StructuredContentFolder persistedStructuredContentFolder = null;
                    try {
                        StructuredContentFolder getStructuredContentFolder = this.getSiteStructuredContentFolderByExternalReferenceCode(structuredContentFolder.getSiteId() != null ? structuredContentFolder.getSiteId() : (Long)parameters.get("siteId"), structuredContentFolder.getExternalReferenceCode());
                        persistedStructuredContentFolder = this.patchStructuredContentFolder(getStructuredContentFolder.getId() != null ? getStructuredContentFolder.getId() : this._parseLong((String)parameters.get("structuredContentFolderId")), (StructuredContentFolder)structuredContentFolder);
                    }
                    catch (NoSuchModelException noSuchModelException) {
                        if (parameters.containsKey("assetLibraryId")) {
                            persistedStructuredContentFolder = this.postAssetLibraryStructuredContentFolder((Long)parameters.get("assetLibraryId"), (StructuredContentFolder)structuredContentFolder);
                        }
                        if (parameters.containsKey("siteId")) {
                            persistedStructuredContentFolder = this.postSiteStructuredContentFolder((Long)parameters.get("siteId"), (StructuredContentFolder)structuredContentFolder);
                        }
                        throw new NotSupportedException("One of the following parameters must be specified: [assetLibraryId, siteId, assetLibraryId]");
                    }
                    return persistedStructuredContentFolder;
                };
            }
        }
        if (structuredContentFolderUnsafeFunction == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for StructuredContentFolder");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(structuredContentFolders, (Object)structuredContentFolderUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(structuredContentFolders, arg_0 -> ((UnsafeFunction)structuredContentFolderUnsafeFunction).apply(arg_0));
        } else {
            for (StructuredContentFolder structuredContentFolder2 : structuredContentFolders) {
                structuredContentFolderUnsafeFunction.apply((Object)structuredContentFolder2);
            }
        }
    }

    public void delete(Collection<StructuredContentFolder> structuredContentFolders, Map<String, Serializable> parameters) throws Exception {
        for (StructuredContentFolder structuredContentFolder : structuredContentFolders) {
            this.deleteStructuredContentFolder(structuredContentFolder.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<StructuredContentFolder> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("assetLibraryId")) {
            return this.getAssetLibraryStructuredContentFoldersPage((Long)parameters.get("assetLibraryId"), this._parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        if (parameters.containsKey("siteId")) {
            return this.getSiteStructuredContentFoldersPage((Long)parameters.get("siteId"), this._parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [assetLibraryId, siteId]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<StructuredContentFolder> structuredContentFolders, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction structuredContentFolderUnsafeFunction = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
            structuredContentFolderUnsafeFunction = structuredContentFolder -> this.patchStructuredContentFolder(structuredContentFolder.getId() != null ? structuredContentFolder.getId() : this._parseLong((String)parameters.get("structuredContentFolderId")), (StructuredContentFolder)structuredContentFolder);
        }
        if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"UPDATE")) {
            structuredContentFolderUnsafeFunction = structuredContentFolder -> this.putStructuredContentFolder(structuredContentFolder.getId() != null ? structuredContentFolder.getId() : this._parseLong((String)parameters.get("structuredContentFolderId")), (StructuredContentFolder)structuredContentFolder);
        }
        if (structuredContentFolderUnsafeFunction == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for StructuredContentFolder");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(structuredContentFolders, (Object)structuredContentFolderUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(structuredContentFolders, arg_0 -> ((UnsafeFunction)structuredContentFolderUnsafeFunction).apply(arg_0));
        } else {
            for (StructuredContentFolder structuredContentFolder2 : structuredContentFolders) {
                structuredContentFolderUnsafeFunction.apply((Object)structuredContentFolder2);
            }
        }
    }

    private Boolean _parseBoolean(String value) {
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    private Long _parseLong(String value) {
        if (value != null) {
            return Long.parseLong(value);
        }
        return null;
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, StringUtil.split((String)roleNames)));
        }
        return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, null));
    }

    private Collection<Permission> _getPermissions(long companyId, List<ResourceAction> resourceActions, long resourceId, String resourceName, String[] roleNames) throws Exception {
        HashMap<String, 2> permissions = new HashMap<String, 2>();
        int count = this.resourcePermissionLocalService.getResourcePermissionsCount(companyId, resourceName, 4, String.valueOf(resourceId));
        if (count == 0) {
            ResourceLocalServiceUtil.addResources((long)companyId, (long)resourceId, (long)0L, (String)resourceName, (String)String.valueOf(resourceId), (boolean)false, (boolean)true, (boolean)true);
        }
        List actionIds = this.transform(resourceActions, resourceAction -> resourceAction.getActionId());
        HashSet resourcePermissions = new HashSet();
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 1, String.valueOf(companyId)));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 2, String.valueOf(GroupThreadLocal.getGroupId())));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 3, "0"));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId)));
        List resources = this.transform(resourcePermissions, resourcePermission -> ResourceLocalServiceUtil.getResource((long)resourcePermission.getCompanyId(), (String)resourcePermission.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey()));
        HashSet<Role> roles = new HashSet<Role>();
        if (roleNames != null) {
            for (String string : roleNames) {
                roles.add(this.roleLocalService.getRole(companyId, string));
            }
        } else {
            for (ResourcePermission resourcePermission2 : resourcePermissions) {
                Role role = this.roleLocalService.getRole(resourcePermission2.getRoleId());
                roles.add(role);
            }
        }
        for (final Role role : roles) {
            final HashSet actionsIdsSet = new HashSet();
            for (Resource resource : resources) {
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 1, String.valueOf(resource.getCompanyId()), role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 2, String.valueOf(GroupThreadLocal.getGroupId()), role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 3, "0", role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds));
            }
            if (actionsIdsSet.isEmpty()) continue;
            Permission permission = new Permission(){
                {
                    this.actionIds = actionsIdsSet.toArray(new String[0]);
                    this.roleName = role.getName();
                }
            };
            permissions.put(role.getName(), permission);
        }
        return permissions.values();
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<StructuredContentFolder>, UnsafeFunction<StructuredContentFolder, StructuredContentFolder, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<StructuredContentFolder>, UnsafeConsumer<StructuredContentFolder, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineExportTaskResource(VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource) {
        this.vulcanBatchEngineExportTaskResource = vulcanBatchEngineExportTaskResource;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(StructuredContentFolder structuredContentFolder, StructuredContentFolder existingStructuredContentFolder) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToLongArray(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
    }
}

