/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.search.AssetSearcherFactory;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.util.AssetHelper;
import com.liferay.headless.delivery.dto.v1_0.ContentElement;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.ContentElementEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseContentElementResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.ContentElementResource;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.aggregation.FacetUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/content-element.properties"}, scope=ServiceScope.PROTOTYPE, service={ContentElementResource.class})
public class ContentElementResourceImpl
extends BaseContentElementResourceImpl {
    @Reference
    private AssetHelper _assetHelper;
    @Reference
    private AssetSearcherFactory _assetSearcherFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    @Override
    public Page<ContentElement> getAssetLibraryContentElementsPage(Long assetLibraryId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getSiteContentElementsPage(assetLibraryId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return new ContentElementEntityModel(this._dtoConverterRegistry);
    }

    @Override
    public Page<ContentElement> getSiteContentElementsPage(Long siteId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        SearchContext searchContext = this._getAssetSearchContext(siteId, search, aggregation, filter, pagination, sorts);
        Map facets = searchContext.getFacets();
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setGroupIds(new long[]{siteId});
        BaseSearcher baseSearcher = this._assetSearcherFactory.createBaseSearcher(assetEntryQuery);
        return Page.of(new HashMap(), this.transform(facets.values(), FacetUtil::toFacet), this.transform(this._assetHelper.getAssetEntries(baseSearcher.search(searchContext)), this::_toContentElement), (Pagination)pagination, (long)this._assetHelper.searchCount(searchContext, assetEntryQuery));
    }

    private SearchContext _getAssetSearchContext(Long groupId, String search, Aggregation aggregation, final Filter filter, Pagination pagination, Sort[] sorts) {
        SearchUtil.SearchContext searchContext = new SearchUtil.SearchContext();
        searchContext.addVulcanAggregation(aggregation);
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl(){
            {
                BooleanFilter booleanFilter = new BooleanFilter();
                if (filter != null) {
                    booleanFilter.add(filter, BooleanClauseOccur.MUST);
                }
                booleanFilter.addRequiredTerm("status", 0);
                booleanFilter.add((Filter)new BooleanFilter(){
                    {
                        this.add((Filter)new BooleanFilter(){
                            {
                                this.addRequiredTerm("entryClassName", JournalArticle.class.getName());
                                this.addRequiredTerm("head", true);
                            }
                        }, BooleanClauseOccur.SHOULD);
                        this.add((Filter)new BooleanFilter(){
                            {
                                this.addTerm("entryClassName", JournalArticle.class.getName(), BooleanClauseOccur.MUST_NOT);
                            }
                        }, BooleanClauseOccur.SHOULD);
                    }
                }, BooleanClauseOccur.MUST);
                this.setPreBooleanFilter(booleanFilter);
            }
        };
        searchContext.setBooleanClauses(new BooleanClause[]{BooleanClauseFactoryUtil.create((Query)booleanQuery, (String)BooleanClauseOccur.MUST.getName())});
        searchContext.setCompanyId(this.contextCompany.getCompanyId());
        if (pagination != null) {
            searchContext.setEnd(pagination.getEndPosition());
        }
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setKeywords(search);
        searchContext.setLocale(this.contextAcceptLanguage.getPreferredLocale());
        if (sorts == null) {
            sorts = new Sort[]{new Sort("entryClassPK", 6, false)};
        }
        searchContext.setSorts(sorts);
        if (pagination != null) {
            searchContext.setStart(pagination.getStartPosition());
        }
        searchContext.setUserId(this.contextUser.getUserId());
        return searchContext;
    }

    private ContentElement _toContentElement(final AssetEntry assetEntry) {
        final DTOConverter dtoConverter = this._dtoConverterRegistry.getDTOConverter(assetEntry.getClassName());
        return new ContentElement(){
            {
                this.id = assetEntry.getClassPK();
                this.title = assetEntry.getTitle(ContentElementResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.title_i18n = LocalizedMapUtil.getI18nMap((boolean)ContentElementResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)assetEntry.getTitleMap());
                this.setContent(() -> {
                    if (dtoConverter == null) {
                        return null;
                    }
                    return dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(ContentElementResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), new HashMap(), ContentElementResourceImpl.this._dtoConverterRegistry, ContentElementResourceImpl.this.contextHttpServletRequest, (Object)assetEntry.getClassPK(), ContentElementResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), ContentElementResourceImpl.this.contextUriInfo, ContentElementResourceImpl.this.contextUser));
                });
                this.setContentType(() -> {
                    if (dtoConverter == null) {
                        return assetEntry.getClassName();
                    }
                    return dtoConverter.getContentType();
                });
            }
        };
    }
}

