/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.list.asset.entry.provider.AssetListAssetEntryProvider;
import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryService;
import com.liferay.headless.delivery.dto.v1_0.ContentSetElement;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseContentSetElementResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.ContentSetElementResource;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.segments.context.Context;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/content-set-element.properties"}, scope=ServiceScope.PROTOTYPE, service={ContentSetElementResource.class})
public class ContentSetElementResourceImpl
extends BaseContentSetElementResourceImpl {
    @Reference
    private AssetListAssetEntryProvider _assetListAssetEntryProvider;
    @Reference
    private AssetListEntryService _assetListEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;

    @Override
    public Page<ContentSetElement> getAssetLibraryContentSetByKeyContentSetElementsPage(Long assetLibraryId, String key, Pagination pagination) throws Exception {
        return this.getSiteContentSetByKeyContentSetElementsPage(assetLibraryId, key, pagination);
    }

    @Override
    public Page<ContentSetElement> getAssetLibraryContentSetByUuidContentSetElementsPage(Long assetLibraryId, String uuid, Pagination pagination) throws Exception {
        return this.getSiteContentSetByUuidContentSetElementsPage(assetLibraryId, uuid, pagination);
    }

    @Override
    public Page<ContentSetElement> getContentSetContentSetElementsPage(Long contentSetId, Pagination pagination) throws Exception {
        return this._getContentSetContentSetElementsPage(this._assetListEntryService.getAssetListEntry(contentSetId.longValue()), pagination);
    }

    @Override
    public Page<ContentSetElement> getSiteContentSetByKeyContentSetElementsPage(Long siteId, String key, Pagination pagination) throws Exception {
        return this._getContentSetContentSetElementsPage(this._assetListEntryService.getAssetListEntry(siteId.longValue(), key), pagination);
    }

    @Override
    public Page<ContentSetElement> getSiteContentSetByUuidContentSetElementsPage(Long siteId, String uuid, Pagination pagination) throws Exception {
        AssetListEntry assetListEntry = this._assetListEntryService.getAssetListEntryByUuidAndGroupId(uuid, siteId.longValue());
        return this._getContentSetContentSetElementsPage(assetListEntry, pagination);
    }

    private Context _createSegmentsContext() {
        Context context = new Context();
        Enumeration enumeration = this.contextHttpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = this.contextHttpServletRequest.getHeader(key);
            if (key.equals("accept-language")) {
                context.put("languageId", (Serializable)((Object)StringUtil.replace((String)value, (char)'-', (char)'_')));
                continue;
            }
            if (key.equals("host")) {
                context.put("url", (Serializable)((Object)value));
                continue;
            }
            if (key.equals("referer")) {
                context.put("referrerURL", (Serializable)((Object)value));
                continue;
            }
            if (key.equals("user-agent")) {
                context.put("userAgent", (Serializable)((Object)value));
                continue;
            }
            if (key.startsWith("x-")) {
                context.put(CamelCaseUtil.toCamelCase((String)StringUtil.removeSubstring((String)key, (String)"x-")), (Serializable)((Object)value));
                continue;
            }
            context.put(key, (Serializable)((Object)value));
        }
        context.put("localDate", (Serializable)LocalDate.from(ZonedDateTime.now()));
        return context;
    }

    private Page<ContentSetElement> _getContentSetContentSetElementsPage(AssetListEntry assetListEntry, Pagination pagination) throws Exception {
        long[] segmentsEntryIds = this._segmentsEntryProviderRegistry.getSegmentsEntryIds(assetListEntry.getGroupId(), this.contextUser.getModelClassName(), this.contextUser.getPrimaryKey(), this._createSegmentsContext());
        return Page.of(this.transform(this._assetListAssetEntryProvider.getAssetEntries(assetListEntry, segmentsEntryIds, (long[][])null, (String[][])null, "", "", pagination.getStartPosition(), pagination.getEndPosition()), this::_toContentSetElement), (Pagination)pagination, (long)this._assetListAssetEntryProvider.getAssetEntriesCount(assetListEntry, segmentsEntryIds, (long[][])null, (String[][])null, "", ""));
    }

    private ContentSetElement _toContentSetElement(final AssetEntry assetEntry) {
        final DTOConverter dtoConverter = this._dtoConverterRegistry.getDTOConverter(assetEntry.getClassName());
        return new ContentSetElement(){
            {
                this.id = assetEntry.getClassPK();
                this.title = assetEntry.getTitle(ContentSetElementResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.title_i18n = LocalizedMapUtil.getI18nMap((boolean)ContentSetElementResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)assetEntry.getTitleMap());
                this.setContent(() -> {
                    if (dtoConverter == null) {
                        return null;
                    }
                    return dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(ContentSetElementResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), new HashMap(), ContentSetElementResourceImpl.this._dtoConverterRegistry, ContentSetElementResourceImpl.this.contextHttpServletRequest, (Object)assetEntry.getClassPK(), ContentSetElementResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), ContentSetElementResourceImpl.this.contextUriInfo, ContentSetElementResourceImpl.this.contextUser));
                });
                this.setContentType(() -> {
                    if (dtoConverter == null) {
                        return assetEntry.getClassName();
                    }
                    return dtoConverter.getContentType();
                });
            }
        };
    }
}

