/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFolderService;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.DocumentFolder;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.DocumentFolderEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseDocumentFolderResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.DocumentFolderResource;
import com.liferay.headless.delivery.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.search.filter.FilterUtil;
import com.liferay.headless.delivery.search.sort.SortUtil;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/document-folder.properties"}, scope=ServiceScope.PROTOTYPE, service={DocumentFolderResource.class})
public class DocumentFolderResourceImpl
extends BaseDocumentFolderResourceImpl {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(indexer.class.name=com.liferay.document.library.kernel.model.DLFolder)")
    private Indexer<?> _dlFolderIndexer;
    @Reference
    private DLFolderService _dlFolderService;
    @Reference(target="(component.name=com.liferay.headless.delivery.internal.dto.v1_0.converter.DocumentFolderDTOConverter)")
    private DTOConverter<DLFolder, DocumentFolder> _documentFolderDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteDocumentFolder(Long documentFolderId) throws Exception {
        this._dlAppService.deleteFolder(documentFolderId.longValue());
    }

    @Override
    public void deleteDocumentFolderMyRating(Long documentFolderId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(documentFolderId);
    }

    @Override
    public void deleteSiteDocumentsFolderByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        Folder folder = this._dlAppService.getFolderByExternalReferenceCode(externalReferenceCode, siteId.longValue());
        this._dlAppService.deleteFolder(folder.getFolderId());
    }

    @Override
    public Page<DocumentFolder> getAssetLibraryDocumentFoldersPage(Long assetLibraryId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Long documentFolderId = null;
        if (!GetterUtil.getBoolean((Object)flatten)) {
            documentFolderId = 0L;
        }
        return this._getDocumentFoldersPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_FOLDER", "postAssetLibraryDocumentFolder", "com.liferay.document.library", assetLibraryId)).put((Object)"createBatch", this.addAction("ADD_FOLDER", "postAssetLibraryDocumentFolderBatch", "com.liferay.document.library", assetLibraryId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteDocumentFolderBatch", "com.liferay.document.library", null)).put((Object)"get", this.addAction("VIEW", "getAssetLibraryDocumentFoldersPage", "com.liferay.document.library", assetLibraryId)).put((Object)"updateBatch", this.addAction("UPDATE", "putDocumentFolderBatch", "com.liferay.document.library", null)).build(), documentFolderId, assetLibraryId, flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Page<DocumentFolder> getAssetLibraryDocumentFoldersRatedByMePage(Long assetLibraryId, Pagination pagination) throws Exception {
        return this._getGroupDocumentFoldersRatedByMePage(assetLibraryId, pagination);
    }

    @Override
    public DocumentFolder getDocumentFolder(Long documentFolderId) throws Exception {
        return this._toDocumentFolder(this._dlAppService.getFolder(documentFolderId.longValue()));
    }

    @Override
    public Page<DocumentFolder> getDocumentFolderDocumentFoldersPage(Long parentDocumentFolderId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Folder folder = this._dlAppService.getFolder(parentDocumentFolderId.longValue());
        return this._getDocumentFoldersPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_SUBFOLDER", folder.getFolderId(), "postDocumentFolderDocumentFolder", folder.getUserId(), "com.liferay.document.library", folder.getGroupId())).put((Object)"get", this.addAction("VIEW", folder.getFolderId(), "getDocumentFolderDocumentFoldersPage", folder.getUserId(), "com.liferay.document.library", folder.getGroupId())).build(), folder.getFolderId(), folder.getGroupId(), flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Rating getDocumentFolderMyRating(Long documentFolderId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(documentFolderId);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new DocumentFolderEntityModel(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(DLFolder.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public Page<DocumentFolder> getSiteDocumentFoldersPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Long documentFolderId = null;
        if (!GetterUtil.getBoolean((Object)flatten)) {
            documentFolderId = 0L;
        }
        return this._getDocumentFoldersPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_FOLDER", "postSiteDocumentFolder", "com.liferay.document.library", siteId)).put((Object)"createBatch", this.addAction("ADD_FOLDER", "postSiteDocumentFolderBatch", "com.liferay.document.library", siteId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteDocumentFolderBatch", "com.liferay.document.library", null)).put((Object)"get", this.addAction("VIEW", "getSiteDocumentFoldersPage", "com.liferay.document.library", siteId)).put((Object)"updateBatch", this.addAction("UPDATE", "putDocumentFolderBatch", "com.liferay.document.library", null)).build(), documentFolderId, siteId, flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Page<DocumentFolder> getSiteDocumentFoldersRatedByMePage(Long siteId, Pagination pagination) throws Exception {
        return this._getGroupDocumentFoldersRatedByMePage(siteId, pagination);
    }

    @Override
    public DocumentFolder getSiteDocumentsFolderByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        Folder folder = this._dlAppService.getFolderByExternalReferenceCode(externalReferenceCode, siteId.longValue());
        return this._toDocumentFolder(folder);
    }

    @Override
    public DocumentFolder postAssetLibraryDocumentFolder(Long assetLibraryId, DocumentFolder documentFolder) throws Exception {
        return this.postSiteDocumentFolder(assetLibraryId, documentFolder);
    }

    @Override
    public DocumentFolder postDocumentFolderDocumentFolder(Long parentDocumentFolderId, DocumentFolder documentFolder) throws Exception {
        Folder folder = this._dlAppService.getFolder(parentDocumentFolderId.longValue());
        return this._addDocumentFolder(documentFolder.getExternalReferenceCode(), folder.getGroupId(), folder.getFolderId(), documentFolder);
    }

    @Override
    public Rating postDocumentFolderMyRating(Long documentFolderId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), documentFolderId.longValue());
    }

    @Override
    public DocumentFolder postSiteDocumentFolder(Long siteId, DocumentFolder documentFolder) throws Exception {
        return this._addDocumentFolder(documentFolder.getExternalReferenceCode(), siteId, 0L, documentFolder);
    }

    @Override
    public DocumentFolder putDocumentFolder(Long documentFolderId, DocumentFolder documentFolder) throws Exception {
        return this._updateDocumentFolder(this._dlAppService.getFolder(documentFolderId.longValue()), documentFolder);
    }

    @Override
    public Rating putDocumentFolderMyRating(Long documentFolderId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), documentFolderId.longValue());
    }

    @Override
    public void putDocumentFolderSubscribe(Long documentFolderId) throws Exception {
        Folder folder = this._dlAppService.getFolder(documentFolderId.longValue());
        this._dlAppService.subscribeFolder(folder.getGroupId(), folder.getFolderId());
    }

    @Override
    public void putDocumentFolderUnsubscribe(Long documentFolderId) throws Exception {
        Folder folder = this._dlAppService.getFolder(documentFolderId.longValue());
        this._dlAppService.unsubscribeFolder(folder.getGroupId(), folder.getFolderId());
    }

    @Override
    public DocumentFolder putSiteDocumentsFolderByExternalReferenceCode(Long siteId, String externalReferenceCode, DocumentFolder documentFolder) throws Exception {
        Folder folder = this._dlAppLocalService.fetchFolderByExternalReferenceCode(externalReferenceCode, siteId.longValue());
        if (folder != null) {
            return this._updateDocumentFolder(folder, documentFolder);
        }
        return this._addDocumentFolder(externalReferenceCode, siteId, 0L, documentFolder);
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        Folder folder = this._dlAppService.getFolder(((Long)id).longValue());
        return folder.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.document.library";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return DLFolder.class.getName();
    }

    private DocumentFolder _addDocumentFolder(String externalReferenceCode, Long groupId, Long parentFolderId, DocumentFolder documentFolder) throws Exception {
        return this._toDocumentFolder(this._dlAppService.addFolder(externalReferenceCode, groupId.longValue(), parentFolderId.longValue(), documentFolder.getName(), documentFolder.getDescription(), this._createServiceContext(groupId, documentFolder, documentFolder.getViewableByAsString())));
    }

    private ServiceContext _createServiceContext(long groupId, DocumentFolder documentFolder, String viewableBy) {
        return ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)viewableBy).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)DLFolder.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])documentFolder.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale())).build();
    }

    private Page<DocumentFolder> _getDocumentFoldersPage(Map<String, Map<String, String>> actions, Long parentDocumentFolderId, Long groupId, Boolean flatten, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQuery -> {
            if (parentDocumentFolderId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                String field = "folderId";
                if (GetterUtil.getBoolean((Object)flatten)) {
                    booleanFilter.add((Filter)new TermFilter(field, String.valueOf(parentDocumentFolderId)), BooleanClauseOccur.MUST_NOT);
                    field = "treePath";
                }
                booleanFilter.add((Filter)new TermFilter(field, String.valueOf(parentDocumentFolderId)), BooleanClauseOccur.MUST);
            }
        }, (Filter)FilterUtil.processFilter((DDMIndexer)this._ddmIndexer, (Filter)filter), this._dlFolderIndexer, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{groupId});
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation((Aggregations)this._aggregations, (DDMIndexer)this._ddmIndexer, (Queries)this._queries, (SearchRequestBuilder)searchRequestBuilder, (Aggregation)aggregation);
            SortUtil.processSorts((DDMIndexer)this._ddmIndexer, (SearchRequestBuilder)searchRequestBuilder, (Sort[])searchContext.getSorts(), (Queries)this._queries, (Sorts)this._sorts);
        }, (Sort[])sorts, document -> this._toDocumentFolder(this._dlAppService.getFolder(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private Page<DocumentFolder> _getGroupDocumentFoldersRatedByMePage(long groupId, Pagination pagination) throws Exception {
        return Page.of(this._toDocumentFolders(this._dlFolderService.getFolders(groupId, 0.1, pagination.getStartPosition(), pagination.getEndPosition())), (Pagination)pagination, (long)this._dlFolderService.getFoldersCount(groupId, 0.1));
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(DLFolder.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> {
            Folder folder = this._dlAppService.getFolder(ratingsEntry.getClassPK());
            return RatingUtil.toRating(HashMapBuilder.put((Object)"create", this.addAction("VIEW", folder.getPrimaryKey(), "postDocumentFolderMyRating", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).put((Object)"delete", this.addAction("VIEW", folder.getPrimaryKey(), "deleteDocumentFolderMyRating", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).put((Object)"get", this.addAction("VIEW", folder.getPrimaryKey(), "getDocumentFolderMyRating", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).put((Object)"replace", this.addAction("VIEW", folder.getPrimaryKey(), "putDocumentFolderMyRating", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).build(), this._portal, ratingsEntry, this._userLocalService);
        }, this.contextUser);
    }

    private DocumentFolder _toDocumentFolder(Folder folder) throws Exception {
        return (DocumentFolder)this._documentFolderDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", folder.getFolderId(), "deleteDocumentFolder", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).put((Object)"get", this.addAction("ACCESS", folder.getFolderId(), "getDocumentFolder", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).put((Object)"replace", this.addAction("UPDATE", folder.getFolderId(), "putDocumentFolder", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).put((Object)"subscribe", this.addAction("SUBSCRIBE", folder.getFolderId(), "putDocumentFolderSubscribe", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", folder.getFolderId(), "putDocumentFolderUnsubscribe", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).put((Object)"update", this.addAction("UPDATE", folder.getFolderId(), "patchDocumentFolder", folder.getUserId(), DLFolder.class.getName(), folder.getGroupId())).build(), this._dtoConverterRegistry, (Object)folder.getFolderId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<DocumentFolder> _toDocumentFolders(List<DLFolder> dlFolders) throws Exception {
        ArrayList<DocumentFolder> documentFolders = new ArrayList<DocumentFolder>();
        for (DLFolder dlFolder : dlFolders) {
            documentFolders.add(this._toDocumentFolder((Folder)new LiferayFolder(dlFolder)));
        }
        return documentFolders;
    }

    private DocumentFolder _updateDocumentFolder(Folder folder, DocumentFolder documentFolder) throws Exception {
        return this._toDocumentFolder(this._dlAppService.updateFolder(folder.getFolderId(), documentFolder.getName(), documentFolder.getDescription(), this._createServiceContext(0L, documentFolder, null)));
    }
}

