/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.util.DLFileEntryTypeUtil;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslator;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.Document;
import com.liferay.headless.delivery.dto.v1_0.DocumentType;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.dto.v1_0.util.DDMFormValuesUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.DisplayPageRendererUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.DocumentEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseDocumentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.DocumentResource;
import com.liferay.headless.delivery.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.search.filter.FilterUtil;
import com.liferay.headless.delivery.search.sort.SortUtil;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/document.properties"}, scope=ServiceScope.PROTOTYPE, service={DocumentResource.class})
public class DocumentResourceImpl
extends BaseDocumentResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(DocumentResourceImpl.class);
    @Reference
    private Aggregations _aggregations;
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DDMBeanTranslator _ddmBeanTranslator;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileEntryService _dlFileEntryService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference(target="(component.name=com.liferay.headless.delivery.internal.dto.v1_0.converter.DocumentDTOConverter)")
    private DTOConverter<DLFileEntry, Document> _documentDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference(target="(indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry)")
    private Indexer<?> _indexer;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private LayoutDisplayPageProviderRegistry _layoutDisplayPageProviderRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteAssetLibraryDocumentByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode) throws Exception {
        FileEntry fileEntry = this._dlAppService.getFileEntryByExternalReferenceCode(assetLibraryId.longValue(), externalReferenceCode);
        this._dlAppService.deleteFileEntry(fileEntry.getFileEntryId());
    }

    @Override
    public void deleteDocument(Long documentId) throws Exception {
        this._dlAppService.deleteFileEntry(documentId.longValue());
    }

    @Override
    public void deleteDocumentMyRating(Long documentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(documentId);
    }

    @Override
    public void deleteSiteDocumentByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        FileEntry fileEntry = this._dlAppService.getFileEntryByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        this._dlAppService.deleteFileEntry(fileEntry.getFileEntryId());
    }

    @Override
    public Document getAssetLibraryDocumentByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode) throws Exception {
        return this._toDocument(this._dlAppService.getFileEntryByExternalReferenceCode(assetLibraryId.longValue(), externalReferenceCode));
    }

    @Override
    public Page<Document> getAssetLibraryDocumentsPage(Long assetLibraryId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getDocumentsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_DOCUMENT", "postAssetLibraryDocument", "com.liferay.document.library", assetLibraryId)).put((Object)"createBatch", this.addAction("ADD_DOCUMENT", "postAssetLibraryDocumentBatch", "com.liferay.document.library", assetLibraryId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteDocumentBatch", "com.liferay.document.library", null)).put((Object)"get", this.addAction("VIEW", "getAssetLibraryDocumentsPage", "com.liferay.document.library", assetLibraryId)).put((Object)"updateBatch", this.addAction("UPDATE", "putDocumentBatch", "com.liferay.document.library", null)).build(), this._createDocumentsPageBooleanQueryUnsafeConsumer(assetLibraryId, flatten), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Page<Document> getAssetLibraryDocumentsRatedByMePage(Long assetLibraryId, Pagination pagination) throws Exception {
        return this._getGroupDocumentsRatedByMePage(assetLibraryId, pagination);
    }

    @Override
    public Document getDocument(Long documentId) throws Exception {
        return this._toDocument(this._dlAppService.getFileEntry(documentId.longValue()));
    }

    @Override
    public Page<Document> getDocumentFolderDocumentsPage(Long documentFolderId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Folder folder = this._dlAppService.getFolder(documentFolderId.longValue());
        return this._getDocumentsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_DOCUMENT", folder.getFolderId(), "postDocumentFolderDocument", folder.getUserId(), "com.liferay.document.library", folder.getGroupId())).put((Object)"createBatch", this.addAction("ADD_DOCUMENT", folder.getFolderId(), "postDocumentFolderDocumentBatch", folder.getUserId(), "com.liferay.document.library", folder.getGroupId())).put((Object)"get", this.addAction("VIEW", folder.getFolderId(), "getDocumentFolderDocumentsPage", folder.getUserId(), "com.liferay.document.library", folder.getGroupId())).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            String field = "folderId";
            if (GetterUtil.getBoolean((Object)flatten)) {
                field = "treePath";
            }
            booleanFilter.add((Filter)new TermFilter(field, String.valueOf(documentFolderId)), BooleanClauseOccur.MUST);
        }), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Rating getDocumentMyRating(Long documentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(documentId);
    }

    @Override
    public String getDocumentRenderedContentByDisplayPageDisplayPageKey(Long documentId, String displayPageKey) throws Exception {
        FileEntry fileEntry = this._dlAppService.getFileEntry(documentId.longValue());
        return DisplayPageRendererUtil.toHTML(FileEntry.class.getName(), this._getDDMStructureId(fileEntry), displayPageKey, fileEntry.getGroupId(), this.contextHttpServletRequest, this.contextHttpServletResponse, fileEntry, this._infoItemServiceRegistry, this._layoutDisplayPageProviderRegistry, this._layoutLocalService, this._layoutPageTemplateEntryService);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new DocumentEntityModel(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(DLFileEntry.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public Document getSiteDocumentByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        return this._toDocument(this._dlAppService.getFileEntryByExternalReferenceCode(siteId.longValue(), externalReferenceCode));
    }

    @Override
    public Page<Document> getSiteDocumentsPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getDocumentsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_DOCUMENT", "postSiteDocument", "com.liferay.document.library", siteId)).put((Object)"createBatch", this.addAction("ADD_DOCUMENT", "postSiteDocumentBatch", "com.liferay.document.library", siteId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteDocumentBatch", "com.liferay.document.library", null)).put((Object)"get", this.addAction("VIEW", "getSiteDocumentsPage", "com.liferay.document.library", siteId)).put((Object)"updateBatch", this.addAction("UPDATE", "putDocumentBatch", "com.liferay.document.library", null)).build(), this._createDocumentsPageBooleanQueryUnsafeConsumer(siteId, flatten), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Page<Document> getSiteDocumentsRatedByMePage(Long siteId, Pagination pagination) throws Exception {
        return this._getGroupDocumentsRatedByMePage(siteId, pagination);
    }

    @Override
    public Document patchDocument(Long documentId, MultipartBody multipartBody) throws Exception {
        FileEntry existingFileEntry = this._dlAppService.getFileEntry(documentId.longValue());
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            binaryFile = new BinaryFile(existingFileEntry.getMimeType(), existingFileEntry.getFileName(), existingFileEntry.getContentStream(), existingFileEntry.getSize());
        }
        Document document = (Document)multipartBody.getValueAsNullableInstance("document", Document.class);
        existingFileEntry = this._moveDocument(documentId, document, existingFileEntry);
        String fileName = null;
        String title = null;
        String description = null;
        if (document != null) {
            fileName = document.getFileName();
            title = document.getTitle();
            description = document.getDescription();
        }
        if (fileName == null) {
            fileName = binaryFile.getFileName();
        }
        if (title == null) {
            title = existingFileEntry.getTitle();
        }
        if (description == null) {
            existingFileEntry.getDescription();
        }
        return this._toDocument(this._dlAppService.updateFileEntry(documentId.longValue(), fileName, binaryFile.getContentType(), title, null, description, null, DLVersionNumberIncrease.AUTOMATIC, binaryFile.getInputStream(), binaryFile.getSize(), existingFileEntry.getExpirationDate(), existingFileEntry.getReviewDate(), this._createServiceContext("update", () -> ArrayUtil.toArray((long[])this._assetCategoryLocalService.getCategoryIds(DLFileEntry.class.getName(), documentId.longValue())), () -> this._assetTagLocalService.getTagNames(DLFileEntry.class.getName(), documentId.longValue()), existingFileEntry.getFolderId(), document, existingFileEntry.getGroupId())));
    }

    @Override
    public Document postAssetLibraryDocument(Long assetLibraryId, MultipartBody multipartBody) throws Exception {
        return this.postSiteDocument(assetLibraryId, multipartBody);
    }

    @Override
    public Document postDocumentFolderDocument(Long documentFolderId, MultipartBody multipartBody) throws Exception {
        Folder folder = this._dlAppService.getFolder(documentFolderId.longValue());
        return this._addDocument(null, folder.getGroupId(), folder.getRepositoryId(), documentFolderId, multipartBody);
    }

    @Override
    public Rating postDocumentMyRating(Long documentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), documentId.longValue());
    }

    @Override
    public Document postSiteDocument(Long siteId, MultipartBody multipartBody) throws Exception {
        return this._addDocument(null, siteId, siteId, null, multipartBody);
    }

    @Override
    public Document putAssetLibraryDocumentByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        FileEntry fileEntry = this._dlAppLocalService.fetchFileEntryByExternalReferenceCode(assetLibraryId.longValue(), externalReferenceCode);
        if (fileEntry != null) {
            return this._updateDocument(fileEntry, multipartBody);
        }
        return this._addDocument(externalReferenceCode, assetLibraryId, assetLibraryId, null, multipartBody);
    }

    @Override
    public Document putDocument(Long documentId, MultipartBody multipartBody) throws Exception {
        return this._updateDocument(this._dlAppService.getFileEntry(documentId.longValue()), multipartBody);
    }

    @Override
    public Rating putDocumentMyRating(Long documentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), documentId.longValue());
    }

    @Override
    public Document putSiteDocumentByExternalReferenceCode(Long siteId, String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        FileEntry fileEntry = this._dlAppLocalService.fetchFileEntryByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        if (fileEntry != null) {
            return this._updateDocument(fileEntry, multipartBody);
        }
        return this._addDocument(externalReferenceCode, siteId, siteId, null, multipartBody);
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        FileEntry fileEntry = this._dlAppService.getFileEntry(((Long)id).longValue());
        return fileEntry.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.document.library";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return DLFileEntry.class.getName();
    }

    private Document _addDocument(String externalReferenceCode, Long groupId, Long repositoryId, Long documentFolderId, MultipartBody multipartBody) throws Exception {
        BinaryFile binaryFile;
        Document document = (Document)multipartBody.getValueAsNullableInstance("document", Document.class);
        if (externalReferenceCode == null && document != null) {
            externalReferenceCode = document.getExternalReferenceCode();
        }
        if (documentFolderId == null) {
            documentFolderId = 0L;
        }
        if ((binaryFile = multipartBody.getBinaryFile("file")) == null) {
            throw new BadRequestException("No file found in body");
        }
        String fileName = null;
        String title = null;
        String description = null;
        if (document != null) {
            fileName = document.getFileName();
            title = document.getTitle();
            description = document.getDescription();
        }
        if (fileName == null) {
            fileName = binaryFile.getFileName();
        }
        if (title == null) {
            title = fileName;
        }
        return this._toDocument(this._dlAppService.addFileEntry(externalReferenceCode, repositoryId.longValue(), documentFolderId.longValue(), fileName, binaryFile.getContentType(), title, null, description, null, binaryFile.getInputStream(), binaryFile.getSize(), null, null, this._createServiceContext("add", () -> new Long[0], () -> new String[0], documentFolderId, document, groupId)));
    }

    private UnsafeConsumer<BooleanQuery, Exception> _createDocumentsPageBooleanQueryUnsafeConsumer(Long siteId, Boolean flatten) {
        return booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (!GetterUtil.getBoolean((Object)flatten)) {
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(0L)), BooleanClauseOccur.MUST);
            }
            if (siteId != null) {
                booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
            }
        };
    }

    private ServiceContext _createServiceContext(String command, Supplier<Long[]> defaultCategoriesSupplier, Supplier<String[]> defaultKeywordsSupplier, Long documentFolderId, Document document, Long groupId) throws Exception {
        DLFileEntryType dlFileEntryType;
        Long[] assetCategoryIds = null;
        String[] assetTagNames = null;
        String viewableBy = null;
        CustomField[] customFields = null;
        if (document != null) {
            assetCategoryIds = document.getTaxonomyCategoryIds();
            assetTagNames = document.getKeywords();
            viewableBy = document.getViewableByAsString();
            customFields = document.getCustomFields();
        }
        if (assetCategoryIds == null) {
            assetCategoryIds = defaultCategoriesSupplier.get();
        }
        if (assetTagNames == null) {
            assetTagNames = defaultKeywordsSupplier.get();
        }
        if (viewableBy == null) {
            viewableBy = Document.ViewableBy.OWNER.getValue();
        }
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)viewableBy).assetCategoryIds(assetCategoryIds).assetTagNames(assetTagNames).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)DLFileEntry.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])customFields, (Locale)this.contextAcceptLanguage.getPreferredLocale())).build();
        serviceContext.setCommand(command);
        serviceContext.setCompanyId(this.contextCompany.getCompanyId());
        serviceContext.setPlid(this._portal.getControlPanelPlid(this.contextCompany.getCompanyId()));
        serviceContext.setRequest(this.contextHttpServletRequest);
        serviceContext.setUserId(this.contextUser.getUserId());
        if (this.contextHttpServletRequest != null) {
            this._initThemeDisplay(groupId, this.contextHttpServletRequest, this.contextHttpServletResponse);
        }
        if ((dlFileEntryType = this._getDLFileEntryType(documentFolderId, document, groupId)) != null) {
            serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(dlFileEntryType.getFileEntryTypeId()));
            List ddmStructures = DLFileEntryTypeUtil.getDDMStructures((DLFileEntryType)dlFileEntryType);
            DocumentType documentType = document.getDocumentType();
            ContentField[] contentFields = documentType.getContentFields();
            for (DDMStructure ddmStructure : ddmStructures) {
                DDMStructure modelDDMStructure = this._ddmStructureService.getStructure(ddmStructure.getStructureId());
                DDMForm ddmForm = modelDDMStructure.getDDMForm();
                DDMFormValues ddmFormValues = DDMFormValuesUtil.toDDMFormValues((Set)ddmForm.getAvailableLocales(), (ContentField[])contentFields, (DDMForm)ddmForm, (DLAppService)this._dlAppService, (long)groupId, (JournalArticleService)this._journalArticleService, (LayoutLocalService)this._layoutLocalService, (Locale)this.contextAcceptLanguage.getPreferredLocale(), this.transform(ddmStructure.getRootFieldNames(), arg_0 -> ((DDMStructure)modelDDMStructure).getDDMFormField(arg_0)));
                serviceContext.setAttribute(com.liferay.dynamic.data.mapping.kernel.DDMFormValues.class.getName() + "#" + ddmStructure.getStructureId(), (Serializable)this._ddmBeanTranslator.translate(ddmFormValues));
            }
        }
        return serviceContext;
    }

    private long _getDDMStructureId(FileEntry fileEntry) throws Exception {
        if (!(fileEntry.getModel() instanceof DLFileEntry)) {
            return 0L;
        }
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.fetchDLFileEntryType(dlFileEntry.getFileEntryTypeId());
        if (dlFileEntryType == null || dlFileEntryType.getDataDefinitionId() == 0L) {
            return 0L;
        }
        DDMStructure ddmStructure = this._ddmStructureService.getStructure(dlFileEntryType.getDataDefinitionId());
        return ddmStructure.getStructureId();
    }

    private DLFileEntryType _getDLFileEntryType(long documentFolderId, Document document, Long groupId) {
        block6: {
            if (document == null) {
                return null;
            }
            DocumentType documentType = document.getDocumentType();
            if (documentType == null) {
                return null;
            }
            String name = documentType.getName();
            if (name == null) {
                return null;
            }
            try {
                for (DLFileEntryType dlFileEntryType : this._dlFileEntryTypeLocalService.getFolderFileEntryTypes(new long[]{groupId}, documentFolderId, true)) {
                    if (!name.equals(dlFileEntryType.getName(this.contextAcceptLanguage.getPreferredLocale()))) continue;
                    return dlFileEntryType;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Throwable)exception);
            }
        }
        return null;
    }

    private Page<Document> _getDocumentsPage(Map<String, Map<String, String>> actions, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)FilterUtil.processFilter((DDMIndexer)this._ddmIndexer, (Filter)filter), this._indexer, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation((Aggregations)this._aggregations, (DDMIndexer)this._ddmIndexer, (Queries)this._queries, (SearchRequestBuilder)searchRequestBuilder, (Aggregation)aggregation);
            SortUtil.processSorts((DDMIndexer)this._ddmIndexer, (SearchRequestBuilder)searchRequestBuilder, (Sort[])searchContext.getSorts(), (Queries)this._queries, (Sorts)this._sorts);
        }, (Sort[])sorts, document -> this._toDocument(this._dlAppService.getFileEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private Page<Document> _getGroupDocumentsRatedByMePage(long groupId, Pagination pagination) throws Exception {
        return Page.of(this._toDocuments(this._dlFileEntryService.getFileEntries(groupId, 0.1, pagination.getStartPosition(), pagination.getEndPosition())), (Pagination)pagination, (long)this._dlFileEntryService.getFileEntriesCount(groupId, 0.1));
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(DLFileEntry.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> {
            FileEntry fileEntry = this._dlAppService.getFileEntry(ratingsEntry.getClassPK());
            return RatingUtil.toRating(HashMapBuilder.put((Object)"create", this.addAction("VIEW", fileEntry.getPrimaryKey(), "postDocumentMyRating", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"delete", this.addAction("VIEW", fileEntry.getPrimaryKey(), "deleteDocumentMyRating", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"get", this.addAction("VIEW", fileEntry.getPrimaryKey(), "getDocumentMyRating", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"replace", this.addAction("VIEW", fileEntry.getPrimaryKey(), "putDocumentMyRating", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).build(), this._portal, ratingsEntry, this._userLocalService);
        }, this.contextUser);
    }

    private void _initThemeDisplay(long groupId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ServicePreAction servicePreAction = new ServicePreAction();
        servicePreAction.servicePre(httpServletRequest, httpServletResponse, false);
        ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
        themeServicePreAction.run(httpServletRequest, httpServletResponse);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setScopeGroupId(groupId);
        themeDisplay.setSiteGroupId(groupId);
    }

    private FileEntry _moveDocument(Long documentId, Document document, FileEntry existingFileEntry) throws Exception {
        Long folderId = null;
        if (document != null && document.getDocumentFolderId() != null && document.getDocumentFolderId().longValue() != existingFileEntry.getFolderId()) {
            folderId = document.getDocumentFolderId();
        }
        if (folderId != null) {
            return this._dlAppService.moveFileEntry(documentId.longValue(), folderId.longValue(), new ServiceContext());
        }
        return existingFileEntry;
    }

    private Document _toDocument(FileEntry fileEntry) throws Exception {
        return (Document)this._documentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", fileEntry.getPrimaryKey(), "deleteDocument", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"get", this.addAction("VIEW", fileEntry.getPrimaryKey(), "getDocument", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"get-rendered-content-by-display-page", this.addAction("VIEW", fileEntry.getPrimaryKey(), "getDocumentRenderedContentByDisplayPageDisplayPageKey", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"replace", this.addAction("UPDATE", fileEntry.getPrimaryKey(), "putDocument", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"update", this.addAction("UPDATE", fileEntry.getPrimaryKey(), "patchDocument", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).build(), this._dtoConverterRegistry, (Object)fileEntry.getFileEntryId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<Document> _toDocuments(List<DLFileEntry> dlFileEntries) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            documents.add(this._toDocument((FileEntry)new LiferayFileEntry(dlFileEntry)));
        }
        return documents;
    }

    private Document _updateDocument(FileEntry fileEntry, MultipartBody multipartBody) throws Exception {
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        Document document = (Document)multipartBody.getValueAsNullableInstance("document", Document.class);
        if (binaryFile == null && document == null) {
            throw new BadRequestException("Document and file are not found in body");
        }
        if (binaryFile == null) {
            binaryFile = new BinaryFile(fileEntry.getMimeType(), fileEntry.getFileName(), fileEntry.getContentStream(), fileEntry.getSize());
        }
        fileEntry = this._moveDocument(fileEntry.getFileEntryId(), document, fileEntry);
        String fileName = null;
        String title = null;
        String description = null;
        if (document != null) {
            fileName = document.getFileName();
            title = document.getTitle();
            description = document.getDescription();
        }
        if (fileName == null) {
            fileName = binaryFile.getFileName();
        }
        if (title == null) {
            title = fileEntry.getTitle();
        }
        return this._toDocument(this._dlAppService.updateFileEntry(fileEntry.getFileEntryId(), fileName, binaryFile.getContentType(), title, null, description, null, DLVersionNumberIncrease.AUTOMATIC, binaryFile.getInputStream(), binaryFile.getSize(), fileEntry.getExpirationDate(), fileEntry.getReviewDate(), this._createServiceContext("update", () -> new Long[0], () -> new String[0], fileEntry.getFolderId(), document, fileEntry.getGroupId())));
    }
}

