/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseAttachment;
import com.liferay.headless.delivery.dto.v1_0.util.ContentValueUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseKnowledgeBaseAttachmentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseAttachmentResource;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/knowledge-base-attachment.properties"}, scope=ServiceScope.PROTOTYPE, service={KnowledgeBaseAttachmentResource.class})
public class KnowledgeBaseAttachmentResourceImpl
extends BaseKnowledgeBaseAttachmentResourceImpl {
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private KBArticleService _kbArticleService;
    @Reference
    private PortletFileRepository _portletFileRepository;

    @Override
    public void deleteKnowledgeBaseAttachment(Long knowledgeBaseAttachmentId) throws Exception {
        this._portletFileRepository.deletePortletFileEntry(knowledgeBaseAttachmentId.longValue());
    }

    @Override
    public void deleteSiteKnowledgeBaseArticleByExternalReferenceCodeKnowledgeBaseArticleExternalReferenceCodeKnowledgeBaseAttachmentByExternalReferenceCode(Long siteId, String knowledgeBaseArticleExternalReferenceCode, String externalReferenceCode) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticleByExternalReferenceCode(siteId.longValue(), knowledgeBaseArticleExternalReferenceCode);
        FileEntry fileEntry = kbArticle.getAttachmentsFileEntryByExternalReferenceCode(externalReferenceCode);
        this._portletFileRepository.deletePortletFileEntry(fileEntry.getFileEntryId());
    }

    @Override
    public Page<KnowledgeBaseAttachment> getKnowledgeBaseArticleKnowledgeBaseAttachmentsPage(Long knowledgeBaseArticleId) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(knowledgeBaseArticleId.longValue(), 0);
        return Page.of((Map)HashMapBuilder.put((Object)"createBatch", this.addAction("ADD_KB_ARTICLE", kbArticle.getResourcePrimKey(), "postKnowledgeBaseArticleKnowledgeBaseAttachmentBatch", kbArticle.getUserId(), "com.liferay.knowledge.base.admin", kbArticle.getGroupId())).build(), this.transform(kbArticle.getAttachmentsFileEntries(), this::_toKnowledgeBaseAttachment));
    }

    @Override
    public KnowledgeBaseAttachment getKnowledgeBaseAttachment(Long knowledgeBaseAttachmentId) throws Exception {
        return this._toKnowledgeBaseAttachment(this._portletFileRepository.getPortletFileEntry(knowledgeBaseAttachmentId.longValue()));
    }

    @Override
    public KnowledgeBaseAttachment getSiteKnowledgeBaseArticleByExternalReferenceCodeKnowledgeBaseArticleExternalReferenceCodeKnowledgeBaseAttachmentByExternalReferenceCode(Long siteId, String knowledgeBaseArticleExternalReferenceCode, String externalReferenceCode) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticleByExternalReferenceCode(siteId.longValue(), knowledgeBaseArticleExternalReferenceCode);
        return this._toKnowledgeBaseAttachment(kbArticle.getAttachmentsFileEntryByExternalReferenceCode(externalReferenceCode));
    }

    @Override
    public KnowledgeBaseAttachment postKnowledgeBaseArticleKnowledgeBaseAttachment(Long knowledgeBaseArticleId, MultipartBody multipartBody) throws Exception {
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("No file found in body");
        }
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(knowledgeBaseArticleId.longValue(), 0);
        return this._toKnowledgeBaseAttachment(this._portletFileRepository.addPortletFileEntry(this._getKnowledgeBaseAttachmentExternalReferenceCode(multipartBody), kbArticle.getGroupId(), this.contextUser.getUserId(), KBArticle.class.getName(), kbArticle.getClassPK(), "com.liferay.knowledge.base", kbArticle.getAttachmentsFolderId(), binaryFile.getInputStream(), binaryFile.getFileName(), binaryFile.getContentType(), false));
    }

    private String _getKnowledgeBaseAttachmentExternalReferenceCode(MultipartBody multipartBody) throws Exception {
        KnowledgeBaseAttachment knowledgeBaseAttachment = (KnowledgeBaseAttachment)multipartBody.getValueAsInstance("knowledgeBaseAttachment", KnowledgeBaseAttachment.class);
        if (knowledgeBaseAttachment == null) {
            return null;
        }
        return knowledgeBaseAttachment.getExternalReferenceCode();
    }

    private KnowledgeBaseAttachment _toKnowledgeBaseAttachment(final FileEntry fileEntry) throws Exception {
        return new KnowledgeBaseAttachment(){
            {
                this.contentUrl = KnowledgeBaseAttachmentResourceImpl.this._portletFileRepository.getPortletFileEntryURL(null, fileEntry, null);
                this.contentValue = ContentValueUtil.toContentValue((String)"contentValue", () -> ((FileEntry)fileEntry).getContentStream(), (UriInfo)KnowledgeBaseAttachmentResourceImpl.this.contextUriInfo);
                this.encodingFormat = fileEntry.getMimeType();
                this.externalReferenceCode = fileEntry.getExternalReferenceCode();
                this.fileExtension = fileEntry.getExtension();
                this.id = fileEntry.getFileEntryId();
                this.sizeInBytes = fileEntry.getSize();
                this.title = fileEntry.getTitle();
            }
        };
    }
}

