/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.Language;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseLanguageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.LanguageResource;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/language.properties"}, scope=ServiceScope.PROTOTYPE, service={LanguageResource.class})
public class LanguageResourceImpl
extends BaseLanguageResourceImpl {
    @Reference
    private GroupService _groupService;
    @Reference
    private com.liferay.portal.kernel.language.Language _language;
    @Reference
    private Localization _localization;

    @Override
    public Page<Language> getAssetLibraryLanguagesPage(Long assetLibraryId) throws Exception {
        return this.getSiteLanguagesPage(assetLibraryId);
    }

    @Override
    public Page<Language> getSiteLanguagesPage(Long siteId) throws Exception {
        Set availableLocales = this._language.getAvailableLocales(siteId.longValue());
        Locale defaultLocale = this._getDefaultLocale(siteId);
        return Page.of(this.transform(availableLocales, availableLocale -> this._toLanguage(this.contextAcceptLanguage.isAcceptAllLanguages(), availableLocales, defaultLocale, (Locale)availableLocale, this.contextAcceptLanguage.getPreferredLocale())));
    }

    private Locale _getDefaultLocale(long groupId) throws Exception {
        Group group = this._groupService.getGroup(groupId);
        String defaultLanguageId = this._localization.getDefaultLanguageId(group.getName());
        if (Validator.isNotNull((String)defaultLanguageId)) {
            return LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        return LocaleUtil.getSiteDefault();
    }

    private Language _toLanguage(final boolean acceptAllLanguages, final Set<Locale> availableLocales, final Locale defaultLocale, final Locale locale, final Locale preferredLocale) {
        return new Language(){
            {
                this.countryName = locale.getDisplayCountry(preferredLocale);
                this.id = locale.toLanguageTag();
                this.markedAsDefault = Objects.equals(defaultLocale, locale);
                this.name = locale.getDisplayLanguage(preferredLocale);
                this.setCountryName_i18n(() -> {
                    if (!acceptAllLanguages) {
                        return null;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (Locale availableLocale : availableLocales) {
                        map.put(LocaleUtil.toBCP47LanguageId((Locale)availableLocale), locale.getDisplayCountry(availableLocale));
                    }
                    return map;
                });
                this.setName_i18n(() -> {
                    if (!acceptAllLanguages) {
                        return null;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (Locale availableLocale : availableLocales) {
                        map.put(LocaleUtil.toBCP47LanguageId((Locale)availableLocale), locale.getDisplayLanguage(availableLocale));
                    }
                    return map;
                });
            }
        };
    }
}

