/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardAttachment;
import com.liferay.headless.delivery.dto.v1_0.util.ContentValueUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardAttachmentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardAttachmentResource;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-attachment.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardAttachmentResource.class})
public class MessageBoardAttachmentResourceImpl
extends BaseMessageBoardAttachmentResourceImpl {
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;

    @Override
    public void deleteMessageBoardAttachment(Long messageBoardAttachmentId) throws Exception {
        this._portletFileRepository.deletePortletFileEntry(messageBoardAttachmentId.longValue());
    }

    @Override
    public void deleteSiteMessageBoardMessageByExternalReferenceCodeMessageBoardMessageExternalReferenceCodeMessageBoardAttachmentByExternalReferenceCode(Long siteId, String messageBoardMessageExternalReferenceCode, String externalReferenceCode) throws Exception {
        MBMessage mbMessage = this._mbMessageService.getMBMessageByExternalReferenceCode(messageBoardMessageExternalReferenceCode, siteId.longValue());
        FileEntry fileEntry = mbMessage.getAttachmentsFileEntryByExternalReferenceCode(externalReferenceCode, siteId.longValue());
        this._portletFileRepository.deletePortletFileEntry(fileEntry.getFileEntryId());
    }

    @Override
    public MessageBoardAttachment getMessageBoardAttachment(Long messageBoardAttachmentId) throws Exception {
        return this._toMessageBoardAttachment(this._portletFileRepository.getPortletFileEntry(messageBoardAttachmentId.longValue()));
    }

    @Override
    public Page<MessageBoardAttachment> getMessageBoardMessageMessageBoardAttachmentsPage(Long messageBoardMessageId) throws Exception {
        MBMessage mbMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
        return this._getMessageBoardAttachmentsPage(HashMapBuilder.put((Object)"createBatch", this.addAction("VIEW", mbMessage.getMessageId(), "postMessageBoardMessageMessageBoardAttachmentBatch", mbMessage.getUserId(), "com.liferay.message.boards", mbMessage.getGroupId())).build(), mbMessage);
    }

    @Override
    public Page<MessageBoardAttachment> getMessageBoardThreadMessageBoardAttachmentsPage(Long messageBoardThreadId) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        MBMessage mbMessage = this._mbMessageService.getMessage(mbThread.getRootMessageId());
        return this._getMessageBoardAttachmentsPage(HashMapBuilder.put((Object)"createBatch", this.addAction("ADD_MESSAGE", mbThread.getThreadId(), "postMessageBoardThreadMessageBoardAttachmentBatch", mbThread.getUserId(), "com.liferay.message.boards", mbThread.getGroupId())).build(), mbMessage);
    }

    @Override
    public MessageBoardAttachment getSiteMessageBoardMessageByExternalReferenceCodeMessageBoardMessageExternalReferenceCodeMessageBoardAttachmentByExternalReferenceCode(Long siteId, String messageBoardMessageExternalReferenceCode, String externalReferenceCode) throws Exception {
        MBMessage mbMessage = this._mbMessageService.getMBMessageByExternalReferenceCode(messageBoardMessageExternalReferenceCode, siteId.longValue());
        FileEntry fileEntry = mbMessage.getAttachmentsFileEntryByExternalReferenceCode(externalReferenceCode, siteId.longValue());
        return this._toMessageBoardAttachment(fileEntry);
    }

    @Override
    public MessageBoardAttachment postMessageBoardMessageMessageBoardAttachment(Long messageBoardMessageId, MultipartBody multipartBody) throws Exception {
        return this._addMessageBoardAttachment(messageBoardMessageId, multipartBody);
    }

    @Override
    public MessageBoardAttachment postMessageBoardThreadMessageBoardAttachment(Long messageBoardThreadId, MultipartBody multipartBody) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return this._addMessageBoardAttachment(mbThread.getRootMessageId(), multipartBody);
    }

    private MessageBoardAttachment _addMessageBoardAttachment(Long messageBoardMessageId, MultipartBody multipartBody) throws Exception {
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("No file found in body");
        }
        MBMessage mbMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
        Folder folder = mbMessage.addAttachmentsFolder();
        return this._toMessageBoardAttachment(this._portletFileRepository.addPortletFileEntry(null, mbMessage.getGroupId(), this.contextUser.getUserId(), MBMessage.class.getName(), mbMessage.getClassPK(), "com.liferay.message.boards", folder.getFolderId(), binaryFile.getInputStream(), binaryFile.getFileName(), binaryFile.getFileName(), false));
    }

    private Page<MessageBoardAttachment> _getMessageBoardAttachmentsPage(Map<String, Map<String, String>> actions, MBMessage mbMessage) throws Exception {
        return Page.of(actions, this.transform(mbMessage.getAttachmentsFileEntries(), this::_toMessageBoardAttachment));
    }

    private MessageBoardAttachment _toMessageBoardAttachment(final FileEntry fileEntry) throws Exception {
        return new MessageBoardAttachment(){
            {
                this.contentUrl = MessageBoardAttachmentResourceImpl.this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false);
                this.contentValue = ContentValueUtil.toContentValue((String)"contentValue", () -> ((FileEntry)fileEntry).getContentStream(), (UriInfo)MessageBoardAttachmentResourceImpl.this.contextUriInfo);
                this.encodingFormat = fileEntry.getMimeType();
                this.externalReferenceCode = fileEntry.getExternalReferenceCode();
                this.fileExtension = fileEntry.getExtension();
                this.id = fileEntry.getFileEntryId();
                this.sizeInBytes = fileEntry.getSize();
                this.title = fileEntry.getTitle();
            }
        };
    }
}

