/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardSection;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.MessageBoardSectionEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardSectionResourceImpl;
import com.liferay.headless.delivery.internal.resource.v1_0.MessageBoardThreadResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardSectionResource;
import com.liferay.headless.delivery.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.search.filter.FilterUtil;
import com.liferay.headless.delivery.search.sort.SortUtil;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-section.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardSectionResource.class})
public class MessageBoardSectionResourceImpl
extends BaseMessageBoardSectionResourceImpl {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private MBCategoryService _mbCategoryService;
    @Reference(target="(component.name=com.liferay.headless.delivery.internal.dto.v1_0.converter.MessageBoardSectionDTOConverter)")
    private DTOConverter<MBCategory, MessageBoardSection> _messageBoardSectionDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;

    @Override
    public void deleteMessageBoardSection(Long messageBoardSectionId) throws Exception {
        this._mbCategoryService.deleteCategory(messageBoardSectionId.longValue(), true);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new MessageBoardSectionEntityModel(new ArrayList<EntityField>(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(MBCategory.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService)));
    }

    @Override
    public MessageBoardSection getMessageBoardSection(Long messageBoardSectionId) throws Exception {
        return this._toMessageBoardSection(this._mbCategoryService.getCategory(messageBoardSectionId.longValue()));
    }

    @Override
    public Page<MessageBoardSection> getMessageBoardSectionMessageBoardSectionsPage(Long parentMessageBoardSectionId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(parentMessageBoardSectionId.longValue());
        return this._getMessageBoardSectionsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_CATEGORY", "postMessageBoardSectionMessageBoardSection", "com.liferay.message.boards", mbCategory.getGroupId())).put((Object)"get", this.addAction("VIEW", "getMessageBoardSectionMessageBoardSectionsPage", "com.liferay.message.boards", mbCategory.getGroupId())).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("parentCategoryId", String.valueOf(mbCategory.getCategoryId())), BooleanClauseOccur.MUST);
        }), mbCategory.getGroupId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public MessageBoardSection getSiteMessageBoardSectionByFriendlyUrlPath(Long siteId, String friendlyUrlPath) throws Exception {
        return this._toMessageBoardSection(this._mbCategoryService.getMBCategory(siteId.longValue(), friendlyUrlPath));
    }

    @Override
    public Page<MessageBoardSection> getSiteMessageBoardSectionsPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getMessageBoardSectionsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_CATEGORY", "postSiteMessageBoardSection", "com.liferay.message.boards", siteId)).put((Object)"createBatch", this.addAction("ADD_CATEGORY", "postSiteMessageBoardSectionBatch", "com.liferay.message.boards", siteId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteMessageBoardSectionBatch", "com.liferay.message.boards", null)).put((Object)"get", this.addAction("VIEW", "getSiteMessageBoardSectionsPage", "com.liferay.message.boards", siteId)).put((Object)"updateBatch", this.addAction("UPDATE", "putMessageBoardSectionBatch", "com.liferay.message.boards", null)).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (!GetterUtil.getBoolean((Object)flatten)) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("parentCategoryId", "0"), BooleanClauseOccur.MUST);
            }
        }), siteId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public MessageBoardSection postMessageBoardSectionMessageBoardSection(Long parentMessageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(parentMessageBoardSectionId.longValue());
        return this._addMessageBoardSection(mbCategory.getGroupId(), parentMessageBoardSectionId, messageBoardSection);
    }

    @Override
    public MessageBoardSection postSiteMessageBoardSection(Long siteId, MessageBoardSection messageBoardSection) throws Exception {
        return this._addMessageBoardSection(siteId, 0L, messageBoardSection);
    }

    @Override
    public MessageBoardSection putMessageBoardSection(Long messageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        return this._toMessageBoardSection(this._mbCategoryService.updateCategory(messageBoardSectionId.longValue(), mbCategory.getParentCategoryId(), messageBoardSection.getTitle(), messageBoardSection.getDescription(), mbCategory.getDisplayStyle(), "", "", "", 0, false, "", "", 0, "", false, "", 0, false, "", "", false, false, false, this._createServiceContext(mbCategory.getGroupId(), messageBoardSection, null)));
    }

    @Override
    public void putMessageBoardSectionSubscribe(Long messageBoardSectionId) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        this._mbCategoryService.subscribeCategory(mbCategory.getGroupId(), mbCategory.getCategoryId());
    }

    @Override
    public void putMessageBoardSectionUnsubscribe(Long messageBoardSectionId) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        this._mbCategoryService.unsubscribeCategory(mbCategory.getGroupId(), mbCategory.getCategoryId());
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(((Long)id).longValue());
        return mbCategory.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.message.boards";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return MBCategory.class.getName();
    }

    private MessageBoardSection _addMessageBoardSection(long siteId, Long parentMessageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        return this._toMessageBoardSection(this._mbCategoryService.addCategory(this.contextUser.getUserId(), parentMessageBoardSectionId.longValue(), messageBoardSection.getTitle(), messageBoardSection.getDescription(), this._createServiceContext(siteId, messageBoardSection, messageBoardSection.getViewableByAsString())));
    }

    private ServiceContext _createServiceContext(long groupId, MessageBoardSection messageBoardSection, String viewableBy) {
        return ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)viewableBy).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)MBCategory.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])messageBoardSection.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale())).build();
    }

    private Page<MessageBoardSection> _getMessageBoardSectionsPage(Map<String, Map<String, String>> actions, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Long siteId, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)FilterUtil.processFilter((DDMIndexer)this._ddmIndexer, (Filter)filter), (String)MBCategory.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation((Aggregations)this._aggregations, (DDMIndexer)this._ddmIndexer, (Queries)this._queries, (SearchRequestBuilder)searchRequestBuilder, (Aggregation)aggregation);
            SortUtil.processSorts((DDMIndexer)this._ddmIndexer, (SearchRequestBuilder)searchRequestBuilder, (Sort[])searchContext.getSorts(), (Queries)this._queries, (Sorts)this._sorts);
        }, (Sort[])sorts, document -> this._toMessageBoardSection(this._mbCategoryService.getCategory(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private MessageBoardSection _toMessageBoardSection(MBCategory mbCategory) throws Exception {
        return (MessageBoardSection)this._messageBoardSectionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"add-subcategory", this.addAction("ADD_SUBCATEGORY", (GroupedModel)mbCategory, "postMessageBoardSectionMessageBoardSection")).put((Object)"add-thread", (Object)ActionUtil.addAction((String)"ADD_MESSAGE", MessageBoardThreadResourceImpl.class, (Long)mbCategory.getCategoryId(), (String)"postMessageBoardSectionMessageBoardThread", (Object)this.contextScopeChecker, (Long)mbCategory.getUserId(), (String)MBCategory.class.getName(), (Long)mbCategory.getGroupId(), (UriInfo)this.contextUriInfo)).put((Object)"delete", this.addAction("DELETE", (GroupedModel)mbCategory, "deleteMessageBoardSection")).put((Object)"get", this.addAction("VIEW", (GroupedModel)mbCategory, "getMessageBoardSection")).put((Object)"replace", this.addAction("UPDATE", (GroupedModel)mbCategory, "putMessageBoardSection")).put((Object)"subscribe", this.addAction("SUBSCRIBE", (GroupedModel)mbCategory, "putMessageBoardSectionSubscribe")).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", (GroupedModel)mbCategory, "putMessageBoardSectionUnsubscribe")).build(), this._dtoConverterRegistry, (Object)mbCategory.getCategoryId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

