/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardThread;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.MessageBoardMessageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardThreadResourceImpl;
import com.liferay.headless.delivery.internal.resource.v1_0.MessageBoardMessageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardThreadResource;
import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.exception.NoSuchMessageException;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadFlagLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.service.MBThreadService;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.message.boards.util.comparator.ThreadCreateDateComparator;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.view.count.ViewCountManager;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-thread.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardThreadResource.class})
public class MessageBoardThreadResourceImpl
extends BaseMessageBoardThreadResourceImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private MBCategoryService _mbCategoryService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private MBThreadFlagLocalService _mbThreadFlagLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private MBThreadService _mbThreadService;
    @Reference(target="(component.name=com.liferay.headless.delivery.internal.dto.v1_0.converter.MessageBoardThreadDTOConverter)")
    private DTOConverter<MBThread, MessageBoardThread> _messageBoardThreadDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private ViewCountManager _viewCountManager;

    @Override
    public void deleteMessageBoardThread(Long messageBoardThreadId) throws Exception {
        this._mbThreadService.deleteThread(messageBoardThreadId.longValue());
    }

    @Override
    public void deleteMessageBoardThreadMyRating(Long messageBoardThreadId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        spiRatingResource.deleteRating(Long.valueOf(mbThread.getRootMessageId()));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new MessageBoardMessageEntityModel(new ArrayList<EntityField>(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(MBMessage.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService)));
    }

    @Override
    public Page<MessageBoardThread> getMessageBoardSectionMessageBoardThreadsPage(Long messageBoardSectionId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        HashMap actions = HashMapBuilder.put((Object)"create", this.addAction("ADD_MESSAGE", mbCategory.getCategoryId(), "postMessageBoardSectionMessageBoardThread", mbCategory.getUserId(), "com.liferay.message.boards", mbCategory.getGroupId())).put((Object)"createBatch", this.addAction("ADD_MESSAGE", mbCategory.getCategoryId(), "postMessageBoardSectionMessageBoardThreadBatch", mbCategory.getUserId(), "com.liferay.message.boards", mbCategory.getGroupId())).put((Object)"get", this.addAction("VIEW", mbCategory.getCategoryId(), "getMessageBoardSectionMessageBoardThreadsPage", mbCategory.getUserId(), "com.liferay.message.boards", mbCategory.getGroupId())).build();
        if (search == null && filter == null && sorts == null) {
            int status = 0;
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker.isContentReviewer(this.contextCompany.getCompanyId(), mbCategory.getGroupId())) {
                status = -1;
            }
            return Page.of((Map)actions, this.transform(this._mbThreadService.getThreads(mbCategory.getGroupId(), mbCategory.getCategoryId(), new QueryDefinition(status, this.contextUser.getUserId(), true, pagination.getStartPosition(), pagination.getEndPosition(), (OrderByComparator)new ThreadCreateDateComparator())), this::_toMessageBoardThread), (Pagination)pagination, (long)this._mbThreadService.getThreadsCount(mbCategory.getGroupId(), mbCategory.getCategoryId(), new QueryDefinition(status, this.contextUser.getUserId(), true, pagination.getStartPosition(), pagination.getEndPosition(), null)));
        }
        return this._getSiteMessageBoardThreadsPage(actions, (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("categoryId", String.valueOf(mbCategory.getCategoryId())), BooleanClauseOccur.MUST);
            booleanFilter.add((Filter)new TermFilter("parentMessageId", "0"), BooleanClauseOccur.MUST);
        }), mbCategory.getGroupId(), aggregation, filter, search, pagination, sorts);
    }

    @Override
    public MessageBoardThread getMessageBoardThread(Long messageBoardThreadId) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        this._checkPermission(mbThread.getCompanyId(), mbThread.getGroupId(), mbThread.getStatus(), mbThread.getUserId());
        this._viewCountManager.incrementViewCount(this.contextCompany.getCompanyId(), this._classNameLocalService.getClassNameId(MBThread.class), messageBoardThreadId.longValue(), 1);
        this._mbThreadFlagLocalService.addThreadFlag(this.contextUser.getUserId(), mbThread, new ServiceContext());
        return this._toMessageBoardThread(mbThread);
    }

    @Override
    public Rating getMessageBoardThreadMyRating(Long messageBoardThreadId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return (Rating)spiRatingResource.getRating(Long.valueOf(mbThread.getRootMessageId()));
    }

    @Override
    public Page<MessageBoardThread> getMessageBoardThreadsRankedPage(Date dateCreated, Date dateModified, Long messageBoardSectionId, Pagination pagination, Sort[] sorts) {
        DynamicQuery dynamicQuery = this._getDynamicQuery(dateCreated, dateModified, messageBoardSectionId);
        if (sorts == null) {
            dynamicQuery.addOrder(OrderFactoryUtil.desc((String)"totalScore"));
        } else {
            for (Sort sort : sorts) {
                String fieldName = sort.getFieldName();
                if ((fieldName = StringUtil.removeSubstring((String)fieldName, (String)"_sortable")).equals("modified")) {
                    fieldName = "modifiedDate";
                }
                if (sort.isReverse()) {
                    dynamicQuery.addOrder(OrderFactoryUtil.desc((String)fieldName));
                    continue;
                }
                dynamicQuery.addOrder(OrderFactoryUtil.asc((String)fieldName));
            }
        }
        return Page.of(this.transform(this._ratingsStatsLocalService.dynamicQuery(dynamicQuery, pagination.getStartPosition(), pagination.getEndPosition()), ratingsStats -> this._toMessageBoardThread(this._mbMessageService.getMessage(ratingsStats.getClassPK()))), (Pagination)pagination, (long)this._ratingsStatsLocalService.dynamicQueryCount(this._getDynamicQuery(dateCreated, dateModified, messageBoardSectionId)));
    }

    @Override
    public MessageBoardThread getSiteMessageBoardThreadByFriendlyUrlPath(Long siteId, String friendlyUrlPath) throws Exception {
        MBMessage mbMessage = this._mbMessageService.fetchMBMessageByUrlSubject(siteId.longValue(), friendlyUrlPath);
        if (mbMessage == null) {
            throw new NoSuchMessageException("No message thread exists with friendly URL path " + friendlyUrlPath);
        }
        this._checkPermission(mbMessage.getCompanyId(), mbMessage.getGroupId(), mbMessage.getStatus(), mbMessage.getUserId());
        this._viewCountManager.incrementViewCount(this.contextCompany.getCompanyId(), this._classNameLocalService.getClassNameId(MBThread.class), mbMessage.getThreadId(), 1);
        this._mbThreadFlagLocalService.addThreadFlag(this.contextUser.getUserId(), mbMessage.getThread(), new ServiceContext());
        return this._toMessageBoardThread(mbMessage);
    }

    @Override
    public Page<MessageBoardThread> getSiteMessageBoardThreadsPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getSiteMessageBoardThreadsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_MESSAGE", "postSiteMessageBoardThread", "com.liferay.message.boards", siteId)).put((Object)"createBatch", this.addAction("ADD_MESSAGE", "postSiteMessageBoardThreadBatch", "com.liferay.message.boards", siteId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteMessageBoardThreadBatch", "com.liferay.message.boards", null)).put((Object)"get", this.addAction("VIEW", "getSiteMessageBoardThreadsPage", "com.liferay.message.boards", siteId)).put((Object)"updateBatch", this.addAction("UPDATE", "putMessageBoardThreadBatch", "com.liferay.message.boards", null)).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (!GetterUtil.getBoolean((Object)flatten)) {
                booleanFilter.add((Filter)new TermFilter("categoryId", "0"), BooleanClauseOccur.MUST);
            }
            booleanFilter.add((Filter)new TermFilter("parentMessageId", "0"), BooleanClauseOccur.MUST);
        }), siteId, aggregation, filter, search, pagination, sorts);
    }

    @Override
    public MessageBoardThread postMessageBoardSectionMessageBoardThread(Long messageBoardSectionId, MessageBoardThread messageBoardThread) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        return this._addMessageBoardThread(mbCategory.getGroupId(), messageBoardSectionId, messageBoardThread);
    }

    @Override
    public Rating postMessageBoardThreadMyRating(Long messageBoardThreadId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        MBThread mbThread = this._mbThreadLocalService.getThread(messageBoardThreadId.longValue());
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), mbThread.getRootMessageId());
    }

    @Override
    public MessageBoardThread postSiteMessageBoardThread(Long siteId, MessageBoardThread messageBoardThread) throws Exception {
        Long messageBoardSectionId = 0L;
        if (messageBoardThread.getMessageBoardSectionId() != null) {
            messageBoardSectionId = messageBoardThread.getMessageBoardSectionId();
        }
        return this._addMessageBoardThread(siteId, messageBoardSectionId, messageBoardThread);
    }

    @Override
    public MessageBoardThread putMessageBoardThread(Long messageBoardThreadId, MessageBoardThread messageBoardThread) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        MBMessage mbMessage = this._mbMessageService.updateMessage(mbThread.getRootMessageId(), messageBoardThread.getHeadline(), messageBoardThread.getArticleBody(), null, this._toPriority(mbThread.getGroupId(), messageBoardThread.getThreadType()), false, this._createServiceContext(mbThread.getGroupId(), messageBoardThread));
        this._updateQuestion(mbMessage, messageBoardThread);
        return this._toMessageBoardThread(mbMessage);
    }

    @Override
    public Rating putMessageBoardThreadMyRating(Long messageBoardThreadId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        MBThread mbThread = this._mbThreadLocalService.getThread(messageBoardThreadId.longValue());
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), mbThread.getRootMessageId());
    }

    @Override
    public void putMessageBoardThreadSubscribe(Long messageBoardThreadId) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getThread(messageBoardThreadId.longValue());
        this._mbMessageService.subscribeMessage(mbThread.getRootMessageId());
    }

    @Override
    public void putMessageBoardThreadUnsubscribe(Long messageBoardThreadId) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getThread(messageBoardThreadId.longValue());
        this._mbMessageService.unsubscribeMessage(mbThread.getRootMessageId());
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getThread(((Long)id).longValue());
        return mbThread.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.message.boards";
    }

    @Override
    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getThread(((Long)id).longValue());
        return mbThread.getRootMessageId();
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return MBMessage.class.getName();
    }

    private MessageBoardThread _addMessageBoardThread(Long siteId, Long messageBoardSectionId, MessageBoardThread messageBoardThread) throws Exception {
        String encodingFormat = messageBoardThread.getEncodingFormat();
        if (encodingFormat == null) {
            encodingFormat = MBMessageConstants.DEFAULT_FORMAT;
        }
        ServiceContext serviceContext = this._createServiceContext(siteId, messageBoardThread);
        MBMessage mbMessage = this._mbMessageService.addMessage(siteId.longValue(), messageBoardSectionId.longValue(), messageBoardThread.getHeadline(), messageBoardThread.getArticleBody(), encodingFormat, Collections.emptyList(), false, this._toPriority(siteId, messageBoardThread.getThreadType()), false, serviceContext);
        this._updateQuestion(mbMessage, messageBoardThread);
        return this._toMessageBoardThread(mbMessage);
    }

    private void _checkPermission(long companyId, long groupId, int status, long userId) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (status != 0 && userId != this.contextUser.getUserId() && !permissionChecker.isContentReviewer(companyId, groupId)) {
            throw new NotAuthorizedException((Object)StringBundler.concat((Object[])new Object[]{"User ", userId, " must be the owner or a content reviewer to access this ", "message thread"}), new Object[0]);
        }
    }

    private ServiceContext _createServiceContext(long groupId, MessageBoardThread messageBoardThread) {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)messageBoardThread.getViewableByAsString()).assetCategoryIds(messageBoardThread.getTaxonomyCategoryIds()).assetTagNames(GetterUtil.getStringValues((String[])messageBoardThread.getKeywords())).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)MBMessage.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])messageBoardThread.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale())).build();
        String link = this.contextHttpServletRequest.getHeader("Link");
        if (link == null) {
            UriBuilder uriBuilder = UriInfoUtil.getBaseUriBuilder((UriInfo)this.contextUriInfo);
            link = String.valueOf(uriBuilder.replacePath("/").build(new Object[0]));
        }
        serviceContext.setAttribute("link", (Serializable)((Object)link));
        if (messageBoardThread.getId() == null) {
            serviceContext.setCommand("add");
        } else {
            serviceContext.setCommand("update");
        }
        return serviceContext;
    }

    private DynamicQuery _getDynamicQuery(Date dateCreated, Date dateModified, Long messageBoardSectionId) {
        DynamicQuery dynamicQuery = this._ratingsStatsLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)this.contextCompany.getCompanyId()));
        if (dateCreated != null) {
            dynamicQuery.add(RestrictionsFactoryUtil.gt((String)"createDate", (Object)dateCreated));
        }
        if (dateModified != null) {
            dynamicQuery.add(RestrictionsFactoryUtil.gt((String)"modifiedDate", (Object)dateModified));
        }
        ClassName className = this._classNameLocalService.getClassName(MBMessage.class.getName());
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)className.getClassNameId()));
        String sql = "EXISTS (select 1 from MBMessage where this_.classPK = messageId";
        if (messageBoardSectionId != null) {
            sql = sql + " AND categoryId = " + messageBoardSectionId;
        }
        sql = sql + " AND parentMessageId = 0 AND status = 0)";
        dynamicQuery.add(RestrictionsFactoryUtil.sqlRestriction((String)sql));
        return dynamicQuery;
    }

    private Page<MessageBoardThread> _getSiteMessageBoardThreadsPage(Map<String, Map<String, String>> actions, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Long siteId, Aggregation aggregation, Filter filter, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)filter, (String)MBMessage.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, (Sort[])sorts, document -> this._toMessageBoardThread(this._mbMessageService.getMessage(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(MBMessage.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> {
            MBMessage mbMessage = this._mbMessageService.getMessage(ratingsEntry.getClassPK());
            return RatingUtil.toRating(HashMapBuilder.put((Object)"create", this.addAction("VIEW", (GroupedModel)mbMessage, "postMessageBoardThreadMyRating")).put((Object)"delete", this.addAction("VIEW", (GroupedModel)mbMessage, "deleteMessageBoardThreadMyRating")).put((Object)"get", this.addAction("VIEW", (GroupedModel)mbMessage, "getMessageBoardThreadMyRating")).put((Object)"replace", this.addAction("VIEW", (GroupedModel)mbMessage, "putMessageBoardThreadMyRating")).build(), this._portal, ratingsEntry, this._userLocalService);
        }, this.contextUser);
    }

    private MessageBoardThread _toMessageBoardThread(MBMessage mbMessage) throws Exception {
        return this._toMessageBoardThread(mbMessage.getThread());
    }

    private MessageBoardThread _toMessageBoardThread(MBThread mbThread) throws Exception {
        MBMessage mbMessage = this._mbMessageLocalService.getMessage(mbThread.getRootMessageId());
        MessageBoardThreadModelResourcePermission modelResourcePermission = new MessageBoardThreadModelResourcePermission(mbMessage, MBMessage.class.getName());
        return (MessageBoardThread)this._messageBoardThreadDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", mbMessage.getThreadId(), "deleteMessageBoardThread", modelResourcePermission)).put((Object)"get", this.addAction("VIEW", mbMessage.getThreadId(), "getMessageBoardThread", modelResourcePermission)).put((Object)"replace", this.addAction("UPDATE", mbMessage.getThreadId(), "putMessageBoardThread", modelResourcePermission)).put((Object)"reply-to-thread", (Object)ActionUtil.addAction((String)"REPLY_TO_MESSAGE", MessageBoardMessageResourceImpl.class, (Long)mbMessage.getThreadId(), (String)"postMessageBoardThreadMessageBoardMessage", (Object)this.contextScopeChecker, (ModelResourcePermission)new MessageBoardThreadModelResourcePermission(mbMessage, "com.liferay.message.boards"), (UriInfo)this.contextUriInfo)).put((Object)"subscribe", this.addAction("SUBSCRIBE", mbMessage.getThreadId(), "putMessageBoardThreadSubscribe", modelResourcePermission)).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", mbMessage.getThreadId(), "putMessageBoardThreadUnsubscribe", modelResourcePermission)).build(), this._dtoConverterRegistry, (Object)mbThread.getThreadId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)mbThread);
    }

    private double _toPriority(Long siteId, String threadType) throws Exception {
        String[] priorities;
        if (threadType == null) {
            return -1.0;
        }
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)siteId);
        for (String priorityString : priorities = mbGroupServiceSettings.getPriorities(this.contextAcceptLanguage.getPreferredLanguageId())) {
            String[] parts = StringUtil.split((String)priorityString, (String)"|");
            if (!StringUtil.equalsIgnoreCase((String)parts[0], (String)threadType)) continue;
            return GetterUtil.getDouble((String)parts[2]);
        }
        throw new BadRequestException(StringBundler.concat((String[])new String[]{"Thread type \"", threadType, "\" is not available in ", Arrays.toString(this.transform(priorities, priority -> {
            String[] parts = StringUtil.split((String)priority, (String)"|");
            return parts[0];
        }, String.class))}));
    }

    private void _updateQuestion(MBMessage mbMessage, MessageBoardThread messageBoardThread) throws Exception {
        Boolean showAsQuestion = messageBoardThread.getShowAsQuestion();
        if (showAsQuestion != null) {
            this._mbThreadLocalService.updateQuestion(mbMessage.getThreadId(), showAsQuestion.booleanValue());
            MBThread mbThread = mbMessage.getThread();
            mbThread.setQuestion(showAsQuestion.booleanValue());
        }
        if (GetterUtil.getBoolean((Object)messageBoardThread.getSubscribed())) {
            this._mbMessageLocalService.subscribeMessage(mbMessage.getUserId(), mbMessage.getRootMessageId());
        }
    }

    private class MessageBoardThreadModelResourcePermission
    implements ModelResourcePermission<MBMessage> {
        private final MBMessage _mbMessage;
        private final String _name;

        public MessageBoardThreadModelResourcePermission(MBMessage mbMessage, String name) {
            this._mbMessage = mbMessage;
            this._name = name;
        }

        public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) {
        }

        public void check(PermissionChecker permissionChecker, MBMessage model, String actionId) throws PortalException {
        }

        public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) {
            return permissionChecker.hasOwnerPermission(this._mbMessage.getCompanyId(), this._name, this._mbMessage.getMessageId(), this._mbMessage.getUserId(), actionId) || permissionChecker.hasPermission(this._mbMessage.getGroupId(), this._name, this._mbMessage.getMessageId(), actionId);
        }

        public boolean contains(PermissionChecker permissionChecker, MBMessage model, String actionId) throws PortalException {
            return false;
        }

        public String getModelName() {
            return null;
        }

        public PortletResourcePermission getPortletResourcePermission() {
            return null;
        }
    }
}

