/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.headless.delivery.dto.v1_0.ContentDocument;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.OpenGraphSettings;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.dto.v1_0.PagePermission;
import com.liferay.headless.delivery.dto.v1_0.PageSettings;
import com.liferay.headless.delivery.dto.v1_0.ParentSitePage;
import com.liferay.headless.delivery.dto.v1_0.SEOSettings;
import com.liferay.headless.delivery.dto.v1_0.Settings;
import com.liferay.headless.delivery.dto.v1_0.SiteMapSettings;
import com.liferay.headless.delivery.dto.v1_0.SitePage;
import com.liferay.headless.delivery.dto.v1_0.SitePageNavigationMenuSettings;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryReference;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.SitePageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseSitePageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.SitePageResource;
import com.liferay.layout.helper.LayoutCopyHelper;
import com.liferay.layout.importer.LayoutsImporter;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.theme.ThemeUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.processor.SegmentsExperienceRequestProcessorRegistry;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.service.SegmentsExperienceService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/site-page.properties"}, scope=ServiceScope.PROTOTYPE, service={SitePageResource.class})
public class SitePageResourceImpl
extends BaseSitePageResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(SitePageResourceImpl.class);
    private static final EntityModel _entityModel = new SitePageEntityModel();
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutSEOEntryService _layoutSEOEntryService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private LayoutsImporter _layoutsImporter;
    @Reference
    private Portal _portal;
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private SegmentsEntryRetriever _segmentsEntryRetriever;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private SegmentsExperienceRequestProcessorRegistry _segmentsExperienceRequestProcessorRegistry;
    @Reference
    private SegmentsExperienceService _segmentsExperienceService;
    @Reference(target="(component.name=com.liferay.headless.delivery.internal.dto.v1_0.converter.SitePageDTOConverter)")
    private DTOConverter<Layout, SitePage> _sitePageDTOConverter;
    @Reference
    private TeamLocalService _teamLocalService;

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public SitePage getSiteSitePage(Long siteId, String friendlyUrlPath) throws Exception {
        return this._toSitePage(true, this._getLayout(siteId, friendlyUrlPath), null);
    }

    @Override
    public SitePage getSiteSitePageExperienceExperienceKey(Long siteId, String friendlyUrlPath, String experienceKey) throws Exception {
        return this._toSitePage(true, this._getLayout(siteId, friendlyUrlPath), experienceKey);
    }

    @Override
    public String getSiteSitePageExperienceExperienceKeyRenderedPage(Long siteId, String friendlyUrlPath, String experienceKey) throws Exception {
        return this._toHTML(friendlyUrlPath, siteId, experienceKey);
    }

    @Override
    public String getSiteSitePageRenderedPage(Long siteId, String friendlyUrlPath) throws Exception {
        return this._toHTML(friendlyUrlPath, siteId, null);
    }

    @Override
    public Page<SitePage> getSiteSitePagesExperiencesPage(Long siteId, String friendlyUrlPath) throws Exception {
        Layout layout = this._getLayout(siteId, friendlyUrlPath);
        return Page.of(this.transform(this._getSegmentsExperiences(layout), segmentsExperience -> this._toSitePage(this._isEmbeddedPageDefinition(), layout, segmentsExperience.getSegmentsExperienceKey())));
    }

    @Override
    public Page<SitePage> getSiteSitePagesPage(Long siteId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"get", (Object)HashMapBuilder.put((Object)"href", (Object)JaxRsLinkUtil.getJaxRsLink((String)"headless-delivery", BaseSitePageResourceImpl.class, (String)"getSiteSitePagesPage", (UriInfo)this.contextUriInfo, (Object[])new Object[]{siteId})).put((Object)"method", (Object)"GET").build()).build(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)Layout.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("title", (Serializable)((Object)search));
            searchContext.setAttribute("type", (Serializable)new String[]{"collection", "content", "embedded", "link_to_layout", "full_page_application", "panel", "portlet", "url"});
            searchContext.setAttribute("privateLayout", (Serializable)((Object)Boolean.FALSE.toString()));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
            searchContext.setKeywords(search);
        }, (Sort[])sorts, document -> {
            long plid = GetterUtil.getLong((String)document.get("entryClassPK"));
            return this._toSitePage(this._isEmbeddedPageDefinition(), this._layoutLocalService.getLayout(plid), null);
        });
    }

    @Override
    public SitePage postSiteSitePage(Long siteId, SitePage sitePage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-178052")) {
            throw new UnsupportedOperationException();
        }
        Map titleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)sitePage.getTitle(), (Map)sitePage.getTitle_i18n());
        Layout layout = this._addLayout(siteId, sitePage, titleMap, LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)sitePage.getFriendlyUrlPath(), (Map)sitePage.getFriendlyUrlPath_i18n(), (Map)titleMap));
        DefaultDTOConverterContext dtoConverterContext = new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getBasicActions(layout), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)layout.getPlid(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
        dtoConverterContext.setAttribute("embeddedPageDefinition", (Object)Boolean.TRUE);
        dtoConverterContext.setAttribute("groupId", (Object)layout.getGroupId());
        return (SitePage)this._sitePageDTOConverter.toDTO((DTOConverterContext)dtoConverterContext, (Object)layout);
    }

    private Layout _addLayout(Long siteId, SitePage sitePage, Map<Locale, String> nameMap, Map<Locale, String> friendlyUrlMap) throws Exception {
        Settings settings;
        long parentLayoutId = 0L;
        ParentSitePage parentSitePage = sitePage.getParentSitePage();
        if (parentSitePage != null) {
            Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(siteId.longValue(), false, parentSitePage.getFriendlyUrlPath());
            if (layout == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Could not find parent site page");
                }
            } else {
                parentLayoutId = layout.getLayoutId();
            }
        }
        Map titleMap = new HashMap();
        Map descriptionMap = new HashMap();
        Map keywordsMap = new HashMap();
        Map robotsMap = new HashMap();
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties();
        boolean hidden = false;
        PageSettings pageSettings = sitePage.getPageSettings();
        if (pageSettings != null) {
            SitePageNavigationMenuSettings sitePageNavigationMenuSettings;
            SEOSettings seoSettings = pageSettings.getSeoSettings();
            if (seoSettings != null) {
                titleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)seoSettings.getHtmlTitle(), (Map)seoSettings.getHtmlTitle_i18n());
                descriptionMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)seoSettings.getDescription(), (Map)seoSettings.getDescription_i18n());
                keywordsMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)seoSettings.getSeoKeywords(), (Map)seoSettings.getSeoKeywords_i18n());
                robotsMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)seoSettings.getRobots(), (Map)seoSettings.getRobots_i18n());
                SiteMapSettings siteMapSettings = seoSettings.getSiteMapSettings();
                if (siteMapSettings != null) {
                    Double pagePriority;
                    Boolean include;
                    SiteMapSettings.ChangeFrequency changeFrequency = siteMapSettings.getChangeFrequency();
                    if (changeFrequency != null) {
                        typeSettingsUnicodeProperties.setProperty("sitemap-changefreq", StringUtil.toLowerCase((String)changeFrequency.getValue()));
                    }
                    if ((include = siteMapSettings.getInclude()) != null) {
                        String siteMapInclude = "0";
                        if (include.booleanValue()) {
                            siteMapInclude = "1";
                        }
                        typeSettingsUnicodeProperties.setProperty("sitemap-include", siteMapInclude);
                    }
                    if ((pagePriority = siteMapSettings.getPagePriority()) != null) {
                        typeSettingsUnicodeProperties.setProperty("sitemap-priority", String.valueOf(pagePriority));
                    }
                }
            }
            if ((sitePageNavigationMenuSettings = pageSettings.getSitePageNavigationMenuSettings()) != null) {
                String queryString = sitePageNavigationMenuSettings.getQueryString();
                if (Validator.isNotNull((String)queryString)) {
                    typeSettingsUnicodeProperties.setProperty("query-string", queryString);
                }
                String target = sitePageNavigationMenuSettings.getTarget();
                SitePageNavigationMenuSettings.TargetType targetType = sitePageNavigationMenuSettings.getTargetType();
                if (Validator.isNotNull((String)target)) {
                    typeSettingsUnicodeProperties.setProperty("target", target);
                }
                if (targetType != null && targetType == SitePageNavigationMenuSettings.TargetType.NEW_TAB) {
                    typeSettingsUnicodeProperties.setProperty("targetType", "useNewTab");
                }
            }
            hidden = GetterUtil.getBoolean((Object)pageSettings.getHiddenFromNavigation());
        }
        ServiceContext serviceContext = this._createServiceContext(siteId, sitePage);
        Layout layout = this._layoutService.addLayout(siteId.longValue(), false, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, "content", typeSettingsUnicodeProperties.toString(), hidden, friendlyUrlMap, 0L, serviceContext);
        this._importPageDefinition(layout, sitePage.getPageDefinition(), serviceContext);
        layout = this._layoutLocalService.getLayout(layout.getPlid());
        PageDefinition pageDefinition = sitePage.getPageDefinition();
        if (pageDefinition != null && (settings = pageDefinition.getSettings()) != null) {
            layout = this._layoutsImporter.importLayoutSettings(this.contextUser.getUserId(), layout, settings.toString());
        }
        Layout draftLayout = this._updateDraftLayout(layout);
        layout.setModifiedDate(draftLayout.getModifiedDate());
        layout.setStatus(0);
        layout = this._layoutLocalService.updateLayout(layout);
        this._updateModelResourcePermissions(layout.getCompanyId(), siteId, layout.getPlid(), sitePage);
        this._updateSEOEntry(layout.getCompanyId(), siteId, layout.getLayoutId(), sitePage);
        return layout;
    }

    private ServiceContext _createServiceContext(long groupId, SitePage sitePage) {
        Long[] assetCategoryIds = null;
        if (sitePage.getTaxonomyCategoryBriefs() != null) {
            assetCategoryIds = (Long[])this.transformToArray(Arrays.asList(sitePage.getTaxonomyCategoryBriefs()), taxonomyCategoryBrief -> this._toAssetCategoryId(groupId, (TaxonomyCategoryBrief)taxonomyCategoryBrief), Long.class);
        }
        String[] assetTagNames = new String[]{};
        if (sitePage.getKeywords() != null) {
            assetTagNames = sitePage.getKeywords();
        }
        return ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).assetCategoryIds(assetCategoryIds).assetTagNames(assetTagNames).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)Layout.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])sitePage.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale())).build();
    }

    private Map<String, Map<String, String>> _getBasicActions(Layout layout) {
        return HashMapBuilder.put((Object)"get", this.addAction("VIEW", layout.getPlid(), "getSiteSitePage", null, Layout.class.getName(), layout.getGroupId())).put((Object)"get-experiences", () -> {
            if (!layout.isTypeContent()) {
                return null;
            }
            return this.addAction("VIEW", "getSiteSitePagesExperiencesPage", Group.class.getName(), layout.getGroupId());
        }).put((Object)"get-rendered-page", this.addAction("VIEW", layout.getPlid(), "getSiteSitePageRenderedPage", null, Layout.class.getName(), layout.getGroupId())).build();
    }

    private String _getDDMFormValues(PageSettings pageSettings) {
        Object[] customMetaTags = pageSettings.getCustomMetaTags();
        if (ArrayUtil.isEmpty((Object[])customMetaTags)) {
            return null;
        }
        JSONObject ddmFormValuesJSONObject = JSONUtil.put((String)"defaultLanguageId", (Object)this.contextAcceptLanguage.getPreferredLanguageId());
        JSONArray fieldValuesJSONArray = this._jsonFactory.createJSONArray();
        HashSet<String> availableLanguageIds = new HashSet<String>();
        for (Object customMetaTag : customMetaTags) {
            JSONObject fieldValueJSONObject = JSONUtil.put((String)"instanceId", (Object)StringUtil.randomString((int)8)).put("name", "property").put("value", customMetaTag.getKey());
            JSONObject nestedFieldValueJSONObject = JSONUtil.put((String)"instanceId", (Object)StringUtil.randomString((int)8)).put("name", "content");
            Map valuesMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)customMetaTag.getValue(), (Map)customMetaTag.getValue_i18n());
            JSONObject valueJSONObject = this._jsonFactory.createJSONObject();
            for (Map.Entry entry : valuesMap.entrySet()) {
                String key = LocaleUtil.toLanguageId((Locale)((Locale)entry.getKey()));
                valueJSONObject.put(key, (String)entry.getValue());
                availableLanguageIds.add(key);
            }
            nestedFieldValueJSONObject.put("value", valueJSONObject);
            JSONArray nestedFieldValuesJSONArray = JSONUtil.put((Object)nestedFieldValueJSONObject);
            fieldValueJSONObject.put("nestedFieldValues", nestedFieldValuesJSONArray);
            fieldValuesJSONArray.put(fieldValueJSONObject);
        }
        ddmFormValuesJSONObject.put("fieldValues", fieldValuesJSONArray);
        JSONArray availableLanguageIdsJSONArray = this._jsonFactory.createJSONArray();
        for (String availableLanguage : availableLanguageIds) {
            availableLanguageIdsJSONArray.put(availableLanguage);
        }
        ddmFormValuesJSONObject.put("availableLanguageIds", availableLanguageIdsJSONArray);
        return ddmFormValuesJSONObject.toString();
    }

    private long _getDDMStructurePrimaryKey(long companyId) throws Exception {
        Company company = this._companyLocalService.getCompany(companyId);
        DDMStructure ddmStructure = this._ddmStructureService.getStructure(company.getGroupId(), this._portal.getClassNameId(LayoutSEOEntry.class.getName()), "custom-meta-tags");
        return ddmStructure.getPrimaryKey();
    }

    private Map<String, Map<String, String>> _getExperienceActions(Layout layout) {
        return HashMapBuilder.put((Object)"get", this.addAction("VIEW", "getSiteSitePageExperienceExperienceKey", Group.class.getName(), layout.getGroupId())).put((Object)"get-rendered-page", this.addAction("VIEW", "getSiteSitePageExperienceExperienceKeyRenderedPage", Group.class.getName(), layout.getGroupId())).build();
    }

    private long _getFileEntryId(long contentDocumentId) {
        try {
            FileEntry fileEntry = this._dlAppService.getFileEntry(contentDocumentId);
            return fileEntry.getFileEntryId();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return 0L;
        }
    }

    private Layout _getLayout(long groupId, String friendlyUrlPath) throws Exception {
        String resourceName = ResourceActionsUtil.getCompositeModelName((String[])new String[]{Layout.class.getName(), "false"});
        if (!StringUtil.startsWith((String)friendlyUrlPath, (String)"/")) {
            friendlyUrlPath = "/" + friendlyUrlPath;
        }
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this._friendlyURLEntryLocalService.getFriendlyURLEntryLocalization(groupId, this._portal.getClassNameId(resourceName), friendlyUrlPath);
        return this._layoutLocalService.getLayout(friendlyURLEntryLocalization.getClassPK());
    }

    private SegmentsExperience _getSegmentsExperience(Layout layout, String segmentsExperienceKey) throws Exception {
        if (Validator.isNull((String)segmentsExperienceKey)) {
            return this._getUserSegmentsExperience(layout);
        }
        return this._segmentsExperienceService.fetchSegmentsExperience(layout.getGroupId(), segmentsExperienceKey, layout.getPlid());
    }

    private List<SegmentsExperience> _getSegmentsExperiences(Layout layout) throws Exception {
        if (!layout.isTypeContent()) {
            return Collections.emptyList();
        }
        return this._segmentsExperienceLocalService.getSegmentsExperiences(layout.getGroupId(), layout.getPlid(), true);
    }

    private ThemeDisplay _getThemeDisplay(Layout layout) throws Exception {
        ServicePreAction servicePreAction = new ServicePreAction();
        DummyHttpServletResponse httpServletResponse = new DummyHttpServletResponse();
        servicePreAction.servicePre(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse, false);
        ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
        themeServicePreAction.run(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setLayout(layout);
        themeDisplay.setResponse((HttpServletResponse)httpServletResponse);
        themeDisplay.setScopeGroupId(layout.getGroupId());
        themeDisplay.setSiteGroupId(layout.getGroupId());
        return themeDisplay;
    }

    private SegmentsExperience _getUserSegmentsExperience(Layout layout) throws Exception {
        this.contextHttpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)this._getThemeDisplay(layout));
        long[] segmentsEntryIds = this._segmentsEntryRetriever.getSegmentsEntryIds(layout.getGroupId(), this.contextUser.getUserId(), this._requestContextMapper.map(this.contextHttpServletRequest));
        long[] segmentsExperienceIds = this._segmentsExperienceRequestProcessorRegistry.getSegmentsExperienceIds(this.contextHttpServletRequest, null, layout.getGroupId(), layout.getPlid(), segmentsEntryIds);
        if (ArrayUtil.isEmpty((long[])segmentsExperienceIds)) {
            return this._segmentsExperienceLocalService.fetchSegmentsExperience(layout.getGroupId(), "DEFAULT", layout.getPlid());
        }
        return this._segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceIds[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _importPageDefinition(Layout layout, PageDefinition pageDefinition, ServiceContext serviceContext) throws Exception {
        if (pageDefinition == null) {
            return;
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getDefaultSegmentsExperienceData());
        PageElement pageElement = pageDefinition.getPageElement();
        if (layoutStructure == null || pageElement == null) {
            return;
        }
        this.contextHttpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)this._getThemeDisplay(layout));
        serviceContext.setRequest(this.contextHttpServletRequest);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            this._layoutsImporter.importPageElement(layout, layoutStructure, layoutStructure.getMainItemId(), pageElement.toString(), 0);
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private boolean _isEmbeddedPageDefinition() {
        MultivaluedMap queryParameters = this.contextUriInfo.getQueryParameters();
        String nestedFields = (String)queryParameters.getFirst((Object)"nestedFields");
        if (nestedFields == null) {
            return false;
        }
        return nestedFields.contains("pageDefinition");
    }

    private Long _toAssetCategoryId(long groupId, TaxonomyCategoryBrief taxonomyCategoryBrief) {
        AssetCategory assetCategory;
        TaxonomyCategoryReference taxonomyCategoryReference = taxonomyCategoryBrief.getTaxonomyCategoryReference();
        if (taxonomyCategoryReference == null) {
            return null;
        }
        long assetCategoryGroupId = groupId;
        String siteKey = taxonomyCategoryReference.getSiteKey();
        if (siteKey != null) {
            Group group = this._groupLocalService.fetchGroup(this.contextCompany.getCompanyId(), siteKey);
            if (group == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"No group exists with company ID ", this.contextCompany.getCompanyId(), " and site key ", siteKey}));
                }
                return null;
            }
            assetCategoryGroupId = group.getGroupId();
        }
        if ((assetCategory = this._assetCategoryLocalService.fetchAssetCategoryByExternalReferenceCode(taxonomyCategoryReference.getExternalReferenceCode(), assetCategoryGroupId)) == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"No asset category exists with external reference ", "code ", taxonomyCategoryReference.getExternalReferenceCode(), " and group ID ", assetCategoryGroupId}));
            }
            return null;
        }
        return assetCategory.getCategoryId();
    }

    private String _toHTML(String friendlyUrlPath, long groupId, String segmentsExperienceKey) throws Exception {
        Layout layout = this._getLayout(groupId, friendlyUrlPath);
        this.contextHttpServletRequest = DynamicServletRequest.addQueryString((HttpServletRequest)this.contextHttpServletRequest, (String)("p_l_id=" + layout.getPlid()), (boolean)false);
        SegmentsExperience segmentsExperience = this._getSegmentsExperience(layout, segmentsExperienceKey);
        if (segmentsExperience != null) {
            this.contextHttpServletRequest.setAttribute("SEGMENTS_EXPERIENCE_IDS", (Object)new long[]{segmentsExperience.getSegmentsExperienceId()});
        }
        this.contextHttpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)this._getThemeDisplay(layout));
        ServletContext servletContext = ServletContextPool.get((String)"");
        if (this.contextHttpServletRequest.getAttribute("CTX") == null) {
            this.contextHttpServletRequest.setAttribute("CTX", (Object)servletContext);
        }
        layout.includeLayoutContent(this.contextHttpServletRequest, this.contextHttpServletResponse);
        StringBundler sb = (StringBundler)this.contextHttpServletRequest.getAttribute("LAYOUT_CONTENT");
        LayoutSet layoutSet = layout.getLayoutSet();
        Document document = Jsoup.parse((String)ThemeUtil.include((ServletContext)servletContext, (HttpServletRequest)this.contextHttpServletRequest, (HttpServletResponse)this.contextHttpServletResponse, (String)"portal_normal.ftl", (Theme)layoutSet.getTheme(), (boolean)false));
        Element bodyElement = document.body();
        bodyElement.html(sb.toString());
        return document.html();
    }

    private SitePage _toSitePage(boolean embeddedPageDefinition, Layout layout, String segmentsExperienceKey) throws Exception {
        Map<String, Map<String, String>> actions = null;
        actions = Validator.isNotNull((String)segmentsExperienceKey) ? this._getExperienceActions(layout) : this._getBasicActions(layout);
        DefaultDTOConverterContext dtoConverterContext = new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), actions, this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)layout.getPlid(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
        dtoConverterContext.setAttribute("embeddedPageDefinition", (Object)embeddedPageDefinition);
        dtoConverterContext.setAttribute("groupId", (Object)layout.getGroupId());
        if (Validator.isNotNull((String)segmentsExperienceKey)) {
            dtoConverterContext.setAttribute("segmentsExperience", (Object)this._getSegmentsExperience(layout, segmentsExperienceKey));
            dtoConverterContext.setAttribute("showExperience", (Object)Boolean.TRUE);
        } else {
            dtoConverterContext.setAttribute("segmentsExperience", (Object)this._getUserSegmentsExperience(layout));
        }
        return (SitePage)this._sitePageDTOConverter.toDTO((DTOConverterContext)dtoConverterContext, (Object)layout);
    }

    private Layout _updateDraftLayout(Layout layout) throws Exception {
        Layout draftLayout = layout.fetchDraftLayout();
        draftLayout = this._layoutCopyHelper.copyLayoutContent(layout, draftLayout);
        draftLayout.setStatus(0);
        UnicodeProperties typeSettingsUnicodeProperties = draftLayout.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.put("published", Boolean.TRUE.toString());
        draftLayout.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        return this._layoutLocalService.updateLayout(draftLayout);
    }

    private void _updateModelResourcePermissions(long companyId, long groupId, long plid, SitePage sitePage) throws Exception {
        PagePermission[] pagePermissions = sitePage.getPagePermissions();
        if (pagePermissions == null) {
            return;
        }
        HashMap<String, String[]> modelPermissionsParameterMap = new HashMap<String, String[]>(pagePermissions.length);
        for (PagePermission pagePermission : pagePermissions) {
            String roleKey = pagePermission.getRoleKey();
            Team team = this._teamLocalService.fetchTeam(groupId, roleKey);
            if (team != null) {
                roleKey = String.valueOf(team.getTeamId());
            }
            modelPermissionsParameterMap.put(roleKey, pagePermission.getActionKeys());
        }
        ModelPermissions modelPermissions = ModelPermissionsFactory.create(modelPermissionsParameterMap, null);
        this._resourcePermissionLocalService.deleteResourcePermissions(companyId, Layout.class.getName(), 4, String.valueOf(plid));
        this._resourcePermissionLocalService.addModelResourcePermissions(companyId, groupId, this.contextUser.getUserId(), Layout.class.getName(), String.valueOf(plid), modelPermissions);
    }

    private void _updateSEOEntry(long companyId, long groupId, long layoutId, SitePage sitePage) throws Exception {
        PageSettings pageSettings = sitePage.getPageSettings();
        if (pageSettings == null) {
            return;
        }
        SEOSettings seoSettings = pageSettings.getSeoSettings();
        boolean canonicalURLEnabled = false;
        Map canonicalURLMap = new HashMap();
        if (seoSettings != null && MapUtil.isNotEmpty(canonicalURLMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)seoSettings.getCustomCanonicalURL(), (Map)seoSettings.getCustomCanonicalURL_i18n()))) {
            canonicalURLEnabled = true;
        }
        boolean openGraphDescriptionEnabled = false;
        Map openGraphDescriptionMap = new HashMap();
        Map openGraphImageAltMap = new HashMap();
        long openGraphImageFileEntryId = 0L;
        boolean openGraphTitleEnabled = false;
        Map openGraphTitleMap = new HashMap();
        OpenGraphSettings openGraphSettings = pageSettings.getOpenGraphSettings();
        if (openGraphSettings != null) {
            openGraphDescriptionMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)openGraphSettings.getDescription(), (Map)openGraphSettings.getDescription_i18n());
            if (MapUtil.isNotEmpty(openGraphDescriptionMap)) {
                openGraphDescriptionEnabled = true;
            }
            openGraphImageAltMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)openGraphSettings.getImageAlt(), (Map)openGraphSettings.getImageAlt_i18n());
            ContentDocument contentDocument = openGraphSettings.getImage();
            if (contentDocument != null) {
                openGraphImageFileEntryId = this._getFileEntryId(contentDocument.getId());
            }
            if (MapUtil.isNotEmpty(openGraphTitleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)openGraphSettings.getTitle(), (Map)openGraphSettings.getTitle_i18n()))) {
                openGraphTitleEnabled = true;
            }
        }
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build();
        String ddmFormValues = this._getDDMFormValues(pageSettings);
        if (Validator.isNotNull((String)ddmFormValues)) {
            long ddmStructurePrimaryKey = this._getDDMStructurePrimaryKey(companyId);
            serviceContext.setAttribute(ddmStructurePrimaryKey + "ddmFormValues", (Serializable)((Object)ddmFormValues));
        }
        this._layoutSEOEntryService.updateLayoutSEOEntry(groupId, false, layoutId, canonicalURLEnabled, canonicalURLMap, openGraphDescriptionEnabled, openGraphDescriptionMap, openGraphImageAltMap, openGraphImageFileEntryId, openGraphTitleEnabled, openGraphTitleMap, serviceContext);
    }
}

