/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentFolder;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.StructuredContentFolderEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseStructuredContentFolderResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentFolderResource;
import com.liferay.headless.delivery.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.search.filter.FilterUtil;
import com.liferay.headless.delivery.search.sort.SortUtil;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/structured-content-folder.properties"}, scope=ServiceScope.PROTOTYPE, service={StructuredContentFolderResource.class})
public class StructuredContentFolderResourceImpl
extends BaseStructuredContentFolderResourceImpl {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference
    private JournalFolderService _journalFolderService;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference(target="(component.name=com.liferay.headless.delivery.internal.dto.v1_0.converter.StructuredContentFolderDTOConverter)")
    private DTOConverter<DLFolder, StructuredContentFolder> _structuredContentFolderDTOConverter;

    @Override
    public void deleteAssetLibraryStructuredContentFolderByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolderByExternalReferenceCode(assetLibraryId.longValue(), externalReferenceCode);
        this._journalFolderService.deleteFolder(journalFolder.getFolderId());
    }

    @Override
    public void deleteSiteStructuredContentFolderByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolderByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        this._journalFolderService.deleteFolder(journalFolder.getFolderId());
    }

    @Override
    public void deleteStructuredContentFolder(Long structuredContentFolderId) throws Exception {
        this._journalFolderService.deleteFolder(structuredContentFolderId.longValue());
    }

    @Override
    public StructuredContentFolder getAssetLibraryStructuredContentFolderByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode) throws Exception {
        return this._toStructuredContentFolder(this._journalFolderService.getFolderByExternalReferenceCode(assetLibraryId.longValue(), externalReferenceCode));
    }

    @Override
    public Page<StructuredContentFolder> getAssetLibraryStructuredContentFoldersPage(Long assetLibraryId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Long parentStructuredContentFolderId = null;
        if (!GetterUtil.getBoolean((Object)flatten)) {
            parentStructuredContentFolderId = 0L;
        }
        return this._getStructuredContentFoldersPage(HashMapBuilder.put((Object)"create", this.addAction("UPDATE", "postAssetLibraryStructuredContentFolder", "com.liferay.journal", assetLibraryId)).put((Object)"createBatch", this.addAction("UPDATE", "postAssetLibraryStructuredContentFolderBatch", "com.liferay.journal", assetLibraryId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteStructuredContentFolderBatch", "com.liferay.journal", null)).put((Object)"get", this.addAction("VIEW", "getAssetLibraryStructuredContentFoldersPage", "com.liferay.journal", assetLibraryId)).put((Object)"updateBatch", this.addAction("UPDATE", "putStructuredContentFolderBatch", "com.liferay.journal", null)).build(), parentStructuredContentFolderId, assetLibraryId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new StructuredContentFolderEntityModel(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(JournalFolder.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public StructuredContentFolder getSiteStructuredContentFolderByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        return this._toStructuredContentFolder(this._journalFolderService.getFolderByExternalReferenceCode(siteId.longValue(), externalReferenceCode));
    }

    @Override
    public Page<StructuredContentFolder> getSiteStructuredContentFoldersPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Long parentStructuredContentFolderId = null;
        if (!GetterUtil.getBoolean((Object)flatten)) {
            parentStructuredContentFolderId = 0L;
        }
        return this._getStructuredContentFoldersPage(HashMapBuilder.put((Object)"create", this.addAction("UPDATE", "postSiteStructuredContentFolder", "com.liferay.journal", siteId)).put((Object)"createBatch", this.addAction("UPDATE", "postSiteStructuredContentFolderBatch", "com.liferay.journal", siteId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteStructuredContentFolderBatch", "com.liferay.journal", null)).put((Object)"get", this.addAction("VIEW", "getSiteStructuredContentFoldersPage", "com.liferay.journal", siteId)).put((Object)"updateBatch", this.addAction("UPDATE", "putStructuredContentFolderBatch", "com.liferay.journal", null)).build(), parentStructuredContentFolderId, siteId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public StructuredContentFolder getStructuredContentFolder(Long structuredContentFolderId) throws Exception {
        return this._toStructuredContentFolder(this._journalFolderService.getFolder(structuredContentFolderId.longValue()));
    }

    @Override
    public Page<StructuredContentFolder> getStructuredContentFolderStructuredContentFoldersPage(Long parentStructuredContentFolderId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(parentStructuredContentFolderId.longValue());
        return this._getStructuredContentFoldersPage(HashMapBuilder.put((Object)"add-subfolder", this.addAction("UPDATE", (GroupedModel)journalFolder, "postStructuredContentFolderStructuredContentFolder")).put((Object)"get", this.addAction("VIEW", (GroupedModel)journalFolder, "getStructuredContentFolderStructuredContentFoldersPage")).put((Object)"subscribe", this.addAction("SUBSCRIBE", (GroupedModel)journalFolder, "putStructuredContentFolderSubscribe")).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", (GroupedModel)journalFolder, "putStructuredContentFolderUnsubscribe")).build(), parentStructuredContentFolderId, journalFolder.getGroupId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public StructuredContentFolder postAssetLibraryStructuredContentFolder(Long assetLibraryId, StructuredContentFolder structuredContentFolder) throws Exception {
        return this.postSiteStructuredContentFolder(assetLibraryId, structuredContentFolder);
    }

    @Override
    public StructuredContentFolder postSiteStructuredContentFolder(Long siteId, StructuredContentFolder structuredContentFolder) throws Exception {
        return this._addStructuredContentFolder(structuredContentFolder.getExternalReferenceCode(), siteId, 0L, structuredContentFolder);
    }

    @Override
    public StructuredContentFolder postStructuredContentFolderStructuredContentFolder(Long parentStructuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(parentStructuredContentFolderId.longValue());
        return this._addStructuredContentFolder(structuredContentFolder.getExternalReferenceCode(), journalFolder.getGroupId(), parentStructuredContentFolderId, structuredContentFolder);
    }

    @Override
    public StructuredContentFolder putAssetLibraryStructuredContentFolderByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode, StructuredContentFolder structuredContentFolder) throws Exception {
        JournalFolder journalFolder = this._journalFolderLocalService.fetchJournalFolderByExternalReferenceCode(externalReferenceCode, assetLibraryId.longValue());
        if (journalFolder != null) {
            return this._updateStructuredContentFolder(assetLibraryId, journalFolder.getFolderId(), journalFolder.getParentFolderId(), structuredContentFolder);
        }
        return this._addStructuredContentFolder(externalReferenceCode, assetLibraryId, structuredContentFolder.getParentStructuredContentFolderId(), structuredContentFolder);
    }

    @Override
    public StructuredContentFolder putSiteStructuredContentFolderByExternalReferenceCode(Long siteId, String externalReferenceCode, StructuredContentFolder structuredContentFolder) throws Exception {
        JournalFolder journalFolder = this._journalFolderLocalService.fetchJournalFolderByExternalReferenceCode(externalReferenceCode, siteId.longValue());
        if (journalFolder != null) {
            return this._updateStructuredContentFolder(siteId, journalFolder.getFolderId(), journalFolder.getParentFolderId(), structuredContentFolder);
        }
        return this._addStructuredContentFolder(externalReferenceCode, siteId, structuredContentFolder.getParentStructuredContentFolderId(), structuredContentFolder);
    }

    @Override
    public StructuredContentFolder putStructuredContentFolder(Long structuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(structuredContentFolderId.longValue());
        return this._toStructuredContentFolder(this._journalFolderService.updateFolder(journalFolder.getGroupId(), structuredContentFolderId.longValue(), journalFolder.getParentFolderId(), structuredContentFolder.getName(), structuredContentFolder.getDescription(), false, this._createServiceContext(journalFolder.getGroupId(), structuredContentFolder)));
    }

    @Override
    public void putStructuredContentFolderSubscribe(Long structuredContentFolderId) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(structuredContentFolderId.longValue());
        this._journalFolderService.subscribe(journalFolder.getGroupId(), journalFolder.getFolderId());
    }

    @Override
    public void putStructuredContentFolderUnsubscribe(Long structuredContentFolderId) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(structuredContentFolderId.longValue());
        this._journalFolderService.unsubscribe(journalFolder.getGroupId(), journalFolder.getFolderId());
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(((Long)id).longValue());
        return journalFolder.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.journal";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return JournalFolder.class.getName();
    }

    private StructuredContentFolder _addStructuredContentFolder(String externalReferenceCode, Long siteId, Long parentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        if (parentFolderId == null) {
            parentFolderId = 0L;
        }
        return this._toStructuredContentFolder(this._journalFolderService.addFolder(externalReferenceCode, siteId.longValue(), parentFolderId.longValue(), structuredContentFolder.getName(), structuredContentFolder.getDescription(), this._createServiceContext(siteId, structuredContentFolder)));
    }

    private ServiceContext _createServiceContext(long groupId, StructuredContentFolder structuredContentFolder) {
        return ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)structuredContentFolder.getViewableByAsString()).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)JournalFolder.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])structuredContentFolder.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale())).build();
    }

    private Page<StructuredContentFolder> _getStructuredContentFoldersPage(Map<String, Map<String, String>> actions, Long parentStructuredContentFolderId, Long siteId, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQuery -> {
            if (parentStructuredContentFolderId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(parentStructuredContentFolderId)), BooleanClauseOccur.MUST);
            }
        }, (Filter)FilterUtil.processFilter((DDMIndexer)this._ddmIndexer, (Filter)filter), (String)JournalFolder.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation((Aggregations)this._aggregations, (DDMIndexer)this._ddmIndexer, (Queries)this._queries, (SearchRequestBuilder)searchRequestBuilder, (Aggregation)aggregation);
            SortUtil.processSorts((DDMIndexer)this._ddmIndexer, (SearchRequestBuilder)searchRequestBuilder, (Sort[])searchContext.getSorts(), (Queries)this._queries, (Sorts)this._sorts);
        }, (Sort[])sorts, document -> this._toStructuredContentFolder(this._journalFolderService.getFolder(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private StructuredContentFolder _toStructuredContentFolder(JournalFolder journalFolder) throws Exception {
        return (StructuredContentFolder)this._structuredContentFolderDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"add-subfolder", this.addAction("UPDATE", (GroupedModel)journalFolder, "postStructuredContentFolderStructuredContentFolder")).put((Object)"delete", this.addAction("DELETE", (GroupedModel)journalFolder, "deleteStructuredContentFolder")).put((Object)"get", this.addAction("VIEW", (GroupedModel)journalFolder, "getStructuredContentFolder")).put((Object)"replace", this.addAction("UPDATE", (GroupedModel)journalFolder, "putStructuredContentFolder")).put((Object)"subscribe", this.addAction("SUBSCRIBE", (GroupedModel)journalFolder, "putStructuredContentFolderSubscribe")).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", (GroupedModel)journalFolder, "putStructuredContentFolderUnsubscribe")).build(), this._dtoConverterRegistry, (Object)journalFolder.getFolderId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private StructuredContentFolder _updateStructuredContentFolder(Long siteId, Long folderId, Long parentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        return this._toStructuredContentFolder(this._journalFolderService.updateFolder(siteId.longValue(), folderId.longValue(), parentFolderId.longValue(), structuredContentFolder.getName(), structuredContentFolder.getDescription(), false, this._createServiceContext(siteId, structuredContentFolder)));
    }
}

