/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.WikiPageAttachment;
import com.liferay.headless.delivery.dto.v1_0.util.ContentValueUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseWikiPageAttachmentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.WikiPageAttachmentResource;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageService;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/wiki-page-attachment.properties"}, scope=ServiceScope.PROTOTYPE, service={WikiPageAttachmentResource.class})
public class WikiPageAttachmentResourceImpl
extends BaseWikiPageAttachmentResourceImpl {
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private ModelResourcePermission<WikiPage> _wikiPageModelResourcePermission;
    @Reference
    private WikiPageService _wikiPageService;

    @Override
    public void deleteSiteWikiPageByExternalReferenceCodeWikiPageExternalReferenceCodeWikiPageAttachmentByExternalReferenceCode(Long siteId, String wikiPageExternalReferenceCode, String externalReferenceCode) throws Exception {
        WikiPage wikiPage = this._wikiPageService.getLatestPageByExternalReferenceCode(siteId.longValue(), wikiPageExternalReferenceCode);
        FileEntry fileEntry = wikiPage.getAttachmentsFileEntryByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        this._portletFileRepository.deletePortletFileEntry(fileEntry.getFileEntryId());
    }

    @Override
    public void deleteWikiPageAttachment(Long wikiPageAttachmentId) throws Exception {
        this._portletFileRepository.deletePortletFileEntry(wikiPageAttachmentId.longValue());
    }

    @Override
    public WikiPageAttachment getSiteWikiPageByExternalReferenceCodeWikiPageExternalReferenceCodeWikiPageAttachmentByExternalReferenceCode(Long siteId, String wikiPageExternalReferenceCode, String externalReferenceCode) throws Exception {
        WikiPage wikiPage = this._wikiPageService.getLatestPageByExternalReferenceCode(siteId.longValue(), wikiPageExternalReferenceCode);
        FileEntry fileEntry = wikiPage.getAttachmentsFileEntryByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        return this._toWikiPageAttachment(fileEntry);
    }

    @Override
    public WikiPageAttachment getWikiPageAttachment(Long wikiPageAttachmentId) throws Exception {
        return this._toWikiPageAttachment(this._portletFileRepository.getPortletFileEntry(wikiPageAttachmentId.longValue()));
    }

    @Override
    public Page<WikiPageAttachment> getWikiPageWikiPageAttachmentsPage(Long wikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageService.getPage(wikiPageId.longValue());
        return Page.of((Map)HashMapBuilder.put((Object)"createBatch", this.addAction("UPDATE", "postWikiPageWikiPageAttachmentBatch", WikiPage.class.getName(), wikiPageId)).build(), this.transform(wikiPage.getAttachmentsFileEntries(), this::_toWikiPageAttachment));
    }

    @Override
    public WikiPageAttachment postWikiPageWikiPageAttachment(Long wikiPageId, MultipartBody multipartBody) throws Exception {
        WikiPage wikiPage = this._wikiPageService.getPage(wikiPageId.longValue());
        this._wikiPageModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)wikiPage, "UPDATE");
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("No file found in body");
        }
        String externalReferenceCode = null;
        WikiPageAttachment wikiPageAttachment = (WikiPageAttachment)multipartBody.getValueAsNullableInstance("wikiPageAttachment", WikiPageAttachment.class);
        if (wikiPageAttachment != null) {
            externalReferenceCode = wikiPageAttachment.getExternalReferenceCode();
        }
        Folder folder = wikiPage.addAttachmentsFolder();
        return this._toWikiPageAttachment(this._portletFileRepository.addPortletFileEntry(externalReferenceCode, wikiPage.getGroupId(), this.contextUser.getUserId(), WikiPage.class.getName(), wikiPage.getResourcePrimKey(), "com.liferay.wiki", folder.getFolderId(), binaryFile.getInputStream(), binaryFile.getFileName(), binaryFile.getContentType(), true));
    }

    private WikiPageAttachment _toWikiPageAttachment(final FileEntry fileEntry) throws Exception {
        return new WikiPageAttachment(){
            {
                this.contentUrl = WikiPageAttachmentResourceImpl.this._portletFileRepository.getPortletFileEntryURL(null, fileEntry, null);
                this.contentValue = ContentValueUtil.toContentValue((String)"contentValue", () -> ((FileEntry)fileEntry).getContentStream(), (UriInfo)WikiPageAttachmentResourceImpl.this.contextUriInfo);
                this.encodingFormat = fileEntry.getMimeType();
                this.externalReferenceCode = fileEntry.getExternalReferenceCode();
                this.fileExtension = fileEntry.getExtension();
                this.id = fileEntry.getFileEntryId();
                this.sizeInBytes = fileEntry.getSize();
                this.title = fileEntry.getTitle();
            }
        };
    }
}

