/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.image.finder.AMImageFinder;
import com.liferay.adaptive.media.image.finder.AMImageQueryBuilder;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslator;
import com.liferay.headless.delivery.dto.v1_0.AdaptedImage;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.Document;
import com.liferay.headless.delivery.dto.v1_0.DocumentType;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.dto.v1_0.util.ContentFieldUtil;
import com.liferay.headless.delivery.dto.v1_0.util.ContentValueUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.DisplayPageRendererUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseDocumentResourceImpl;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.layout.display.page.LayoutDisplayPageProviderTracker;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={DocumentDTOConverter.class, DTOConverter.class})
public class DocumentDTOConverter
implements DTOConverter<DLFileEntry, Document> {
    @Reference
    private AMImageFinder _amImageFinder;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DDMBeanTranslator _ddmBeanTranslator;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private LayoutDisplayPageProviderTracker _layoutDisplayPageProviderTracker;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return Document.class.getSimpleName();
    }

    public Document toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final FileEntry fileEntry = this._dlAppService.getFileEntry(((Long)dtoConverterContext.getId()).longValue());
        final FileVersion fileVersion = fileEntry.getFileVersion();
        final Group group = this._groupLocalService.fetchGroup(fileEntry.getGroupId());
        return new Document(){
            {
                this.actions = dtoConverterContext.getActions();
                this.adaptedImages = DocumentDTOConverter.this._getAdaptiveMedias(dtoConverterContext, fileEntry);
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(DocumentDTOConverter.this._ratingsStatsLocalService.fetchStats(DLFileEntry.class.getName(), fileEntry.getFileEntryId()));
                this.assetLibraryKey = GroupUtil.getAssetLibraryKey((Group)group);
                this.contentUrl = DocumentDTOConverter.this._dlURLHelper.getPreviewURL(fileEntry, fileVersion, null, "");
                this.contentValue = ContentValueUtil.toContentValue((String)"contentValue", () -> ((FileEntry)fileEntry).getContentStream(), (Optional)dtoConverterContext.getUriInfoOptional());
                this.creator = CreatorUtil.toCreator((Portal)DocumentDTOConverter.this._portal, (Optional)dtoConverterContext.getUriInfoOptional(), (User)DocumentDTOConverter.this._userLocalService.fetchUser(fileEntry.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)DLFileEntry.class.getName(), (long)fileVersion.getFileVersionId(), (long)fileEntry.getCompanyId(), (Locale)dtoConverterContext.getLocale());
                this.dateCreated = fileEntry.getCreateDate();
                this.dateModified = fileEntry.getModifiedDate();
                this.description = fileEntry.getDescription();
                this.documentFolderId = fileEntry.getFolderId();
                this.documentType = DocumentDTOConverter.this._toDocumentType(dtoConverterContext, fileVersion);
                this.encodingFormat = fileEntry.getMimeType();
                this.externalReferenceCode = fileEntry.getExternalReferenceCode();
                this.fileExtension = fileEntry.getExtension();
                this.id = fileEntry.getFileEntryId();
                this.keywords = (String[])ListUtil.toArray((List)DocumentDTOConverter.this._assetTagLocalService.getTags(DLFileEntry.class.getName(), fileEntry.getFileEntryId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfComments = DocumentDTOConverter.this._commentManager.getCommentsCount(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
                this.relatedContents = RelatedContentUtil.toRelatedContents(DocumentDTOConverter.this._assetEntryLocalService, DocumentDTOConverter.this._assetLinkLocalService, dtoConverterContext.getDTOConverterRegistry(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), dtoConverterContext.getLocale());
                this.siteId = GroupUtil.getSiteId((Group)group);
                this.sizeInBytes = fileEntry.getSize();
                this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)DocumentDTOConverter.this._assetCategoryLocalService.getCategories(DLFileEntry.class.getName(), fileEntry.getFileEntryId()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, dtoConverterContext), TaxonomyCategoryBrief.class);
                this.title = fileEntry.getTitle();
                this.setRenderedContents(() -> DisplayPageRendererUtil.getRenderedContent(BaseDocumentResourceImpl.class, FileEntry.class.getName(), fileEntry.getFileEntryId(), DocumentDTOConverter.this._getDDMStructureId(fileEntry), dtoConverterContext, fileEntry.getGroupId(), fileEntry, DocumentDTOConverter.this._infoItemServiceTracker, DocumentDTOConverter.this._layoutDisplayPageProviderTracker, DocumentDTOConverter.this._layoutLocalService, DocumentDTOConverter.this._layoutPageTemplateEntryService, "getDocumentRenderedContentByDisplayPageDisplayPageKey"));
            }
        };
    }

    private AdaptedImage[] _getAdaptiveMedias(DTOConverterContext dtoConverterContext, FileEntry fileEntry) throws Exception {
        if (!this._amImageMimeTypeProvider.isMimeTypeSupported(fileEntry.getMimeType())) {
            return new AdaptedImage[0];
        }
        Stream adaptiveMediaStream = this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileEntry(fileEntry).withConfigurationStatus(AMImageQueryBuilder.ConfigurationStatus.ANY).done());
        List adaptiveMedias = adaptiveMediaStream.collect(Collectors.toList());
        return (AdaptedImage[])TransformUtil.transformToArray(adaptiveMedias, adaptiveMedia -> this._toAdaptedImage((AdaptiveMedia<AMImageProcessor>)adaptiveMedia, dtoConverterContext.getUriInfoOptional()), AdaptedImage.class);
    }

    private List<DDMFormValues> _getDDMFormValues(DLFileEntryType dlFileEntryType, DLFileVersion dlFileVersion) throws Exception {
        ArrayList<DDMFormValues> ddmFormValues = new ArrayList<DDMFormValues>();
        for (DDMStructure ddmStructure : dlFileEntryType.getDDMStructures()) {
            DLFileEntryMetadata dlFileEntryMetadata = this._dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), dlFileVersion.getFileVersionId());
            if (dlFileEntryMetadata == null) continue;
            ddmFormValues.add(this._ddmBeanTranslator.translate(StorageEngineManagerUtil.getDDMFormValues((long)dlFileEntryMetadata.getDDMStorageId())));
        }
        return ddmFormValues;
    }

    private long _getDDMStructureId(FileEntry fileEntry) throws Exception {
        if (!(fileEntry.getModel() instanceof DLFileEntry)) {
            return 0L;
        }
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.fetchDLFileEntryType(dlFileEntry.getFileEntryTypeId());
        if (dlFileEntryType == null || dlFileEntryType.getDataDefinitionId() == 0L) {
            return 0L;
        }
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureService.getStructure(dlFileEntryType.getDataDefinitionId());
        return ddmStructure.getStructureId();
    }

    private <T, S> T _getValue(AdaptiveMedia<S> adaptiveMedia, AMAttribute<S, T> amAttribute) {
        Optional valueOptional = adaptiveMedia.getValueOptional(amAttribute);
        return valueOptional.orElse(null);
    }

    private AdaptedImage _toAdaptedImage(final AdaptiveMedia<AMImageProcessor> adaptiveMedia, final Optional<UriInfo> uriInfoOptional) throws Exception {
        if (adaptiveMedia == null) {
            return null;
        }
        return new AdaptedImage(){
            {
                this.contentUrl = String.valueOf(adaptiveMedia.getURI());
                this.contentValue = ContentValueUtil.toContentValue((String)"adaptedImages.contentValue", () -> ((AdaptiveMedia)adaptiveMedia).getInputStream(), (Optional)uriInfoOptional);
                this.height = (Integer)DocumentDTOConverter.this._getValue(adaptiveMedia, AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT);
                this.resolutionName = (String)DocumentDTOConverter.this._getValue(adaptiveMedia, AMAttribute.getConfigurationUuidAMAttribute());
                this.sizeInBytes = (Long)DocumentDTOConverter.this._getValue(adaptiveMedia, AMAttribute.getContentLengthAMAttribute());
                this.width = (Integer)DocumentDTOConverter.this._getValue(adaptiveMedia, AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH);
            }
        };
    }

    private DocumentType _toDocumentType(final DTOConverterContext dtoConverterContext, FileVersion fileVersion) throws Exception {
        if (!(fileVersion.getModel() instanceof DLFileVersion)) {
            return null;
        }
        DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
        final DLFileEntryType dlFileEntryType = dlFileVersion.getDLFileEntryType();
        final List<DDMFormValues> ddmFormValues = this._getDDMFormValues(dlFileEntryType, dlFileVersion);
        return new DocumentType(){
            {
                this.description = dlFileEntryType.getDescription(dtoConverterContext.getLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)dlFileEntryType.getDescriptionMap());
                this.name = dlFileEntryType.getName(dtoConverterContext.getLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)dlFileEntryType.getNameMap());
                this.setAvailableLanguages(() -> {
                    HashSet locales = new HashSet();
                    for (DDMFormValues ddmFormValue : ddmFormValues) {
                        locales.addAll(ddmFormValue.getAvailableLocales());
                    }
                    return LocaleUtil.toW3cLanguageIds((Locale[])locales.toArray(new Locale[0]));
                });
                this.setContentFields(() -> {
                    ArrayList ddmFormFieldValues = new ArrayList();
                    for (DDMFormValues ddmFormValue : ddmFormValues) {
                        ddmFormFieldValues.addAll(ddmFormValue.getDDMFormFieldValues());
                    }
                    return (ContentField[])TransformUtil.transformToArray(ddmFormFieldValues, ddmFormFieldValue -> ContentFieldUtil.toContentField((DDMFormFieldValue)ddmFormFieldValue, (DLAppService)DocumentDTOConverter.this._dlAppService, (DLURLHelper)DocumentDTOConverter.this._dlURLHelper, (DTOConverterContext)dtoConverterContext, (JournalArticleService)DocumentDTOConverter.this._journalArticleService, (LayoutLocalService)DocumentDTOConverter.this._layoutLocalService), ContentField.class);
                });
            }
        };
    }
}

