/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.RenderedContent;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.dto.v1_0.util.ContentFieldUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.DisplayPageRendererUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RenderedContentValueUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseStructuredContentResourceImpl;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalConverter;
import com.liferay.layout.display.page.LayoutDisplayPageProviderTracker;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.journal.model.JournalArticle"}, service={DTOConverter.class, StructuredContentDTOConverter.class})
public class StructuredContentDTOConverter
implements DTOConverter<JournalArticle, StructuredContent> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private LayoutDisplayPageProviderTracker _layoutDisplayPageProviderTracker;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return StructuredContent.class.getSimpleName();
    }

    public StructuredContent toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(((Long)dtoConverterContext.getId()).longValue());
        return this.toDTO(dtoConverterContext, journalArticle);
    }

    public StructuredContent toDTO(final DTOConverterContext dtoConverterContext, final JournalArticle journalArticle) throws Exception {
        final DDMStructure ddmStructure = journalArticle.getDDMStructure();
        final Group group = this._groupLocalService.fetchGroup(journalArticle.getGroupId());
        return new StructuredContent(){
            {
                this.actions = dtoConverterContext.getActions();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(StructuredContentDTOConverter.this._ratingsStatsLocalService.fetchStats(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()));
                this.assetLibraryKey = GroupUtil.getAssetLibraryKey((Group)group);
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])journalArticle.getAvailableLanguageIds());
                this.contentFields = StructuredContentDTOConverter.this._toContentFields(StructuredContentDTOConverter.this._dlAppService, StructuredContentDTOConverter.this._dlURLHelper, dtoConverterContext, StructuredContentDTOConverter.this._fieldsToDDMFormValuesConverter, journalArticle, StructuredContentDTOConverter.this._journalArticleService, StructuredContentDTOConverter.this._journalConverter, StructuredContentDTOConverter.this._layoutLocalService);
                this.contentStructureId = ddmStructure.getStructureId();
                this.creator = CreatorUtil.toCreator((Portal)StructuredContentDTOConverter.this._portal, (Optional)dtoConverterContext.getUriInfoOptional(), (User)StructuredContentDTOConverter.this._userLocalService.fetchUser(journalArticle.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)JournalArticle.class.getName(), (long)journalArticle.getId(), (long)journalArticle.getCompanyId(), (Locale)dtoConverterContext.getLocale());
                this.dateCreated = journalArticle.getCreateDate();
                this.dateModified = journalArticle.getModifiedDate();
                this.datePublished = journalArticle.getDisplayDate();
                this.description = journalArticle.getDescription(dtoConverterContext.getLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)StructuredContentDTOConverter.this._filterDescriptionMap(journalArticle.getDescriptionMap()));
                this.externalReferenceCode = journalArticle.getExternalReferenceCode();
                this.friendlyUrlPath = journalArticle.getUrlTitle(dtoConverterContext.getLocale());
                this.friendlyUrlPath_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)journalArticle.getFriendlyURLMap());
                this.id = journalArticle.getResourcePrimKey();
                this.key = journalArticle.getArticleId();
                this.keywords = (String[])ListUtil.toArray((List)StructuredContentDTOConverter.this._assetTagLocalService.getTags(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfComments = StructuredContentDTOConverter.this._commentManager.getCommentsCount(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
                this.relatedContents = RelatedContentUtil.toRelatedContents(StructuredContentDTOConverter.this._assetEntryLocalService, StructuredContentDTOConverter.this._assetLinkLocalService, dtoConverterContext.getDTOConverterRegistry(), JournalArticle.class.getName(), journalArticle.getResourcePrimKey(), dtoConverterContext.getLocale());
                this.renderedContents = StructuredContentDTOConverter.this._toRenderedContents(ddmStructure, dtoConverterContext, journalArticle);
                this.siteId = GroupUtil.getSiteId((Group)group);
                this.subscribed = StructuredContentDTOConverter.this._subscriptionLocalService.isSubscribed(journalArticle.getCompanyId(), dtoConverterContext.getUserId(), JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
                this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)StructuredContentDTOConverter.this._assetCategoryLocalService.getCategories(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, dtoConverterContext), TaxonomyCategoryBrief.class);
                this.title = journalArticle.getTitle(dtoConverterContext.getLocale());
                this.title_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)journalArticle.getTitleMap());
                this.uuid = journalArticle.getUuid();
            }
        };
    }

    private Map<Locale, String> _filterDescriptionMap(Map<Locale, String> descriptionMap) {
        Set<Map.Entry<Locale, String>> set = descriptionMap.entrySet();
        Stream stream = set.stream();
        return stream.filter(entry -> !"".equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private ContentField[] _toContentFields(DLAppService dlAppService, DLURLHelper dlURLHelper, DTOConverterContext dtoConverterContext, FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter, JournalArticle journalArticle, JournalArticleService journalArticleService, JournalConverter journalConverter, LayoutLocalService layoutLocalService) throws Exception {
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        Fields fields = journalConverter.getDDMFields(ddmStructure, journalArticle.getContent());
        DDMFormValues ddmFormValues = fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
        return (ContentField[])TransformUtil.transformToArray((Collection)ddmFormValues.getDDMFormFieldValues(), ddmFormFieldValue -> ContentFieldUtil.toContentField((DDMFormFieldValue)ddmFormFieldValue, (DLAppService)dlAppService, (DLURLHelper)dlURLHelper, (DTOConverterContext)dtoConverterContext, (JournalArticleService)journalArticleService, (LayoutLocalService)layoutLocalService), ContentField.class);
    }

    private RenderedContent[] _toRenderedContents(DDMStructure ddmStructure, DTOConverterContext dtoConverterContext, JournalArticle journalArticle) {
        Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
        if (!uriInfoOptional.isPresent()) {
            return null;
        }
        boolean acceptAllLanguages = dtoConverterContext.isAcceptAllLanguages();
        HttpServletRequest httpServletRequest = dtoConverterContext.getHttpServletRequest();
        Locale locale = dtoConverterContext.getLocale();
        UriInfo uriInfo = (UriInfo)uriInfoOptional.get();
        Object[] renderedContents = (RenderedContent[])TransformUtil.transformToArray((Collection)ddmStructure.getTemplates(), ddmTemplate -> new RenderedContent((DDMTemplate)ddmTemplate, locale, acceptAllLanguages, uriInfo, journalArticle, uriInfoOptional, httpServletRequest){
            final /* synthetic */ DDMTemplate val$ddmTemplate;
            final /* synthetic */ Locale val$locale;
            final /* synthetic */ boolean val$acceptAllLanguages;
            final /* synthetic */ UriInfo val$uriInfo;
            final /* synthetic */ JournalArticle val$journalArticle;
            final /* synthetic */ Optional val$uriInfoOptional;
            final /* synthetic */ HttpServletRequest val$httpServletRequest;
            {
                this.val$ddmTemplate = dDMTemplate;
                this.val$locale = locale;
                this.val$acceptAllLanguages = bl;
                this.val$uriInfo = uriInfo;
                this.val$journalArticle = journalArticle;
                this.val$uriInfoOptional = optional;
                this.val$httpServletRequest = httpServletRequest;
                this.contentTemplateId = this.val$ddmTemplate.getTemplateKey();
                this.contentTemplateName = this.val$ddmTemplate.getName(this.val$locale);
                this.contentTemplateName_i18n = LocalizedMapUtil.getI18nMap((boolean)this.val$acceptAllLanguages, (Map)this.val$ddmTemplate.getNameMap());
                this.renderedContentURL = JaxRsLinkUtil.getJaxRsLink((String)"headless-delivery", BaseStructuredContentResourceImpl.class, (String)"getStructuredContentRenderedContentTemplate", (UriInfo)this.val$uriInfo, (Object[])new Object[]{this.val$journalArticle.getResourcePrimKey(), this.val$ddmTemplate.getTemplateKey()});
                this.setMarkedAsDefault(() -> {
                    if (Objects.equals(this.val$ddmTemplate.getTemplateKey(), this.val$journalArticle.getDDMTemplateKey())) {
                        return true;
                    }
                    return false;
                });
                this.setRenderedContentValue(() -> {
                    if (!this.val$uriInfoOptional.map(UriInfo::getQueryParameters).map(parameters -> (String)parameters.getFirst((Object)"nestedFields")).map(fields -> fields.contains("renderedContentValue")).orElse(false).booleanValue()) {
                        return null;
                    }
                    return RenderedContentValueUtil.renderTemplate(StructuredContentDTOConverter.this._classNameLocalService, StructuredContentDTOConverter.this._ddmTemplateLocalService, StructuredContentDTOConverter.this._groupLocalService, this.val$httpServletRequest, StructuredContentDTOConverter.this._journalArticleService, StructuredContentDTOConverter.this._journalContent, this.val$locale, this.val$journalArticle.getResourcePrimKey(), this.val$ddmTemplate.getTemplateKey(), this.val$uriInfo);
                });
            }
        }, RenderedContent.class);
        Object[] displayPagesRenderedContents = DisplayPageRendererUtil.getRenderedContent(BaseStructuredContentResourceImpl.class, JournalArticle.class.getName(), journalArticle.getResourcePrimKey(), ddmStructure.getStructureId(), dtoConverterContext, journalArticle.getGroupId(), journalArticle, this._infoItemServiceTracker, this._layoutDisplayPageProviderTracker, this._layoutLocalService, this._layoutPageTemplateEntryService, "getStructuredContentRenderedContentByDisplayPageDisplayPageKey");
        return (RenderedContent[])ArrayUtil.append((Object[])renderedContents, (Object[])displayPagesRenderedContents);
    }
}

