/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.headless.delivery.dto.v1_0.FragmentImage;
import com.liferay.headless.delivery.dto.v1_0.FragmentInlineValue;
import com.liferay.headless.delivery.dto.v1_0.FragmentMappedValue;
import com.liferay.headless.delivery.dto.v1_0.FragmentStyle;
import com.liferay.headless.delivery.dto.v1_0.FragmentViewport;
import com.liferay.headless.delivery.dto.v1_0.FragmentViewportStyle;
import com.liferay.headless.delivery.dto.v1_0.Mapping;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.FragmentMappedValueUtil;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.function.Function;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseStyledLayoutStructureItemMapper
implements LayoutStructureItemMapper {
    @Reference
    protected InfoItemServiceTracker infoItemServiceTracker;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(BaseStyledLayoutStructureItemMapper.class);

    protected FragmentViewport[] getFragmentViewPorts(JSONObject jsonObject) {
        FragmentViewport tabletFragmentViewportStyle;
        FragmentViewport portraitMobileFragmentViewportStyle;
        if (jsonObject == null || jsonObject.length() == 0) {
            return null;
        }
        ArrayList<FragmentViewport> fragmentViewports = new ArrayList<FragmentViewport>();
        FragmentViewport mobileLandscapeFragmentViewportStyle = this._toFragmentViewportStyle(jsonObject, ViewportSize.MOBILE_LANDSCAPE);
        if (mobileLandscapeFragmentViewportStyle != null) {
            fragmentViewports.add(mobileLandscapeFragmentViewportStyle);
        }
        if ((portraitMobileFragmentViewportStyle = this._toFragmentViewportStyle(jsonObject, ViewportSize.PORTRAIT_MOBILE)) != null) {
            fragmentViewports.add(portraitMobileFragmentViewportStyle);
        }
        if ((tabletFragmentViewportStyle = this._toFragmentViewportStyle(jsonObject, ViewportSize.TABLET)) != null) {
            fragmentViewports.add(tabletFragmentViewportStyle);
        }
        if (ListUtil.isEmpty(fragmentViewports)) {
            return null;
        }
        return fragmentViewports.toArray(new FragmentViewport[0]);
    }

    protected Function<Object, String> getImageURLTransformerFunction() {
        return object -> {
            if (object instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)object;
                return jsonObject.getString("url");
            }
            if (object instanceof String) {
                return (String)object;
            }
            return "";
        };
    }

    protected FragmentImage toBackgroundFragmentImage(final JSONObject jsonObject, final boolean saveMappingConfiguration) {
        if (jsonObject == null) {
            return null;
        }
        final String urlValue = jsonObject.getString("url");
        return new FragmentImage(){
            {
                this.title = BaseStyledLayoutStructureItemMapper.this.toTitleFragmentInlineValue(jsonObject, urlValue);
                this.setUrl(() -> {
                    if (FragmentMappedValueUtil.isSaveFragmentMappedValue(jsonObject, saveMappingConfiguration)) {
                        return BaseStyledLayoutStructureItemMapper.this.toFragmentMappedValue(BaseStyledLayoutStructureItemMapper.this.toDefaultMappingValue(jsonObject, BaseStyledLayoutStructureItemMapper.this.getImageURLTransformerFunction()), jsonObject);
                    }
                    if (Validator.isNull((String)urlValue)) {
                        return null;
                    }
                    return new FragmentInlineValue(){
                        {
                            this.value = urlValue;
                        }
                    };
                });
            }
        };
    }

    protected FragmentInlineValue toDefaultMappingValue(JSONObject jsonObject, Function<Object, String> transformerFunction) {
        String className;
        block11: {
            long classNameId = jsonObject.getLong("classNameId");
            if (classNameId == 0L) {
                return null;
            }
            className = null;
            try {
                className = this.portal.getClassName(classNameId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block11;
                _log.warn((Object)"Unable to get class name for default mapping value", (Throwable)exception);
            }
        }
        if (Validator.isNull((String)className)) {
            return null;
        }
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this.infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className);
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this.infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, className);
        if (infoItemFieldValuesProvider == null || infoItemObjectProvider == null) {
            return null;
        }
        long classPK = jsonObject.getLong("classPK");
        try {
            String valueString;
            Object infoItem = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
            if (infoItem == null) {
                return null;
            }
            InfoFieldValue infoFieldValue = infoItemFieldValuesProvider.getInfoFieldValue(infoItem, jsonObject.getString("fieldId"));
            if (infoFieldValue == null) {
                return null;
            }
            Object infoFieldValueValue = infoFieldValue.getValue(LocaleUtil.getMostRelevantLocale());
            if (transformerFunction != null) {
                infoFieldValueValue = transformerFunction.apply(infoFieldValueValue);
            }
            if (Validator.isNull((String)(valueString = GetterUtil.getString((Object)infoFieldValueValue)))) {
                return null;
            }
            return new FragmentInlineValue(){
                {
                    this.value = valueString;
                }
            };
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get default mapped value", (Throwable)exception);
            return null;
        }
    }

    protected FragmentMappedValue toFragmentMappedValue(final FragmentInlineValue fragmentInlineValue, final JSONObject jsonObject) {
        return new FragmentMappedValue(){
            {
                this.mapping = new Mapping(){
                    {
                        defaultFragmentInlineValue = fragmentInlineValue;
                        this.fieldKey = FragmentMappedValueUtil.getFieldKey(jsonObject);
                        this.itemReference = FragmentMappedValueUtil.toItemReference(jsonObject);
                    }
                };
            }
        };
    }

    protected FragmentStyle toFragmentStyle(final JSONObject jsonObject, final boolean saveMappingConfiguration) {
        if (jsonObject == null || jsonObject.length() == 0) {
            return null;
        }
        return new FragmentStyle(){
            {
                this.backgroundColor = jsonObject.getString("backgroundColor", null);
                this.borderColor = jsonObject.getString("borderColor", null);
                this.borderRadius = jsonObject.getString("borderRadius", null);
                this.borderWidth = jsonObject.getString("borderWidth", null);
                this.fontFamily = jsonObject.getString("fontFamily", null);
                this.fontSize = jsonObject.getString("fontSize", null);
                this.fontWeight = jsonObject.getString("fontWeight", null);
                this.height = jsonObject.getString("height", null);
                this.marginBottom = jsonObject.getString("marginBottom", null);
                this.marginLeft = jsonObject.getString("marginLeft", null);
                this.marginRight = jsonObject.getString("marginRight", null);
                this.marginTop = jsonObject.getString("marginTop", null);
                this.maxHeight = jsonObject.getString("maxHeight", null);
                this.maxWidth = jsonObject.getString("maxWidth", null);
                this.minHeight = jsonObject.getString("minHeight", null);
                this.minWidth = jsonObject.getString("minWidth", null);
                this.opacity = jsonObject.getString("opacity", null);
                this.overflow = jsonObject.getString("overflow", null);
                this.paddingBottom = jsonObject.getString("paddingBottom", null);
                this.paddingLeft = jsonObject.getString("paddingLeft", null);
                this.paddingRight = jsonObject.getString("paddingRight", null);
                this.paddingTop = jsonObject.getString("paddingTop", null);
                this.shadow = jsonObject.getString("shadow", null);
                this.textAlign = jsonObject.getString("textAlign", null);
                this.textColor = jsonObject.getString("textColor", null);
                this.width = jsonObject.getString("width", null);
                this.setBackgroundFragmentImage(() -> {
                    Object backgroundImage = jsonObject.get("backgroundImage");
                    if (backgroundImage == null) {
                        return null;
                    }
                    JSONObject backgroundImageJSONObject = (JSONObject)backgroundImage;
                    return BaseStyledLayoutStructureItemMapper.this.toBackgroundFragmentImage(backgroundImageJSONObject, saveMappingConfiguration);
                });
            }
        };
    }

    protected FragmentInlineValue toTitleFragmentInlineValue(JSONObject jsonObject, String urlValue) {
        final String title = jsonObject.getString("title");
        if (Validator.isNull((String)title) || title.equals(urlValue)) {
            return null;
        }
        return new FragmentInlineValue(){
            {
                this.value = title;
            }
        };
    }

    private FragmentViewport _toFragmentViewportStyle(JSONObject jsonObject, final ViewportSize viewportSize) {
        JSONObject viewportJSONObject = jsonObject.getJSONObject(viewportSize.getViewportSizeId());
        if (viewportJSONObject == null || viewportJSONObject.length() == 0) {
            return null;
        }
        final JSONObject styleJSONObject = viewportJSONObject.getJSONObject("styles");
        if (styleJSONObject == null || styleJSONObject.length() == 0) {
            return null;
        }
        return new FragmentViewport(){
            {
                this.setId(viewportSize.getViewportSizeId());
                this.setFragmentViewportStyle(() -> new FragmentViewportStyle(){
                    {
                        this.marginBottom = styleJSONObject.getString("marginBottom", null);
                        this.marginLeft = styleJSONObject.getString("marginLeft", null);
                        this.marginRight = styleJSONObject.getString("marginRight", null);
                        this.marginTop = styleJSONObject.getString("marginTop", null);
                        this.paddingBottom = styleJSONObject.getString("paddingBottom", null);
                        this.paddingLeft = styleJSONObject.getString("paddingLeft", null);
                        this.paddingRight = styleJSONObject.getString("paddingRight", null);
                        this.paddingTop = styleJSONObject.getString("paddingTop", null);
                    }
                });
            }
        };
    }
}

