/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.headless.delivery.dto.v1_0.ClassNameReference;
import com.liferay.headless.delivery.dto.v1_0.ClassPKReference;
import com.liferay.headless.delivery.dto.v1_0.CollectionConfig;
import com.liferay.headless.delivery.dto.v1_0.PageCollectionDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.BaseStyledLayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.info.list.provider.item.selector.criterion.InfoListProviderItemSelectorReturnType;
import com.liferay.item.selector.criteria.InfoListItemSelectorReturnType;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;

@Component(service={LayoutStructureItemMapper.class})
public class CollectionLayoutStructureItemMapper
extends BaseStyledLayoutStructureItemMapper {
    @Override
    public String getClassName() {
        return CollectionStyledLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(long groupId, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, final boolean saveMappingConfiguration) {
        final CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem = (CollectionStyledLayoutStructureItem)layoutStructureItem;
        return new PageElement(){
            {
                this.definition = new PageCollectionDefinition(){
                    {
                        this.collectionConfig = CollectionLayoutStructureItemMapper.this._getCollectionConfig(collectionStyledLayoutStructureItem);
                        this.listItemStyle = collectionStyledLayoutStructureItem.getListItemStyle();
                        this.listStyle = collectionStyledLayoutStructureItem.getListStyle();
                        this.numberOfColumns = collectionStyledLayoutStructureItem.getNumberOfColumns();
                        this.numberOfItems = collectionStyledLayoutStructureItem.getNumberOfItems();
                        this.numberOfItemsPerPage = collectionStyledLayoutStructureItem.getNumberOfItemsPerPage();
                        this.paginationType = CollectionLayoutStructureItemMapper.this._getPaginationType(collectionStyledLayoutStructureItem.getPaginationType());
                        this.templateKey = collectionStyledLayoutStructureItem.getTemplateKey();
                        this.setFragmentStyle(() -> {
                            JSONObject itemConfigJSONObject = collectionStyledLayoutStructureItem.getItemConfigJSONObject();
                            return CollectionLayoutStructureItemMapper.this.toFragmentStyle(itemConfigJSONObject.getJSONObject("styles"), saveMappingConfiguration);
                        });
                        this.setFragmentViewports(() -> {
                            JSONObject itemConfigJSONObject = collectionStyledLayoutStructureItem.getItemConfigJSONObject();
                            return CollectionLayoutStructureItemMapper.this.getFragmentViewPorts(itemConfigJSONObject);
                        });
                    }
                };
                this.type = PageElement.Type.COLLECTION;
            }
        };
    }

    private CollectionConfig _getCollectionConfig(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        final JSONObject jsonObject = collectionStyledLayoutStructureItem.getCollectionJSONObject();
        if (jsonObject == null) {
            return null;
        }
        String type = jsonObject.getString("type");
        if (Validator.isNull((String)type)) {
            return null;
        }
        if (Objects.equals(type, InfoListItemSelectorReturnType.class.getName())) {
            return new CollectionConfig(){
                {
                    this.collectionReference = new ClassPKReference(){
                        {
                            this.className = CollectionLayoutStructureItemMapper.this.portal.getClassName((long)jsonObject.getInt("classNameId"));
                            this.classPK = jsonObject.getLong("classPK");
                        }
                    };
                    this.collectionType = CollectionConfig.CollectionType.COLLECTION;
                }
            };
        }
        if (Objects.equals(type, InfoListProviderItemSelectorReturnType.class.getName())) {
            return new CollectionConfig(){
                {
                    this.collectionReference = new ClassNameReference(){
                        {
                            this.className = jsonObject.getString("key");
                        }
                    };
                    this.collectionType = CollectionConfig.CollectionType.COLLECTION_PROVIDER;
                }
            };
        }
        return null;
    }

    private PageCollectionDefinition.PaginationType _getPaginationType(String paginationType) {
        if (Validator.isNull((String)paginationType)) {
            return null;
        }
        if (Objects.equals(paginationType, "none")) {
            return PageCollectionDefinition.PaginationType.NONE;
        }
        if (Objects.equals(paginationType, "regular")) {
            return PageCollectionDefinition.PaginationType.REGULAR;
        }
        if (Objects.equals(paginationType, "simple")) {
            return PageCollectionDefinition.PaginationType.SIMPLE;
        }
        return null;
    }
}

