/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.headless.delivery.dto.v1_0.ColumnViewport;
import com.liferay.headless.delivery.dto.v1_0.ColumnViewportDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageColumnDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(service={LayoutStructureItemMapper.class})
public class ColumnLayoutStructureItemMapper
implements LayoutStructureItemMapper {
    @Override
    public String getClassName() {
        return ColumnLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(long groupId, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, boolean saveMappingConfiguration) {
        final ColumnLayoutStructureItem columnLayoutStructureItem = (ColumnLayoutStructureItem)layoutStructureItem;
        return new PageElement(){
            {
                this.definition = new PageColumnDefinition(){
                    {
                        this.size = columnLayoutStructureItem.getSize();
                        this.setColumnViewports(() -> {
                            Map columnViewportConfigurations = columnLayoutStructureItem.getViewportConfigurations();
                            if (MapUtil.isEmpty((Map)columnViewportConfigurations)) {
                                return null;
                            }
                            ColumnViewport[] columnViewports = new ColumnViewport[]{ColumnLayoutStructureItemMapper.this._toColumnViewport(columnViewportConfigurations, ViewportSize.MOBILE_LANDSCAPE), ColumnLayoutStructureItemMapper.this._toColumnViewport(columnViewportConfigurations, ViewportSize.PORTRAIT_MOBILE), ColumnLayoutStructureItemMapper.this._toColumnViewport(columnViewportConfigurations, ViewportSize.TABLET)};
                            return columnViewports;
                        });
                    }
                };
                this.type = PageElement.Type.COLUMN;
            }
        };
    }

    private ColumnViewport _toColumnViewport(final Map<String, JSONObject> columnViewportConfigurationsMap, final ViewportSize viewportSize) {
        return new ColumnViewport(){
            {
                this.columnViewportDefinition = ColumnLayoutStructureItemMapper.this._toColumnViewportColumnViewportDefinition(columnViewportConfigurationsMap, viewportSize);
                this.id = viewportSize.getViewportSizeId();
            }
        };
    }

    private ColumnViewportDefinition _toColumnViewportColumnViewportDefinition(Map<String, JSONObject> columnViewportConfigurationsMap, ViewportSize viewportSize) {
        if (!columnViewportConfigurationsMap.containsKey(viewportSize.getViewportSizeId())) {
            return null;
        }
        final JSONObject jsonObject = columnViewportConfigurationsMap.get(viewportSize.getViewportSizeId());
        return new ColumnViewportDefinition(){
            {
                this.setSize(() -> {
                    if (!jsonObject.has("size")) {
                        return null;
                    }
                    return jsonObject.getInt("size");
                });
            }
        };
    }
}

