/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.headless.delivery.dto.v1_0.FragmentInlineValue;
import com.liferay.headless.delivery.dto.v1_0.FragmentLink;
import com.liferay.headless.delivery.dto.v1_0.Layout;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.dto.v1_0.PageSectionDefinition;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.BaseStyledLayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.FragmentMappedValueUtil;
import com.liferay.layout.page.template.util.AlignConverter;
import com.liferay.layout.page.template.util.BorderRadiusConverter;
import com.liferay.layout.page.template.util.JustifyConverter;
import com.liferay.layout.page.template.util.MarginConverter;
import com.liferay.layout.page.template.util.PaddingConverter;
import com.liferay.layout.page.template.util.ShadowConverter;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;

@Component(service={LayoutStructureItemMapper.class})
public class ContainerLayoutStructureItemMapper
extends BaseStyledLayoutStructureItemMapper {
    @Override
    public String getClassName() {
        return ContainerStyledLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(long groupId, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, final boolean saveMappingConfiguration) {
        final ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem = (ContainerStyledLayoutStructureItem)layoutStructureItem;
        return new PageElement(){
            {
                this.definition = new PageSectionDefinition(){
                    {
                        this.fragmentLink = ContainerLayoutStructureItemMapper.this._toFragmentLink(containerStyledLayoutStructureItem.getLinkJSONObject(), saveMappingConfiguration);
                        this.layout = ContainerLayoutStructureItemMapper.this._toLayout(containerStyledLayoutStructureItem);
                        this.setFragmentStyle(() -> {
                            JSONObject itemConfigJSONObject = containerStyledLayoutStructureItem.getItemConfigJSONObject();
                            return ContainerLayoutStructureItemMapper.this.toFragmentStyle(itemConfigJSONObject.getJSONObject("styles"), saveMappingConfiguration);
                        });
                        this.setFragmentViewports(() -> {
                            JSONObject itemConfigJSONObject = containerStyledLayoutStructureItem.getItemConfigJSONObject();
                            return ContainerLayoutStructureItemMapper.this.getFragmentViewPorts(itemConfigJSONObject);
                        });
                    }
                };
                this.type = PageElement.Type.SECTION;
            }
        };
    }

    private FragmentLink _toFragmentLink(final JSONObject jsonObject, boolean saveMapping) {
        if (jsonObject == null) {
            return null;
        }
        final boolean saveFragmentMappedValue = FragmentMappedValueUtil.isSaveFragmentMappedValue(jsonObject, saveMapping);
        if (jsonObject.isNull("href") && !saveFragmentMappedValue) {
            return null;
        }
        return new FragmentLink(){
            {
                this.setHref(() -> {
                    if (saveFragmentMappedValue) {
                        return ContainerLayoutStructureItemMapper.this.toFragmentMappedValue(ContainerLayoutStructureItemMapper.this.toDefaultMappingValue(jsonObject, null), jsonObject);
                    }
                    return new FragmentInlineValue(){
                        {
                            this.value = jsonObject.getString("href");
                        }
                    };
                });
                this.setTarget(() -> {
                    String target = jsonObject.getString("target");
                    if (Validator.isNull((String)target)) {
                        return null;
                    }
                    if (StringUtil.equalsIgnoreCase((String)target, (String)"_parent") || StringUtil.equalsIgnoreCase((String)target, (String)"_top")) {
                        target = "_self";
                    }
                    return FragmentLink.Target.create((String)StringUtil.upperCaseFirstLetter((String)target.substring(1)));
                });
            }
        };
    }

    private Layout _toLayout(final ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem) {
        return new Layout(){
            {
                this.align = Layout.Align.create((String)AlignConverter.convertToExternalValue((String)containerStyledLayoutStructureItem.getAlign()));
                this.borderRadius = Layout.BorderRadius.create((String)BorderRadiusConverter.convertToExternalValue((String)containerStyledLayoutStructureItem.getBorderRadius()));
                this.justify = Layout.Justify.create((String)JustifyConverter.convertToExternalValue((String)containerStyledLayoutStructureItem.getJustify()));
                this.shadow = Layout.Shadow.create((String)ShadowConverter.convertToExternalValue((String)containerStyledLayoutStructureItem.getShadow()));
                this.setBorderColor(() -> {
                    String borderColor = containerStyledLayoutStructureItem.getBorderColor();
                    if (Validator.isNull((String)borderColor)) {
                        return null;
                    }
                    return borderColor;
                });
                this.setBorderWidth(() -> {
                    String borderWidth = containerStyledLayoutStructureItem.getBorderWidth();
                    if (Validator.isNull((String)borderWidth)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)borderWidth);
                });
                this.setContentDisplay(() -> {
                    String contentDisplay = containerStyledLayoutStructureItem.getContentDisplay();
                    if (Validator.isNull((String)contentDisplay)) {
                        return null;
                    }
                    return Layout.ContentDisplay.create((String)StringUtil.upperCaseFirstLetter((String)contentDisplay));
                });
                this.setMarginBottom(() -> {
                    String marginBottom = containerStyledLayoutStructureItem.getMarginBottom();
                    if (Validator.isNull((String)marginBottom)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)MarginConverter.convertToExternalValue((String)marginBottom));
                });
                this.setMarginLeft(() -> {
                    String marginLeft = containerStyledLayoutStructureItem.getMarginLeft();
                    if (Validator.isNull((String)marginLeft)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)MarginConverter.convertToExternalValue((String)marginLeft));
                });
                this.setMarginRight(() -> {
                    String marginRight = containerStyledLayoutStructureItem.getMarginRight();
                    if (Validator.isNull((String)marginRight)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)MarginConverter.convertToExternalValue((String)marginRight));
                });
                this.setMarginTop(() -> {
                    String marginTop = containerStyledLayoutStructureItem.getMarginTop();
                    if (Validator.isNull((String)marginTop)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)MarginConverter.convertToExternalValue((String)marginTop));
                });
                this.setOpacity(() -> {
                    String opacity = containerStyledLayoutStructureItem.getOpacity();
                    if (Validator.isNull((String)opacity)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)opacity, (int)100);
                });
                this.setPaddingBottom(() -> {
                    String paddingBottom = containerStyledLayoutStructureItem.getPaddingBottom();
                    if (Validator.isNull((String)paddingBottom)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)PaddingConverter.convertToExternalValue((String)paddingBottom));
                });
                this.setPaddingLeft(() -> {
                    String paddingLeft = containerStyledLayoutStructureItem.getPaddingLeft();
                    if (Validator.isNull((String)paddingLeft)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)PaddingConverter.convertToExternalValue((String)paddingLeft));
                });
                this.setPaddingRight(() -> {
                    String paddingRight = containerStyledLayoutStructureItem.getPaddingRight();
                    if (Validator.isNull((String)paddingRight)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)PaddingConverter.convertToExternalValue((String)paddingRight));
                });
                this.setPaddingTop(() -> {
                    String paddingTop = containerStyledLayoutStructureItem.getPaddingTop();
                    if (Validator.isNull((String)paddingTop)) {
                        return null;
                    }
                    return GetterUtil.getInteger((String)PaddingConverter.convertToExternalValue((String)paddingTop));
                });
                this.setWidthType(() -> {
                    String widthType = containerStyledLayoutStructureItem.getWidthType();
                    if (Validator.isNotNull((String)widthType)) {
                        return Layout.WidthType.create((String)StringUtil.upperCaseFirstLetter((String)widthType));
                    }
                    String containerType = containerStyledLayoutStructureItem.getContainerType();
                    if (Validator.isNotNull((String)containerType)) {
                        return Layout.WidthType.create((String)StringUtil.upperCaseFirstLetter((String)containerType));
                    }
                    return null;
                });
            }
        };
    }
}

