/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.headless.delivery.dto.v1_0.Fragment;
import com.liferay.headless.delivery.dto.v1_0.PageDropZoneDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.layout.util.structure.DropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureItemMapper.class})
public class DropZoneLayoutStructureItemMapper
implements LayoutStructureItemMapper {
    @Reference
    private FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentRendererTracker _fragmentRendererTracker;

    @Override
    public String getClassName() {
        return DropZoneLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(final long groupId, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, boolean saveMappingConfiguration) {
        final DropZoneLayoutStructureItem dropZoneLayoutStructureItem = (DropZoneLayoutStructureItem)layoutStructureItem;
        return new PageElement(){
            {
                this.definition = new PageDropZoneDefinition(){
                    {
                        this.fragmentSettings = DropZoneLayoutStructureItemMapper.this._toFragmentSettingsMap(dropZoneLayoutStructureItem, groupId);
                    }
                };
                this.type = PageElement.Type.DROP_ZONE;
            }
        };
    }

    private boolean _isFragmentEntryKey(String fragmentEntryKey, long groupId) {
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(groupId, fragmentEntryKey);
        if (fragmentEntry != null) {
            return true;
        }
        fragmentEntry = this._fragmentCollectionContributorTracker.getFragmentEntry(fragmentEntryKey);
        if (fragmentEntry != null) {
            return true;
        }
        FragmentRenderer fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer(fragmentEntryKey);
        return fragmentRenderer != null;
    }

    private Fragment[] _toFragments(List<String> fragmentEntryKeys, long groupId) {
        ArrayList<2> fragments = new ArrayList<2>();
        for (final String fragmentEntryKey : fragmentEntryKeys) {
            if (!this._isFragmentEntryKey(fragmentEntryKey, groupId)) continue;
            fragments.add(new Fragment(){
                {
                    this.key = fragmentEntryKey;
                }
            });
        }
        return fragments.toArray(new Fragment[0]);
    }

    private Map<String, Fragment[]> _toFragmentSettingsMap(DropZoneLayoutStructureItem dropZoneLayoutStructureItem, long groupId) {
        if (dropZoneLayoutStructureItem.isAllowNewFragmentEntries()) {
            return HashMapBuilder.put((Object)"unallowedFragments", (Object)this._toFragments(dropZoneLayoutStructureItem.getFragmentEntryKeys(), groupId)).build();
        }
        return HashMapBuilder.put((Object)"allowedFragments", (Object)this._toFragments(dropZoneLayoutStructureItem.getFragmentEntryKeys(), groupId)).build();
    }
}

