/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.dto.v1_0.PageRowDefinition;
import com.liferay.headless.delivery.dto.v1_0.RowViewport;
import com.liferay.headless.delivery.dto.v1_0.RowViewportDefinition;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.BaseStyledLayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(service={LayoutStructureItemMapper.class})
public class RowLayoutStructureItemMapper
extends BaseStyledLayoutStructureItemMapper {
    @Override
    public String getClassName() {
        return RowStyledLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(long groupId, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, final boolean saveMappingConfiguration) {
        final RowStyledLayoutStructureItem rowStyledLayoutStructureItem = (RowStyledLayoutStructureItem)layoutStructureItem;
        return new PageElement(){
            {
                this.definition = new PageRowDefinition(){
                    {
                        this.gutters = rowStyledLayoutStructureItem.isGutters();
                        this.modulesPerRow = rowStyledLayoutStructureItem.getModulesPerRow();
                        this.numberOfColumns = rowStyledLayoutStructureItem.getNumberOfColumns();
                        this.reverseOrder = rowStyledLayoutStructureItem.isReverseOrder();
                        this.verticalAlignment = rowStyledLayoutStructureItem.getVerticalAlignment();
                        this.setFragmentStyle(() -> {
                            JSONObject itemConfigJSONObject = rowStyledLayoutStructureItem.getItemConfigJSONObject();
                            return RowLayoutStructureItemMapper.this.toFragmentStyle(itemConfigJSONObject.getJSONObject("styles"), saveMappingConfiguration);
                        });
                        this.setFragmentViewports(() -> {
                            JSONObject itemConfigJSONObject = rowStyledLayoutStructureItem.getItemConfigJSONObject();
                            return RowLayoutStructureItemMapper.this.getFragmentViewPorts(itemConfigJSONObject);
                        });
                        this.setRowViewports(() -> {
                            final Map rowViewportConfigurations = rowStyledLayoutStructureItem.getViewportConfigurations();
                            if (MapUtil.isEmpty((Map)rowViewportConfigurations)) {
                                return null;
                            }
                            ArrayList<RowViewport> rowViewports = new ArrayList<RowViewport>(){
                                {
                                    this.add(RowLayoutStructureItemMapper.this._toRowViewport(rowViewportConfigurations, ViewportSize.MOBILE_LANDSCAPE));
                                    this.add(RowLayoutStructureItemMapper.this._toRowViewport(rowViewportConfigurations, ViewportSize.PORTRAIT_MOBILE));
                                    this.add(RowLayoutStructureItemMapper.this._toRowViewport(rowViewportConfigurations, ViewportSize.TABLET));
                                }
                            };
                            return rowViewports.toArray(new RowViewport[0]);
                        });
                    }
                };
                this.type = PageElement.Type.ROW;
            }
        };
    }

    private RowViewport _toRowViewport(final Map<String, JSONObject> rowViewportConfigurationsMap, final ViewportSize viewportSize) {
        return new RowViewport(){
            {
                this.id = viewportSize.getViewportSizeId();
                this.rowViewportDefinition = RowLayoutStructureItemMapper.this._toRowViewportDefinition(rowViewportConfigurationsMap, viewportSize);
            }
        };
    }

    private RowViewportDefinition _toRowViewportDefinition(Map<String, JSONObject> rowViewportConfigurations, ViewportSize viewportSize) {
        if (!rowViewportConfigurations.containsKey(viewportSize.getViewportSizeId())) {
            return null;
        }
        final JSONObject jsonObject = rowViewportConfigurations.get(viewportSize.getViewportSizeId());
        return new RowViewportDefinition(){
            {
                this.setModulesPerRow(() -> {
                    if (!jsonObject.has("modulesPerRow")) {
                        return null;
                    }
                    return jsonObject.getInt("modulesPerRow");
                });
                this.setReverseOrder(() -> {
                    if (!jsonObject.has("reverseOrder")) {
                        return null;
                    }
                    return jsonObject.getBoolean("reverseOrder");
                });
                this.setVerticalAlignment(() -> {
                    if (!jsonObject.has("verticalAlignment")) {
                        return null;
                    }
                    return jsonObject.getString("verticalAlignment");
                });
            }
        };
    }
}

