/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.Document;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.resource.v1_0.DocumentResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseDocumentResourceImpl
implements DocumentResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<Document> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/asset-libraries/{assetLibraryId}/documents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Page<Document> getAssetLibraryDocumentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"multipart/form-data"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Path(value="/asset-libraries/{assetLibraryId}/documents")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Document postAssetLibraryDocument(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/asset-libraries/{assetLibraryId}/documents/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="Document")})
    public Response postAssetLibraryDocumentBatch(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Document.class.getName(), callbackURL, null, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/asset-libraries/{assetLibraryId}/documents/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Page<Permission> getAssetLibraryDocumentPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(assetLibraryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)assetLibraryId, (Long)assetLibraryId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getAssetLibraryDocumentPermissionsPage", portletName, assetLibraryId)).put((Object)"replace", this.addAction("PERMISSIONS", "putAssetLibraryDocumentPermission", portletName, assetLibraryId)).build(), assetLibraryId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Path(value="/asset-libraries/{assetLibraryId}/documents/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="Document")})
    public Page<Permission> putAssetLibraryDocumentPermission(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(assetLibraryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)assetLibraryId, (Long)assetLibraryId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), assetLibraryId.longValue(), portletName, String.valueOf(assetLibraryId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)assetLibraryId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getAssetLibraryDocumentPermissionsPage", portletName, assetLibraryId)).put((Object)"replace", this.addAction("PERMISSIONS", "putAssetLibraryDocumentPermission", portletName, assetLibraryId)).build(), assetLibraryId, portletName, null);
    }

    @GET
    @Operation(description="Retrieves the folder's documents. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentFolderId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/document-folders/{documentFolderId}/documents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Page<Document> getDocumentFolderDocumentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="documentFolderId") Long documentFolderId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Creates a new document inside the folder identified by `documentFolderId`. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentFolderId")})
    @Path(value="/document-folders/{documentFolderId}/documents")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Document postDocumentFolderDocument(@NotNull @Parameter(hidden=true) @PathParam(value="documentFolderId") Long documentFolderId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentFolderId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/document-folders/{documentFolderId}/documents/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="Document")})
    public Response postDocumentFolderDocumentBatch(@NotNull @Parameter(hidden=true) @PathParam(value="documentFolderId") Long documentFolderId, MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Document.class.getName(), callbackURL, null, object)).build();
    }

    @DELETE
    @Operation(description="Deletes the document and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Path(value="/documents/{documentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public void deleteDocument(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/documents/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="Document")})
    public Response deleteDocumentBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(Document.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves the document.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Path(value="/documents/{documentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Document getDocument(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId) throws Exception {
        return new Document();
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @PATCH
    @Path(value="/documents/{documentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Document patchDocument(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Replaces the document with the information sent in the request body. Any missing fields are deleted, unless they are required. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Path(value="/documents/{documentId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="Document")})
    public Document putDocument(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/documents/batch")
    @Produces(value={"application/json"})
    @PUT
    @Tags(value={@Tag(name="Document")})
    public Response putDocumentBatch(MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(Document.class.getName(), callbackURL, object)).build();
    }

    @DELETE
    @Operation(description="Deletes the document's rating and returns a 204 if the operation succeeded.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Path(value="/documents/{documentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public void deleteDocumentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the document's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Path(value="/documents/{documentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Rating getDocumentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new rating for the document, by the user who authenticated the request.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Path(value="/documents/{documentId}/my-rating")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Rating postDocumentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId, Rating rating) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Path(value="/documents/{documentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="Document")})
    public Rating putDocumentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId, Rating rating) throws Exception {
        return new Rating();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/documents/{documentId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Page<Permission> getDocumentPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(documentId);
        Long resourceId = this.getPermissionCheckerResourceId(documentId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(documentId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getDocumentPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putDocumentPermission", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Path(value="/documents/{documentId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="Document")})
    public Page<Permission> putDocumentPermission(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(documentId);
        Long resourceId = this.getPermissionCheckerResourceId(documentId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(documentId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(documentId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getDocumentPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putDocumentPermission", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @GET
    @Operation(description="Retrieves the document's rendered display page")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId"), @Parameter(in=ParameterIn.PATH, name="displayPageKey")})
    @Path(value="/documents/{documentId}/rendered-content-by-display-page/{displayPageKey}")
    @Produces(value={"text/html"})
    @Tags(value={@Tag(name="Document")})
    public String getDocumentRenderedContentByDisplayPageDisplayPageKey(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId, @NotNull @Parameter(hidden=true) @PathParam(value="displayPageKey") String displayPageKey) throws Exception {
        return "";
    }

    @GET
    @Operation(description="Retrieves the documents in the site's root folder. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/documents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Page<Document> getSiteDocumentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Creates a new document. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/documents")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Document postSiteDocument(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/sites/{siteId}/documents/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="Document")})
    public Response postSiteDocumentBatch(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Document.class.getName(), callbackURL, null, object)).build();
    }

    @DELETE
    @Operation(description="Deletes the site's document by external reference code returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/sites/{siteId}/documents/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public void deleteSiteDocumentByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the site's document by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/sites/{siteId}/documents/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Document getSiteDocumentByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Document();
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Replaces the document by external reference code with the information sent in the request body, or replaces it if it not exists. Any missing fields are deleted, unless they are required. The request body must be `multipart/form-data` with two parts, the file'sbytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/sites/{siteId}/documents/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="Document")})
    public Document putSiteDocumentByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/sites/{siteId}/documents/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Document")})
    public Page<Permission> getSiteDocumentPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteDocumentPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteDocumentPermission", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/documents/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="Document")})
    public Page<Permission> putSiteDocumentPermission(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteDocumentPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteDocumentPermission", portletName, siteId)).build(), siteId, portletName, null);
    }

    public void create(Collection<Document> documents, Map<String, Serializable> parameters) throws Exception {
        for (Document document : documents) {
            this.postSiteDocument(Long.parseLong((String)((Object)parameters.get("siteId"))), null);
        }
    }

    public void delete(Collection<Document> documents, Map<String, Serializable> parameters) throws Exception {
        for (Document document : documents) {
            this.deleteDocument(document.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<Document> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getSiteDocumentsPage(Long.parseLong((String)((Object)parameters.get("siteId"))), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<Document> documents, Map<String, Serializable> parameters) throws Exception {
        for (Document document : documents) {
            this.putDocument(document.getId() != null ? document.getId() : Long.parseLong((String)((Object)parameters.get("documentId"))), null);
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

