/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseArticle;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseArticleResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseKnowledgeBaseArticleResourceImpl
implements EntityModelResource,
KnowledgeBaseArticleResource,
VulcanBatchEngineTaskItemDelegate<KnowledgeBaseArticle> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @DELETE
    @Operation(description="Deletes the knowledge base article and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public void deleteKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/knowledge-base-articles/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Response deleteKnowledgeBaseArticleBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(KnowledgeBaseArticle.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves the knowledge base article.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle getKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @PATCH
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle patchKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        KnowledgeBaseArticle existingKnowledgeBaseArticle = this.getKnowledgeBaseArticle(knowledgeBaseArticleId);
        if (knowledgeBaseArticle.getActions() != null) {
            existingKnowledgeBaseArticle.setActions(knowledgeBaseArticle.getActions());
        }
        if (knowledgeBaseArticle.getArticleBody() != null) {
            existingKnowledgeBaseArticle.setArticleBody(knowledgeBaseArticle.getArticleBody());
        }
        if (knowledgeBaseArticle.getDateCreated() != null) {
            existingKnowledgeBaseArticle.setDateCreated(knowledgeBaseArticle.getDateCreated());
        }
        if (knowledgeBaseArticle.getDateModified() != null) {
            existingKnowledgeBaseArticle.setDateModified(knowledgeBaseArticle.getDateModified());
        }
        if (knowledgeBaseArticle.getDescription() != null) {
            existingKnowledgeBaseArticle.setDescription(knowledgeBaseArticle.getDescription());
        }
        if (knowledgeBaseArticle.getEncodingFormat() != null) {
            existingKnowledgeBaseArticle.setEncodingFormat(knowledgeBaseArticle.getEncodingFormat());
        }
        if (knowledgeBaseArticle.getExternalReferenceCode() != null) {
            existingKnowledgeBaseArticle.setExternalReferenceCode(knowledgeBaseArticle.getExternalReferenceCode());
        }
        if (knowledgeBaseArticle.getFriendlyUrlPath() != null) {
            existingKnowledgeBaseArticle.setFriendlyUrlPath(knowledgeBaseArticle.getFriendlyUrlPath());
        }
        if (knowledgeBaseArticle.getKeywords() != null) {
            existingKnowledgeBaseArticle.setKeywords(knowledgeBaseArticle.getKeywords());
        }
        if (knowledgeBaseArticle.getNumberOfAttachments() != null) {
            existingKnowledgeBaseArticle.setNumberOfAttachments(knowledgeBaseArticle.getNumberOfAttachments());
        }
        if (knowledgeBaseArticle.getNumberOfKnowledgeBaseArticles() != null) {
            existingKnowledgeBaseArticle.setNumberOfKnowledgeBaseArticles(knowledgeBaseArticle.getNumberOfKnowledgeBaseArticles());
        }
        if (knowledgeBaseArticle.getParentKnowledgeBaseArticleId() != null) {
            existingKnowledgeBaseArticle.setParentKnowledgeBaseArticleId(knowledgeBaseArticle.getParentKnowledgeBaseArticleId());
        }
        if (knowledgeBaseArticle.getParentKnowledgeBaseFolderId() != null) {
            existingKnowledgeBaseArticle.setParentKnowledgeBaseFolderId(knowledgeBaseArticle.getParentKnowledgeBaseFolderId());
        }
        if (knowledgeBaseArticle.getSiteId() != null) {
            existingKnowledgeBaseArticle.setSiteId(knowledgeBaseArticle.getSiteId());
        }
        if (knowledgeBaseArticle.getSubscribed() != null) {
            existingKnowledgeBaseArticle.setSubscribed(knowledgeBaseArticle.getSubscribed());
        }
        if (knowledgeBaseArticle.getTaxonomyCategoryIds() != null) {
            existingKnowledgeBaseArticle.setTaxonomyCategoryIds(knowledgeBaseArticle.getTaxonomyCategoryIds());
        }
        if (knowledgeBaseArticle.getTitle() != null) {
            existingKnowledgeBaseArticle.setTitle(knowledgeBaseArticle.getTitle());
        }
        if (knowledgeBaseArticle.getViewableBy() != null) {
            existingKnowledgeBaseArticle.setViewableBy(knowledgeBaseArticle.getViewableBy());
        }
        this.preparePatch(knowledgeBaseArticle, existingKnowledgeBaseArticle);
        return this.putKnowledgeBaseArticle(knowledgeBaseArticleId, existingKnowledgeBaseArticle);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the knowledge base article with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle putKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/knowledge-base-articles/batch")
    @Produces(value={"application/json"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Response putKnowledgeBaseArticleBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(KnowledgeBaseArticle.class.getName(), callbackURL, object)).build();
    }

    @DELETE
    @Operation(description="Deletes the knowledge base article's rating and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public void deleteKnowledgeBaseArticleMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the knowledge base article's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Rating getKnowledgeBaseArticleMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a rating for the knowledge base article.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Rating postKnowledgeBaseArticleMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, Rating rating) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Rating putKnowledgeBaseArticleMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, Rating rating) throws Exception {
        return new Rating();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<Permission> getKnowledgeBaseArticlePermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(knowledgeBaseArticleId);
        Long resourceId = this.getPermissionCheckerResourceId(knowledgeBaseArticleId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(knowledgeBaseArticleId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getKnowledgeBaseArticlePermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putKnowledgeBaseArticlePermission", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<Permission> putKnowledgeBaseArticlePermission(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(knowledgeBaseArticleId);
        Long resourceId = this.getPermissionCheckerResourceId(knowledgeBaseArticleId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(knowledgeBaseArticleId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(knowledgeBaseArticleId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getKnowledgeBaseArticlePermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putKnowledgeBaseArticlePermission", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public void putKnowledgeBaseArticleSubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public void putKnowledgeBaseArticleUnsubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the parent knowledge base article's child knowledge base articles. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseArticleId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/knowledge-base-articles/{parentKnowledgeBaseArticleId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<KnowledgeBaseArticle> getKnowledgeBaseArticleKnowledgeBaseArticlesPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentKnowledgeBaseArticleId") Long parentKnowledgeBaseArticleId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a child knowledge base article of the knowledge base article identified by `parentKnowledgeBaseArticleId`.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{parentKnowledgeBaseArticleId}/knowledge-base-articles")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle postKnowledgeBaseArticleKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="parentKnowledgeBaseArticleId") Long parentKnowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @GET
    @Operation(description="Retrieves the folder's knowledge base articles. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<KnowledgeBaseArticle> getKnowledgeBaseFolderKnowledgeBaseArticlesPage(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new knowledge base article in the folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/knowledge-base-articles")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle postKnowledgeBaseFolderKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/knowledge-base-articles/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Response postKnowledgeBaseFolderKnowledgeBaseArticleBatch(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(KnowledgeBaseArticle.class.getName(), callbackURL, null, object)).build();
    }

    @GET
    @Operation(description="Retrieves the site's knowledge base articles. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<KnowledgeBaseArticle> getSiteKnowledgeBaseArticlesPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new knowledge base article.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/knowledge-base-articles")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle postSiteKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Response postSiteKnowledgeBaseArticleBatch(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(KnowledgeBaseArticle.class.getName(), callbackURL, null, object)).build();
    }

    @DELETE
    @Operation(description="Deletes the knowledge base article by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public void deleteSiteKnowledgeBaseArticleByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the site's knowledge base article by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle getSiteKnowledgeBaseArticleByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates the site's knowledge base article with the given external reference code, or creates it if it not exists.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle putSiteKnowledgeBaseArticleByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<Permission> getSiteKnowledgeBaseArticlePermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteKnowledgeBaseArticlePermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteKnowledgeBaseArticlePermission", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<Permission> putSiteKnowledgeBaseArticlePermission(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteKnowledgeBaseArticlePermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteKnowledgeBaseArticlePermission", portletName, siteId)).build(), siteId, portletName, null);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public void putSiteKnowledgeBaseArticleSubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public void putSiteKnowledgeBaseArticleUnsubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId) throws Exception {
    }

    public void create(Collection<KnowledgeBaseArticle> knowledgeBaseArticles, Map<String, Serializable> parameters) throws Exception {
        for (KnowledgeBaseArticle knowledgeBaseArticle : knowledgeBaseArticles) {
            this.postSiteKnowledgeBaseArticle(Long.parseLong((String)((Object)parameters.get("siteId"))), knowledgeBaseArticle);
        }
    }

    public void delete(Collection<KnowledgeBaseArticle> knowledgeBaseArticles, Map<String, Serializable> parameters) throws Exception {
        for (KnowledgeBaseArticle knowledgeBaseArticle : knowledgeBaseArticles) {
            this.deleteKnowledgeBaseArticle(knowledgeBaseArticle.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<KnowledgeBaseArticle> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getSiteKnowledgeBaseArticlesPage(Long.parseLong((String)((Object)parameters.get("siteId"))), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<KnowledgeBaseArticle> knowledgeBaseArticles, Map<String, Serializable> parameters) throws Exception {
        for (KnowledgeBaseArticle knowledgeBaseArticle : knowledgeBaseArticles) {
            this.putKnowledgeBaseArticle(knowledgeBaseArticle.getId() != null ? knowledgeBaseArticle.getId() : Long.parseLong((String)((Object)parameters.get("knowledgeBaseArticleId"))), knowledgeBaseArticle);
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(KnowledgeBaseArticle knowledgeBaseArticle, KnowledgeBaseArticle existingKnowledgeBaseArticle) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

