/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseFolder;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseFolderResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseKnowledgeBaseFolderResourceImpl
implements EntityModelResource,
KnowledgeBaseFolderResource,
VulcanBatchEngineTaskItemDelegate<KnowledgeBaseFolder> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @DELETE
    @Operation(description="Deletes the knowledge base folder and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public void deleteKnowledgeBaseFolder(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/knowledge-base-folders/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public Response deleteKnowledgeBaseFolderBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(KnowledgeBaseFolder.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves the knowledge base folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public KnowledgeBaseFolder getKnowledgeBaseFolder(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @PATCH
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public KnowledgeBaseFolder patchKnowledgeBaseFolder(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        KnowledgeBaseFolder existingKnowledgeBaseFolder = this.getKnowledgeBaseFolder(knowledgeBaseFolderId);
        if (knowledgeBaseFolder.getActions() != null) {
            existingKnowledgeBaseFolder.setActions(knowledgeBaseFolder.getActions());
        }
        if (knowledgeBaseFolder.getDateCreated() != null) {
            existingKnowledgeBaseFolder.setDateCreated(knowledgeBaseFolder.getDateCreated());
        }
        if (knowledgeBaseFolder.getDateModified() != null) {
            existingKnowledgeBaseFolder.setDateModified(knowledgeBaseFolder.getDateModified());
        }
        if (knowledgeBaseFolder.getDescription() != null) {
            existingKnowledgeBaseFolder.setDescription(knowledgeBaseFolder.getDescription());
        }
        if (knowledgeBaseFolder.getExternalReferenceCode() != null) {
            existingKnowledgeBaseFolder.setExternalReferenceCode(knowledgeBaseFolder.getExternalReferenceCode());
        }
        if (knowledgeBaseFolder.getName() != null) {
            existingKnowledgeBaseFolder.setName(knowledgeBaseFolder.getName());
        }
        if (knowledgeBaseFolder.getNumberOfKnowledgeBaseArticles() != null) {
            existingKnowledgeBaseFolder.setNumberOfKnowledgeBaseArticles(knowledgeBaseFolder.getNumberOfKnowledgeBaseArticles());
        }
        if (knowledgeBaseFolder.getNumberOfKnowledgeBaseFolders() != null) {
            existingKnowledgeBaseFolder.setNumberOfKnowledgeBaseFolders(knowledgeBaseFolder.getNumberOfKnowledgeBaseFolders());
        }
        if (knowledgeBaseFolder.getParentKnowledgeBaseFolderId() != null) {
            existingKnowledgeBaseFolder.setParentKnowledgeBaseFolderId(knowledgeBaseFolder.getParentKnowledgeBaseFolderId());
        }
        if (knowledgeBaseFolder.getSiteId() != null) {
            existingKnowledgeBaseFolder.setSiteId(knowledgeBaseFolder.getSiteId());
        }
        if (knowledgeBaseFolder.getViewableBy() != null) {
            existingKnowledgeBaseFolder.setViewableBy(knowledgeBaseFolder.getViewableBy());
        }
        this.preparePatch(knowledgeBaseFolder, existingKnowledgeBaseFolder);
        return this.putKnowledgeBaseFolder(knowledgeBaseFolderId, existingKnowledgeBaseFolder);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the knowledge base folder with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public KnowledgeBaseFolder putKnowledgeBaseFolder(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/knowledge-base-folders/batch")
    @Produces(value={"application/json"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public Response putKnowledgeBaseFolderBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(KnowledgeBaseFolder.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public Page<Permission> getKnowledgeBaseFolderPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(knowledgeBaseFolderId);
        Long resourceId = this.getPermissionCheckerResourceId(knowledgeBaseFolderId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(knowledgeBaseFolderId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getKnowledgeBaseFolderPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putKnowledgeBaseFolderPermission", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public Page<Permission> putKnowledgeBaseFolderPermission(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(knowledgeBaseFolderId);
        Long resourceId = this.getPermissionCheckerResourceId(knowledgeBaseFolderId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(knowledgeBaseFolderId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(knowledgeBaseFolderId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getKnowledgeBaseFolderPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putKnowledgeBaseFolderPermission", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @GET
    @Operation(description="Retrieves the knowledge base folder's subfolders.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseFolderId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Path(value="/knowledge-base-folders/{parentKnowledgeBaseFolderId}/knowledge-base-folders")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public Page<KnowledgeBaseFolder> getKnowledgeBaseFolderKnowledgeBaseFoldersPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentKnowledgeBaseFolderId") Long parentKnowledgeBaseFolderId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a knowledge base folder inside the parent folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseFolderId")})
    @Path(value="/knowledge-base-folders/{parentKnowledgeBaseFolderId}/knowledge-base-folders")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public KnowledgeBaseFolder postKnowledgeBaseFolderKnowledgeBaseFolder(@NotNull @Parameter(hidden=true) @PathParam(value="parentKnowledgeBaseFolderId") Long parentKnowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @GET
    @Operation(description="Retrieves the site's knowledge base folders. Results can be paginated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Path(value="/sites/{siteId}/knowledge-base-folders")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public Page<KnowledgeBaseFolder> getSiteKnowledgeBaseFoldersPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new knowledge base folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/knowledge-base-folders")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public KnowledgeBaseFolder postSiteKnowledgeBaseFolder(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/sites/{siteId}/knowledge-base-folders/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public Response postSiteKnowledgeBaseFolderBatch(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(KnowledgeBaseFolder.class.getName(), callbackURL, null, object)).build();
    }

    @DELETE
    @Operation(description="Deletes the knowledge base folder by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/sites/{siteId}/knowledge-base-folders/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public void deleteSiteKnowledgeBaseFolderByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the site's knowledge base folder by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/sites/{siteId}/knowledge-base-folders/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public KnowledgeBaseFolder getSiteKnowledgeBaseFolderByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates the site's knowledge base folder with the given external reference code, or creates it if it not exists.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/sites/{siteId}/knowledge-base-folders/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public KnowledgeBaseFolder putSiteKnowledgeBaseFolderByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/sites/{siteId}/knowledge-base-folders/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public Page<Permission> getSiteKnowledgeBaseFolderPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteKnowledgeBaseFolderPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteKnowledgeBaseFolderPermission", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/knowledge-base-folders/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    public Page<Permission> putSiteKnowledgeBaseFolderPermission(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteKnowledgeBaseFolderPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteKnowledgeBaseFolderPermission", portletName, siteId)).build(), siteId, portletName, null);
    }

    public void create(Collection<KnowledgeBaseFolder> knowledgeBaseFolders, Map<String, Serializable> parameters) throws Exception {
        for (KnowledgeBaseFolder knowledgeBaseFolder : knowledgeBaseFolders) {
            this.postSiteKnowledgeBaseFolder(Long.parseLong((String)((Object)parameters.get("siteId"))), knowledgeBaseFolder);
        }
    }

    public void delete(Collection<KnowledgeBaseFolder> knowledgeBaseFolders, Map<String, Serializable> parameters) throws Exception {
        for (KnowledgeBaseFolder knowledgeBaseFolder : knowledgeBaseFolders) {
            this.deleteKnowledgeBaseFolder(knowledgeBaseFolder.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<KnowledgeBaseFolder> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getSiteKnowledgeBaseFoldersPage(Long.parseLong((String)((Object)parameters.get("siteId"))), pagination);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<KnowledgeBaseFolder> knowledgeBaseFolders, Map<String, Serializable> parameters) throws Exception {
        for (KnowledgeBaseFolder knowledgeBaseFolder : knowledgeBaseFolders) {
            this.putKnowledgeBaseFolder(knowledgeBaseFolder.getId() != null ? knowledgeBaseFolder.getId() : Long.parseLong((String)((Object)parameters.get("knowledgeBaseFolderId"))), knowledgeBaseFolder);
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(KnowledgeBaseFolder knowledgeBaseFolder, KnowledgeBaseFolder existingKnowledgeBaseFolder) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

