/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.NavigationMenu;
import com.liferay.headless.delivery.resource.v1_0.NavigationMenuResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseNavigationMenuResourceImpl
implements EntityModelResource,
NavigationMenuResource,
VulcanBatchEngineTaskItemDelegate<NavigationMenu> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @DELETE
    @Operation(description="Deletes the navigation menu and returns a 204 if the operation succeeds")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="navigationMenuId")})
    @Path(value="/navigation-menus/{navigationMenuId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="NavigationMenu")})
    public void deleteNavigationMenu(@NotNull @Parameter(hidden=true) @PathParam(value="navigationMenuId") Long navigationMenuId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/navigation-menus/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="NavigationMenu")})
    public Response deleteNavigationMenuBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(NavigationMenu.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="navigationMenuId")})
    @Path(value="/navigation-menus/{navigationMenuId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="NavigationMenu")})
    public NavigationMenu getNavigationMenu(@NotNull @Parameter(hidden=true) @PathParam(value="navigationMenuId") Long navigationMenuId) throws Exception {
        return new NavigationMenu();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the navigation menu with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="navigationMenuId")})
    @Path(value="/navigation-menus/{navigationMenuId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="NavigationMenu")})
    public NavigationMenu putNavigationMenu(@NotNull @Parameter(hidden=true) @PathParam(value="navigationMenuId") Long navigationMenuId, NavigationMenu navigationMenu) throws Exception {
        return new NavigationMenu();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/navigation-menus/batch")
    @Produces(value={"application/json"})
    @PUT
    @Tags(value={@Tag(name="NavigationMenu")})
    public Response putNavigationMenuBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(NavigationMenu.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="navigationMenuId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/navigation-menus/{navigationMenuId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="NavigationMenu")})
    public Page<Permission> getNavigationMenuPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="navigationMenuId") Long navigationMenuId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(navigationMenuId);
        Long resourceId = this.getPermissionCheckerResourceId(navigationMenuId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(navigationMenuId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getNavigationMenuPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putNavigationMenuPermission", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="navigationMenuId")})
    @Path(value="/navigation-menus/{navigationMenuId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="NavigationMenu")})
    public Page<Permission> putNavigationMenuPermission(@NotNull @Parameter(hidden=true) @PathParam(value="navigationMenuId") Long navigationMenuId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(navigationMenuId);
        Long resourceId = this.getPermissionCheckerResourceId(navigationMenuId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(navigationMenuId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(navigationMenuId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getNavigationMenuPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putNavigationMenuPermission", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @GET
    @Operation(description="")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Path(value="/sites/{siteId}/navigation-menus")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="NavigationMenu")})
    public Page<NavigationMenu> getSiteNavigationMenusPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new navigation menu.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/navigation-menus")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="NavigationMenu")})
    public NavigationMenu postSiteNavigationMenu(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, NavigationMenu navigationMenu) throws Exception {
        return new NavigationMenu();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/sites/{siteId}/navigation-menus/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="NavigationMenu")})
    public Response postSiteNavigationMenuBatch(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(NavigationMenu.class.getName(), callbackURL, null, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/sites/{siteId}/navigation-menus/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="NavigationMenu")})
    public Page<Permission> getSiteNavigationMenuPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteNavigationMenuPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteNavigationMenuPermission", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/navigation-menus/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="NavigationMenu")})
    public Page<Permission> putSiteNavigationMenuPermission(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteNavigationMenuPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteNavigationMenuPermission", portletName, siteId)).build(), siteId, portletName, null);
    }

    public void create(Collection<NavigationMenu> navigationMenus, Map<String, Serializable> parameters) throws Exception {
        for (NavigationMenu navigationMenu : navigationMenus) {
            this.postSiteNavigationMenu(Long.parseLong((String)((Object)parameters.get("siteId"))), navigationMenu);
        }
    }

    public void delete(Collection<NavigationMenu> navigationMenus, Map<String, Serializable> parameters) throws Exception {
        for (NavigationMenu navigationMenu : navigationMenus) {
            this.deleteNavigationMenu(navigationMenu.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<NavigationMenu> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getSiteNavigationMenusPage(Long.parseLong((String)((Object)parameters.get("siteId"))), pagination);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<NavigationMenu> navigationMenus, Map<String, Serializable> parameters) throws Exception {
        for (NavigationMenu navigationMenu : navigationMenus) {
            this.putNavigationMenu(navigationMenu.getId() != null ? navigationMenu.getId() : Long.parseLong((String)((Object)parameters.get("navigationMenuId"))), navigationMenu);
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

