/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.NavigationMenu;
import com.liferay.headless.delivery.dto.v1_0.NavigationMenuItem;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseNavigationMenuResourceImpl;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseSitePageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.NavigationMenuResource;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemService;
import com.liferay.site.navigation.service.SiteNavigationMenuService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/navigation-menu.properties"}, scope=ServiceScope.PROTOTYPE, service={NavigationMenuResource.class})
public class NavigationMenuResourceImpl
extends BaseNavigationMenuResourceImpl {
    @Reference
    private LayoutFriendlyURLLocalService _layoutFriendlyURLLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SiteNavigationMenuItemService _siteNavigationMenuItemService;
    @Reference
    private SiteNavigationMenuService _siteNavigationMenuService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteNavigationMenu(Long navigationMenuId) throws Exception {
        this._siteNavigationMenuService.deleteSiteNavigationMenu(navigationMenuId.longValue());
    }

    @Override
    public NavigationMenu getNavigationMenu(Long navigationMenuId) throws Exception {
        return this._toNavigationMenu(this._siteNavigationMenuService.fetchSiteNavigationMenu(navigationMenuId.longValue()));
    }

    @Override
    public Page<NavigationMenu> getSiteNavigationMenusPage(Long siteId, Pagination pagination) {
        return Page.of(Collections.singletonMap("create", this.addAction("ADD_SITE_NAVIGATION_MENU", "postSiteNavigationMenu", "com.liferay.site.navigation", siteId)), this.transform(this._siteNavigationMenuService.getSiteNavigationMenus(siteId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toNavigationMenu), (Pagination)pagination, (long)this._siteNavigationMenuService.getSiteNavigationMenusCount(siteId.longValue()));
    }

    @Override
    public NavigationMenu postSiteNavigationMenu(Long siteId, NavigationMenu navigationMenu) throws Exception {
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuService.addSiteNavigationMenu(siteId.longValue(), navigationMenu.getName(), 0, true, ServiceContextRequestUtil.createServiceContext((long)siteId, (HttpServletRequest)this.contextHttpServletRequest, null));
        this._createNavigationMenuItems(navigationMenu.getNavigationMenuItems(), 0L, siteId, siteNavigationMenu.getSiteNavigationMenuId());
        return this._toNavigationMenu(siteNavigationMenu);
    }

    @Override
    public NavigationMenu putNavigationMenu(Long navigationMenuId, NavigationMenu navigationMenu) throws Exception {
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuService.fetchSiteNavigationMenu(navigationMenuId.longValue());
        this._updateNavigationMenuItems(navigationMenu.getNavigationMenuItems(), 0L, siteNavigationMenu.getGroupId(), siteNavigationMenu.getSiteNavigationMenuId());
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext((long)siteNavigationMenu.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null);
        NavigationMenu.NavigationType navigationType = navigationMenu.getNavigationType();
        if (navigationType != null) {
            this._siteNavigationMenuService.updateSiteNavigationMenu(navigationMenuId.longValue(), navigationType.ordinal() + 1, true, serviceContext);
        }
        return this._toNavigationMenu(this._siteNavigationMenuService.updateSiteNavigationMenu(navigationMenuId.longValue(), navigationMenu.getName(), serviceContext));
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuService.fetchSiteNavigationMenu(((Long)id).longValue());
        return siteNavigationMenu.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.site.navigation";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return SiteNavigationMenu.class.getName();
    }

    private void _createNavigationMenuItem(NavigationMenuItem navigationMenuItem, long parentNavigationMenuId, long siteId, long siteNavigationMenuId) throws Exception {
        String unicodeProperties = this._getUnicodeProperties(true, navigationMenuItem, siteId, null);
        SiteNavigationMenuItem siteNavigationMenuItem = this._siteNavigationMenuItemService.addSiteNavigationMenuItem(siteId, siteNavigationMenuId, parentNavigationMenuId, this._getType(navigationMenuItem), unicodeProperties, ServiceContextRequestUtil.createServiceContext((long)siteId, (HttpServletRequest)this.contextHttpServletRequest, null));
        this._createNavigationMenuItems(navigationMenuItem.getNavigationMenuItems(), siteNavigationMenuItem.getSiteNavigationMenuItemId(), siteId, siteNavigationMenuId);
    }

    private void _createNavigationMenuItems(NavigationMenuItem[] navigationMenuItems, long parentNavigationMenuId, long siteId, long siteNavigationMenuId) throws Exception {
        if (navigationMenuItems == null) {
            return;
        }
        for (NavigationMenuItem navigationMenuItem : navigationMenuItems) {
            this._createNavigationMenuItem(navigationMenuItem, parentNavigationMenuId, siteId, siteNavigationMenuId);
        }
    }

    private Layout _getLayout(SiteNavigationMenuItem siteNavigationMenuItem) {
        UnicodeProperties unicodeProperties = this._getUnicodeProperties(siteNavigationMenuItem);
        String layoutUuid = (String)unicodeProperties.get((Object)"layoutUuid");
        boolean privateLayout = GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"privateLayout")));
        return this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, siteNavigationMenuItem.getGroupId(), privateLayout);
    }

    private Layout _getLayout(String link, long siteId) throws Exception {
        Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(siteId, false, link);
        if (layout == null) {
            layout = this._layoutLocalService.getLayoutByFriendlyURL(siteId, true, link);
        }
        return layout;
    }

    private Locale _getLocaleFromProperty(Map.Entry<String, String> property) {
        return LocaleUtil.fromLanguageId((String)StringUtil.removeSubstring((String)property.getKey(), (String)"name_"));
    }

    private Map<Locale, String> _getLocalizedNamesFromProperties(UnicodeProperties unicodeProperties) {
        if (unicodeProperties == null) {
            return new HashMap<Locale, String>();
        }
        Set properties = unicodeProperties.entrySet();
        Stream propertiesStream = properties.stream();
        return propertiesStream.filter(this::_isNameProperty).collect(Collectors.toMap(this::_getLocaleFromProperty, Map.Entry::getValue));
    }

    private String _getName(UnicodeProperties unicodeProperties) {
        String preferredLanguageId = this.contextAcceptLanguage.getPreferredLanguageId();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        return unicodeProperties.getProperty("name_" + preferredLanguageId, unicodeProperties.getProperty("name_" + defaultLanguageId));
    }

    private Map<Long, List<SiteNavigationMenuItem>> _getSiteNavigationMenuItemsMap(List<SiteNavigationMenuItem> siteNavigationMenuItems) {
        HashMap<Long, List<SiteNavigationMenuItem>> siteNavigationMenuItemsMap = new HashMap<Long, List<SiteNavigationMenuItem>>();
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            long parentSiteNavigationMenuItemId = siteNavigationMenuItem.getParentSiteNavigationMenuItemId();
            if (siteNavigationMenuItemsMap.containsKey(parentSiteNavigationMenuItemId)) continue;
            for (SiteNavigationMenuItem childSiteNavigationMenuItem : siteNavigationMenuItems) {
                if (parentSiteNavigationMenuItemId != childSiteNavigationMenuItem.getParentSiteNavigationMenuItemId()) continue;
                List parentSiteNavigationMenuItems = siteNavigationMenuItemsMap.getOrDefault(parentSiteNavigationMenuItemId, new ArrayList());
                parentSiteNavigationMenuItems.add(childSiteNavigationMenuItem);
                siteNavigationMenuItemsMap.put(parentSiteNavigationMenuItemId, parentSiteNavigationMenuItems);
            }
        }
        return siteNavigationMenuItemsMap;
    }

    private String _getType(NavigationMenuItem navigationMenuItem) {
        if (navigationMenuItem.getLink() != null) {
            return "layout";
        }
        if (navigationMenuItem.getUrl() != null) {
            return "url";
        }
        return "node";
    }

    private String _getUnicodeProperties(boolean add, NavigationMenuItem navigationMenuItem, long siteId, SiteNavigationMenuItem siteNavigationMenuItem) throws Exception {
        UnicodeProperties unicodeProperties = new UnicodeProperties(true);
        if (navigationMenuItem.getLink() != null) {
            unicodeProperties.setProperty("defaultLanguageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
            Layout layout = this._getLayout(navigationMenuItem.getLink(), siteId);
            unicodeProperties.setProperty("groupId", String.valueOf(layout.getGroupId()));
            unicodeProperties.setProperty("layoutUuid", layout.getUuid());
            Map nameMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)navigationMenuItem.getName(), (Map)navigationMenuItem.getName_i18n(), this._getLocalizedNamesFromProperties(this._getUnicodeProperties(siteNavigationMenuItem)));
            for (Map.Entry entry : nameMap.entrySet()) {
                unicodeProperties.setProperty("name_" + LocaleUtil.toLanguageId((Locale)((Locale)entry.getKey())), (String)nameMap.get(entry.getKey()));
            }
            unicodeProperties.setProperty("privateLayout", String.valueOf(layout.isPrivateLayout()));
            unicodeProperties.setProperty("useCustomName", String.valueOf(navigationMenuItem.getUseCustomName()));
        } else {
            Map nameMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)navigationMenuItem.getName(), (Map)navigationMenuItem.getName_i18n(), this._getLocalizedNamesFromProperties(this._getUnicodeProperties(siteNavigationMenuItem)));
            LocalizedMapUtil.validateI18n((boolean)add, (Locale)LocaleUtil.getSiteDefault(), (String)"Navigation Menu item", (Map)nameMap, new HashSet());
            unicodeProperties.setProperty("defaultLanguageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
            for (Map.Entry entry : nameMap.entrySet()) {
                unicodeProperties.setProperty("name_" + LocaleUtil.toLanguageId((Locale)((Locale)entry.getKey())), (String)nameMap.get(entry.getKey()));
            }
            if (navigationMenuItem.getUrl() != null) {
                unicodeProperties.setProperty("url", navigationMenuItem.getUrl());
            }
        }
        return unicodeProperties.toString();
    }

    private UnicodeProperties _getUnicodeProperties(SiteNavigationMenuItem siteNavigationMenuItem) {
        if (siteNavigationMenuItem == null) {
            return null;
        }
        UnicodeProperties unicodeProperties = new UnicodeProperties();
        unicodeProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
        return unicodeProperties;
    }

    private boolean _isNameProperty(Map.Entry<String, String> property) {
        String propertyKey = property.getKey();
        return propertyKey.startsWith("name_");
    }

    private NavigationMenu _toNavigationMenu(final SiteNavigationMenu siteNavigationMenu) {
        List siteNavigationMenuItems = this._siteNavigationMenuItemService.getSiteNavigationMenuItems(siteNavigationMenu.getSiteNavigationMenuId());
        final Map<Long, List<SiteNavigationMenuItem>> siteNavigationMenuItemsMap = this._getSiteNavigationMenuItemsMap(siteNavigationMenuItems);
        return new NavigationMenu(){
            {
                this.creator = CreatorUtil.toCreator((Portal)NavigationMenuResourceImpl.this._portal, Optional.of(NavigationMenuResourceImpl.this.contextUriInfo), (User)NavigationMenuResourceImpl.this._userLocalService.fetchUser(siteNavigationMenu.getUserId()));
                this.dateCreated = siteNavigationMenu.getCreateDate();
                this.dateModified = siteNavigationMenu.getModifiedDate();
                this.id = siteNavigationMenu.getSiteNavigationMenuId();
                this.name = siteNavigationMenu.getName();
                this.navigationMenuItems = (NavigationMenuItem[])NavigationMenuResourceImpl.this.transformToArray(siteNavigationMenuItemsMap.getOrDefault(0L, new ArrayList()), siteNavigationMenuItem -> NavigationMenuResourceImpl.this._toNavigationMenuItem(siteNavigationMenuItem, siteNavigationMenuItemsMap), NavigationMenuItem.class);
                this.siteId = siteNavigationMenu.getGroupId();
                this.setActions(() -> HashMapBuilder.put((Object)"delete", NavigationMenuResourceImpl.this.addAction("DELETE", (GroupedModel)siteNavigationMenu, "deleteNavigationMenu")).put((Object)"replace", NavigationMenuResourceImpl.this.addAction("UPDATE", (GroupedModel)siteNavigationMenu, "putNavigationMenu")).build());
                this.setNavigationType(() -> {
                    if (siteNavigationMenu.getType() == 0) {
                        return null;
                    }
                    return NavigationMenu.NavigationType.values()[siteNavigationMenu.getType() - 1];
                });
            }
        };
    }

    private NavigationMenuItem _toNavigationMenuItem(final SiteNavigationMenuItem siteNavigationMenuItem, final Map<Long, List<SiteNavigationMenuItem>> siteNavigationMenuItemsMap) {
        final Layout layout = this._getLayout(siteNavigationMenuItem);
        final UnicodeProperties unicodeProperties = this._getUnicodeProperties(siteNavigationMenuItem);
        final Map<Locale, String> localizedMap = this._getLocalizedNamesFromProperties(unicodeProperties);
        return new NavigationMenuItem(){
            {
                this.creator = CreatorUtil.toCreator((Portal)NavigationMenuResourceImpl.this._portal, Optional.of(NavigationMenuResourceImpl.this.contextUriInfo), (User)NavigationMenuResourceImpl.this._userLocalService.fetchUser(siteNavigationMenuItem.getUserId()));
                this.dateCreated = siteNavigationMenuItem.getCreateDate();
                this.dateModified = siteNavigationMenuItem.getModifiedDate();
                this.id = siteNavigationMenuItem.getSiteNavigationMenuItemId();
                this.navigationMenuItems = (NavigationMenuItem[])NavigationMenuResourceImpl.this.transformToArray(siteNavigationMenuItemsMap.getOrDefault(siteNavigationMenuItem.getSiteNavigationMenuItemId(), new ArrayList()), item -> NavigationMenuResourceImpl.this._toNavigationMenuItem(item, siteNavigationMenuItemsMap), NavigationMenuItem.class);
                this.type = NavigationMenuResourceImpl.this._toType(siteNavigationMenuItem.getType());
                this.url = unicodeProperties.getProperty("url");
                this.setAvailableLanguages(() -> {
                    Set locales = localizedMap.keySet();
                    return LocaleUtil.toW3cLanguageIds((Locale[])locales.toArray(new Locale[localizedMap.size()]));
                });
                this.setLink(() -> {
                    if (layout == null) {
                        return null;
                    }
                    return layout.getFriendlyURL(NavigationMenuResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                });
                this.setLink_i18n(() -> {
                    if (layout == null || !NavigationMenuResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages()) {
                        return null;
                    }
                    HashMap<String, String> i18nMap = new HashMap<String, String>();
                    List layoutFriendlyURLs = NavigationMenuResourceImpl.this._layoutFriendlyURLLocalService.getLayoutFriendlyURLs(layout.getPlid());
                    for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
                        i18nMap.put(LocaleUtil.toBCP47LanguageId((String)layoutFriendlyURL.getLanguageId()), layoutFriendlyURL.getFriendlyURL());
                    }
                    return i18nMap;
                });
                this.setName(() -> {
                    String name = NavigationMenuResourceImpl.this._getName(unicodeProperties);
                    if (name == null && layout != null) {
                        return layout.getName(NavigationMenuResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                    }
                    return name;
                });
                this.setName_i18n(() -> {
                    if (NavigationMenuResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages()) {
                        Map localizedNames = NavigationMenuResourceImpl.this._getLocalizedNamesFromProperties(unicodeProperties);
                        if (localizedNames.isEmpty() && layout != null) {
                            localizedNames = layout.getNameMap();
                        }
                        return LocalizedMapUtil.getI18nMap((boolean)true, (Map)localizedNames);
                    }
                    return null;
                });
                this.setSitePageURL(() -> {
                    if (layout == null) {
                        return null;
                    }
                    ArrayList<Object> arguments = new ArrayList<Object>();
                    arguments.add(layout.getGroupId());
                    String friendlyURL = layout.getFriendlyURL(NavigationMenuResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                    arguments.add(friendlyURL.substring(1));
                    return JaxRsLinkUtil.getJaxRsLink((String)"headless-delivery", BaseSitePageResourceImpl.class, (String)"getSiteSitePage", (UriInfo)NavigationMenuResourceImpl.this.contextUriInfo, (Object[])arguments.toArray(new Object[0]));
                });
                this.setUseCustomName(() -> {
                    if (layout == null) {
                        return null;
                    }
                    return Boolean.valueOf(unicodeProperties.getProperty("useCustomName", "false"));
                });
            }
        };
    }

    private String _toType(String type) {
        if (type.equals("layout")) {
            return "page";
        }
        if (type.equals("node")) {
            return "navigationMenu";
        }
        return type;
    }

    private void _updateNavigationMenuItems(NavigationMenuItem[] navigationMenuItems, long parentSiteNavigationMenuId, Long siteId, long siteNavigationMenuId) throws Exception {
        ArrayList siteNavigationMenuItems = new ArrayList(this._siteNavigationMenuItemService.getSiteNavigationMenuItems(siteNavigationMenuId, parentSiteNavigationMenuId));
        if (navigationMenuItems != null) {
            for (NavigationMenuItem navigationMenuItem : navigationMenuItems) {
                Long navigationMenuItemId;
                Stream stream = siteNavigationMenuItems.stream();
                Optional<SiteNavigationMenuItem> siteNavigationMenuItemOptional = stream.filter(arg_0 -> NavigationMenuResourceImpl.lambda$_updateNavigationMenuItems$0(navigationMenuItemId = navigationMenuItem.getId(), arg_0)).findFirst();
                if (siteNavigationMenuItemOptional.isPresent()) {
                    SiteNavigationMenuItem existingSiteNavigationMenuItem = siteNavigationMenuItemOptional.get();
                    SiteNavigationMenuItem siteNavigationMenuItem = this._siteNavigationMenuItemService.updateSiteNavigationMenuItem(navigationMenuItemId.longValue(), this._getUnicodeProperties(false, navigationMenuItem, siteId, existingSiteNavigationMenuItem), ServiceContextRequestUtil.createServiceContext((long)siteId, (HttpServletRequest)this.contextHttpServletRequest, null));
                    this._updateNavigationMenuItems(navigationMenuItem.getNavigationMenuItems(), siteNavigationMenuItem.getSiteNavigationMenuItemId(), siteId, siteNavigationMenuId);
                    siteNavigationMenuItems.remove(existingSiteNavigationMenuItem);
                    continue;
                }
                this._createNavigationMenuItem(navigationMenuItem, parentSiteNavigationMenuId, siteId, siteNavigationMenuId);
            }
        }
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            this._siteNavigationMenuItemService.deleteSiteNavigationMenuItem(siteNavigationMenuItem.getSiteNavigationMenuItemId());
        }
    }

    private static /* synthetic */ boolean lambda$_updateNavigationMenuItems$0(Long navigationMenuItemId, SiteNavigationMenuItem siteNavigationMenuItem) {
        return Objects.equals(siteNavigationMenuItem.getSiteNavigationMenuItemId(), navigationMenuItemId);
    }
}

