/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.delivery.dto.v1_0.DocumentFolder;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Locale;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.document.library.kernel.model.DLFolder"}, service={DocumentFolderDTOConverter.class, DTOConverter.class})
public class DocumentFolderDTOConverter
implements DTOConverter<DLFolder, DocumentFolder> {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return DocumentFolder.class.getSimpleName();
    }

    public DocumentFolder toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final Folder folder = this._dlAppService.getFolder(((Long)dtoConverterContext.getId()).longValue());
        final Group group = this._groupLocalService.fetchGroup(folder.getGroupId());
        return new DocumentFolder(){
            {
                this.actions = dtoConverterContext.getActions();
                this.assetLibraryKey = GroupUtil.getAssetLibraryKey((Group)group);
                this.creator = CreatorUtil.toCreator((Portal)DocumentFolderDTOConverter.this._portal, (Optional)dtoConverterContext.getUriInfoOptional(), (User)DocumentFolderDTOConverter.this._userLocalService.fetchUser(folder.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)DLFolder.class.getName(), (long)folder.getFolderId(), (long)folder.getCompanyId(), (Locale)dtoConverterContext.getLocale());
                this.dateCreated = folder.getCreateDate();
                this.dateModified = folder.getModifiedDate();
                this.description = folder.getDescription();
                this.id = folder.getFolderId();
                this.name = folder.getName();
                this.numberOfDocumentFolders = DocumentFolderDTOConverter.this._dlAppService.getFoldersCount(folder.getRepositoryId(), folder.getFolderId());
                this.numberOfDocuments = DocumentFolderDTOConverter.this._dlAppService.getFileEntriesCount(folder.getRepositoryId(), folder.getFolderId());
                this.siteId = GroupUtil.getSiteId((Group)group);
                this.subscribed = DocumentFolderDTOConverter.this._subscriptionLocalService.isSubscribed(folder.getCompanyId(), dtoConverterContext.getUserId(), DLFolder.class.getName(), folder.getFolderId());
                this.setParentDocumentFolderId(() -> {
                    if (folder.getParentFolderId() == 0L) {
                        return null;
                    }
                    return folder.getParentFolderId();
                });
            }
        };
    }
}

