/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapperTracker;
import com.liferay.headless.delivery.internal.dto.v1_0.util.PageElementUtil;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.LayoutStructureItem"}, service={DTOConverter.class, PageElementDTOConverter.class})
public class PageElementDTOConverter
implements DTOConverter<LayoutStructureItem, PageElement> {
    @Reference
    private LayoutStructureItemMapperTracker _layoutStructureItemMapperTracker;

    public String getContentType() {
        return PageElement.class.getSimpleName();
    }

    public PageElement toDTO(DTOConverterContext dtoConverterContext, LayoutStructureItem layoutStructureItem) throws Exception {
        Object groupIdObject = dtoConverterContext.getAttribute("groupId");
        if (groupIdObject == null) {
            throw new IllegalArgumentException("Group ID is not defined for layout structure item " + layoutStructureItem.getItemId());
        }
        long groupId = GetterUtil.getLong((Object)groupIdObject);
        LayoutStructure layoutStructure = Optional.ofNullable(dtoConverterContext.getAttribute("layoutStructure")).map(LayoutStructure.class::cast).orElseThrow(() -> new IllegalArgumentException("Layout structure is not defined for layout structure item " + layoutStructureItem.getItemId()));
        boolean saveInlineContent = GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("saveInlineContent"), (boolean)true);
        boolean saveMappingConfiguration = GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("saveMappingConfiguration"), (boolean)true);
        return PageElementUtil.toPageElement(groupId, layoutStructure, layoutStructureItem, this._layoutStructureItemMapperTracker, saveInlineContent, saveMappingConfiguration);
    }
}

